/*
 * Decompiled with CFR 0.152.
 */
package sbgc.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextPane;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;
import org.jdesktop.application.Action;
import org.jdesktop.application.Application;
import org.jdesktop.application.ApplicationActionMap;
import org.jdesktop.application.ResourceMap;
import org.netbeans.lib.awtextra.AbsoluteConstraints;
import org.netbeans.lib.awtextra.AbsoluteLayout;
import sbgc.object.BoardInfo;
import sbgc.object.BoardParams;
import sbgc.object.BoardProfile;
import sbgc.script_parser.manager.BinaryReader;
import sbgc.script_parser.manager.CommandException;
import sbgc.script_parser.manager.ParserException;
import sbgc.script_parser.manager.ScriptParser;
import sbgc.script_parser.script.ScriptProgram;
import sbgc.script_parser.utils.FileHelper;
import sbgc.service.SerialCommand;
import sbgc.service.SerialCommandProcessor;
import sbgc.ui.ConsoleJList;
import sbgc.ui.DeviceSlotJComboBox;
import sbgc.ui.EditorJTextPane;
import sbgc.ui.ITabbedPanel;
import sbgc.ui.TabbedPanelBase;
import sbgc.utils.BGCJFileLoader;
import sbgc.utils.BGCJFileSaver;
import sbgc.utils.Log;
import simplebgc_gui.ScriptHighlighter;
import simplebgc_gui.SimpleBGC_GUIApp;
import simplebgc_gui.SimpleBGC_GUIView;

public class TabbedPanelScripting
extends TabbedPanelBase
implements ITabbedPanel {
    private static final Log logger = new Log(Logger.getLogger((String)TabbedPanelScripting.class.getName()));
    private ScriptProgram curScriptProgram = null;
    private DefaultListModel scriptStatusModel = new DefaultListModel();
    private boolean isScriptRun = false;
    private JPanel groupScripting;
    private JButton jButtonScriptLoadFile;
    private JButton jButtonScriptRead;
    private JButton jButtonScriptRun;
    private JButton jButtonScriptSaveFile;
    private JButton jButtonScriptValidate;
    private JButton jButtonScriptWrite;
    private JComboBox jComboBoxScriptSlot;
    private JLabel jLabel99;
    private JLabel jLabelScriptingFile;
    private JLabel jLabelScriptingReference;
    private JList jListScriptStatus;
    private JPanel jPanel1;
    private JScrollPane jScrollPane3;
    private JScrollPane jScrollPane4;
    private JSplitPane jSplitPane1;
    private JTextPane jTextPaneScript;

    public TabbedPanelScripting(SimpleBGC_GUIView mainView) {
        super(mainView);
        this.initComponents();
        this.prepareLayout();
        SimpleBGC_GUIView.setLabelLink(this.jLabelScriptingReference, null, SimpleBGC_GUIApp.SCRIPTING_REFERENCE_URI);
    }

    private void initComponents() {
        this.groupScripting = new JPanel();
        this.jButtonScriptLoadFile = new JButton();
        this.jLabelScriptingFile = new JLabel();
        this.jButtonScriptSaveFile = new JButton();
        this.jLabel99 = new JLabel();
        this.jButtonScriptWrite = new JButton();
        this.jButtonScriptRead = new JButton();
        this.jComboBoxScriptSlot = new DeviceSlotJComboBox();
        this.jButtonScriptValidate = new JButton();
        this.jSplitPane1 = new JSplitPane();
        this.jScrollPane3 = new JScrollPane();
        this.jPanel1 = new JPanel();
        this.jTextPaneScript = new EditorJTextPane();
        this.jScrollPane4 = new JScrollPane();
        this.jListScriptStatus = new ConsoleJList(this.jTextPaneScript);
        this.jButtonScriptRun = new JButton();
        this.jLabelScriptingReference = new JLabel();
        this.setName("Scripting");
        this.setLayout(null);
        this.groupScripting.setName("groupScripting");
        this.groupScripting.setLayout((LayoutManager)new AbsoluteLayout());
        ResourceMap resourceMap = Application.getInstance(SimpleBGC_GUIApp.class).getContext().getResourceMap(TabbedPanelScripting.class);
        this.jButtonScriptLoadFile.setText(resourceMap.getString("jButtonScriptLoadFile.text", new Object[0]));
        this.jButtonScriptLoadFile.setName("jButtonScriptLoadFile");
        this.jButtonScriptLoadFile.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TabbedPanelScripting.this.jButtonScriptLoadFileActionPerformed(evt);
            }
        });
        this.groupScripting.add((Component)this.jButtonScriptLoadFile, new AbsoluteConstraints(70, 10, 80, -1));
        this.jLabelScriptingFile.setHorizontalAlignment(0);
        this.jLabelScriptingFile.setText(resourceMap.getString("jLabelScriptingFile.text", new Object[0]));
        this.jLabelScriptingFile.setName("jLabelScriptingFile");
        this.groupScripting.add((Component)this.jLabelScriptingFile, new AbsoluteConstraints(0, 10, 70, 20));
        this.jButtonScriptSaveFile.setText(resourceMap.getString("jButtonScriptSaveFile.text", new Object[0]));
        this.jButtonScriptSaveFile.setName("jButtonScriptSaveFile");
        this.jButtonScriptSaveFile.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TabbedPanelScripting.this.jButtonScriptSaveFileActionPerformed(evt);
            }
        });
        this.groupScripting.add((Component)this.jButtonScriptSaveFile, new AbsoluteConstraints(160, 10, 80, -1));
        this.jLabel99.setHorizontalAlignment(0);
        this.jLabel99.setText(resourceMap.getString("jLabel99.text", new Object[0]));
        this.jLabel99.setName("jLabel99");
        this.groupScripting.add((Component)this.jLabel99, new AbsoluteConstraints(240, 10, 80, 20));
        ApplicationActionMap actionMap = Application.getInstance(SimpleBGC_GUIApp.class).getContext().getActionMap(TabbedPanelScripting.class, this);
        this.jButtonScriptWrite.setAction(actionMap.get("buttonScriptWrite"));
        this.jButtonScriptWrite.setText(resourceMap.getString("jButtonScriptWrite.text", new Object[0]));
        this.jButtonScriptWrite.setName("jButtonScriptWrite");
        this.groupScripting.add((Component)this.jButtonScriptWrite, new AbsoluteConstraints(540, 10, 80, -1));
        this.jButtonScriptRead.setAction(actionMap.get("buttonScriptRead"));
        this.jButtonScriptRead.setText(resourceMap.getString("jButtonScriptRead.text", new Object[0]));
        this.jButtonScriptRead.setName("jButtonScriptRead");
        this.groupScripting.add((Component)this.jButtonScriptRead, new AbsoluteConstraints(460, 10, 80, -1));
        this.jComboBoxScriptSlot.setName("jComboBoxScriptSlot");
        this.groupScripting.add((Component)this.jComboBoxScriptSlot, new AbsoluteConstraints(320, 10, 130, -1));
        this.jButtonScriptValidate.setText(resourceMap.getString("jButtonScriptValidate.text", new Object[0]));
        this.jButtonScriptValidate.setName("jButtonScriptValidate");
        this.jButtonScriptValidate.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TabbedPanelScripting.this.jButtonScriptValidateActionPerformed(evt);
            }
        });
        this.groupScripting.add((Component)this.jButtonScriptValidate, new AbsoluteConstraints(590, 50, 130, -1));
        this.jSplitPane1.setDividerLocation(250);
        this.jSplitPane1.setDividerSize(4);
        this.jSplitPane1.setOrientation(0);
        this.jSplitPane1.setName("jSplitPane1");
        this.jScrollPane3.setName("jScrollPane3");
        this.jPanel1.setName("jPanel1");
        this.jPanel1.setLayout(new BorderLayout());
        this.jTextPaneScript.setBackground(resourceMap.getColor("jTextPaneScript.background"));
        this.jTextPaneScript.setForeground(resourceMap.getColor("jTextPaneScript.foreground"));
        this.jTextPaneScript.setCaretColor(resourceMap.getColor("jTextPaneScript.caretColor"));
        this.jTextPaneScript.setName("jTextPaneScript");
        this.jPanel1.add((Component)this.jTextPaneScript, "Center");
        this.jScrollPane3.setViewportView(this.jPanel1);
        this.jSplitPane1.setTopComponent(this.jScrollPane3);
        this.jScrollPane4.setName("jScrollPane4");
        this.scriptStatusModel.clear();
        this.scriptStatusModel.addElement("");
        this.jListScriptStatus.setModel(this.scriptStatusModel);
        this.jListScriptStatus.setSelectionMode(0);
        this.jListScriptStatus.setName("jListScriptStatus");
        this.jScrollPane4.setViewportView(this.jListScriptStatus);
        this.jSplitPane1.setRightComponent(this.jScrollPane4);
        this.groupScripting.add((Component)this.jSplitPane1, new AbsoluteConstraints(1, 40, 570, 300));
        this.jButtonScriptRun.setAction(actionMap.get("buttonScriptRun"));
        this.jButtonScriptRun.setText(resourceMap.getString("jButtonScriptRun.text", new Object[0]));
        this.jButtonScriptRun.setName("jButtonScriptRun");
        this.groupScripting.add((Component)this.jButtonScriptRun, new AbsoluteConstraints(630, 10, 90, -1));
        this.jLabelScriptingReference.setHorizontalAlignment(0);
        this.jLabelScriptingReference.setText(resourceMap.getString("jLabelScriptingReference.text", new Object[0]));
        this.jLabelScriptingReference.setName("jLabelScriptingReference");
        this.groupScripting.add((Component)this.jLabelScriptingReference, new AbsoluteConstraints(580, 310, 140, -1));
        this.add(this.groupScripting);
        this.groupScripting.setBounds(0, 0, 720, 340);
    }

    private void jButtonScriptLoadFileActionPerformed(ActionEvent evt) {
        if (((EditorJTextPane)this.jTextPaneScript).isChanged()) {
            int reply = ((EditorJTextPane)this.jTextPaneScript).showSaveConfirmDialog();
            ((EditorJTextPane)this.jTextPaneScript).switchConfirmAnswer(reply, this.jButtonScriptSaveFile, this.jButtonScriptLoadFile);
            return;
        }
        String filePath = new BGCJFileLoader(this.groupScripting, new String[]{"txt"}, SimpleBGC_GUIApp.getResourceMap().getString("file_type.txt", new Object[0]), "scripting.last_used_script_dir").getFilePath();
        if (filePath == null) {
            return;
        }
        try {
            this.jTextPaneScript.setText(new FileHelper().readFile(filePath));
            logger.info("Reading " + filePath + " ...ok");
            this.addScriptStatusMessage(this.resourceMap.getString("status.script_loaded", filePath), true);
            this.curScriptProgram = this.validateScript();
            ((EditorJTextPane)this.jTextPaneScript).setIsChanged(false);
        }
        catch (IOException ex) {
            logger.error(ex.getCause().getMessage().toString());
        }
        this.jTextPaneScript.setCaretPosition(0);
    }

    private void jButtonScriptSaveFileActionPerformed(ActionEvent evt) {
        String filePath = new BGCJFileSaver(this.groupScripting, new String[]{"txt"}, SimpleBGC_GUIApp.getResourceMap().getString("file_type.txt", new Object[0]), "scripting.last_used_script_dir").getFilePath(null, true);
        if (filePath == null) {
            return;
        }
        try {
            new FileHelper().writeString(filePath, this.jTextPaneScript.getText());
            ((EditorJTextPane)this.jTextPaneScript).setIsChanged(false);
            this.addScriptStatusMessage(this.resourceMap.getString("status.script_saved", filePath), true);
        }
        catch (IOException ex) {
            logger.error(ex.getCause().getMessage().toString());
        }
    }

    private void jButtonScriptValidateActionPerformed(ActionEvent evt) {
        this.curScriptProgram = this.validateScript();
    }

    @Override
    public void updateBoardParams(BoardParams params) {
        BoardProfile p = params.profiles[params.curProfile];
    }

    @Override
    public void updateBoardVerUI() {
        BoardInfo info = BoardInfo.getBoardInfo();
        if (info != null) {
            ((DeviceSlotJComboBox)this.jComboBoxScriptSlot).updateScriptSlotsInfo(info.scriptSize);
        }
    }

    @Override
    public void applyBoardParams(BoardParams params) {
        BoardProfile p = params.profiles[params.curProfile];
    }

    private void setScriptNoErr() {
        ((ConsoleJList)this.jListScriptStatus).setNormalColor();
        ScriptHighlighter.highlightScriptErrors(this.jTextPaneScript, null);
    }

    private ScriptProgram validateScript() {
        try {
            ScriptProgram scriptProgram = new ScriptParser().parseScriptFromString(this.jTextPaneScript.getText().toString().trim());
            this.scriptStatusModel.clear();
            ((ConsoleJList)this.jListScriptStatus).setParserException(null);
            ((ConsoleJList)this.jListScriptStatus).disableMouseListener();
            if (scriptProgram == null) {
                ((ConsoleJList)this.jListScriptStatus).setErrorColor();
                this.scriptStatusModel.addElement(this.resourceMap.getString("status.validate.error", new Object[0]));
                return null;
            }
            this.setScriptNoErr();
            this.scriptStatusModel.addElement(this.resourceMap.getString("status.validate.ok", new Object[0]));
            this.jTextPaneScript.setCaretPosition(0);
            return scriptProgram;
        }
        catch (ParserException parserException) {
            this.scriptStatusModel.clear();
            ((ConsoleJList)this.jListScriptStatus).setParserException(parserException);
            ((ConsoleJList)this.jListScriptStatus).enableMouseListener();
            ((ConsoleJList)this.jListScriptStatus).setErrorColor();
            ScriptHighlighter.highlightScriptErrors(this.jTextPaneScript, parserException);
            for (CommandException cmdException : parserException.getErrors()) {
                this.scriptStatusModel.addElement(cmdException.toString());
            }
            this.jTextPaneScript.setCaretPosition(parserException.getErrors().get(0).getSymbolNum());
            logger.error(parserException.toString());
            return null;
        }
    }

    @Override
    public boolean onBeforeClose() {
        if (((EditorJTextPane)this.jTextPaneScript).isChanged()) {
            int confirmed = ((EditorJTextPane)this.jTextPaneScript).showSaveConfirmDialog();
            ((EditorJTextPane)this.jTextPaneScript).switchConfirmAnswer(confirmed, this.jButtonScriptSaveFile, null);
        }
        return true;
    }

    @Action(enabledProperty="connected")
    public void buttonScriptRead() {
        if (((EditorJTextPane)this.jTextPaneScript).isChanged()) {
            int reply = ((EditorJTextPane)this.jTextPaneScript).showSaveConfirmDialog();
            ((EditorJTextPane)this.jTextPaneScript).switchConfirmAnswer(reply, this.jButtonScriptSaveFile, this.jButtonScriptRead);
            return;
        }
        final int slotNumber = ((DeviceSlotJComboBox)this.jComboBoxScriptSlot).getSlotNumber();
        if (slotNumber > 0) {
            this.setScriptButtonsEnabled(false);
            new Thread(new Runnable(){

                @Override
                public void run() {
                    TabbedPanelScripting.this.mainView.onProgressStart(TabbedPanelScripting.this.resourceMap.getString("progress.reading_script", new Object[0]), false);
                    try {
                        byte[] data = FileHelper.readBoard(slotNumber, TabbedPanelScripting.this.mainView);
                        ScriptProgram scriptProgram = BinaryReader.readScriptProgram(data);
                        TabbedPanelScripting.this.jTextPaneScript.setText(scriptProgram.toScriptString());
                        TabbedPanelScripting.this.setScriptNoErr();
                        ((EditorJTextPane)TabbedPanelScripting.this.jTextPaneScript).setIsChanged(false);
                        TabbedPanelScripting.this.addScriptStatusMessage(TabbedPanelScripting.this.resourceMap.getString("status.read_script.done", slotNumber, data.length), true);
                    }
                    catch (Exception e) {
                        logger.error(e.toString());
                        TabbedPanelScripting.this.mainView.showErrorMessage(e.getMessage());
                    }
                    finally {
                        TabbedPanelScripting.this.mainView.onProgressFinish(true);
                        TabbedPanelScripting.this.setScriptButtonsEnabled(true);
                    }
                }
            }).start();
        } else {
            this.mainView.showErrorMessage(this.resourceMap.getString("error.select_script_slot", new Object[0]));
        }
    }

    @Action(enabledProperty="connected")
    public void buttonScriptWrite() {
        this.scriptWrite(false);
    }

    public void scriptWrite(final boolean andRun) {
        this.curScriptProgram = this.validateScript();
        if (this.curScriptProgram == null) {
            return;
        }
        final int slotNumber = ((DeviceSlotJComboBox)this.jComboBoxScriptSlot).getSlotNumber();
        if (slotNumber > 0) {
            this.setScriptButtonsEnabled(false);
            new Thread(new Runnable(){

                @Override
                public void run() {
                    TabbedPanelScripting.this.mainView.onProgressStart(TabbedPanelScripting.this.resourceMap.getString("progress.writing_script", new Object[0]), false);
                    try {
                        byte[] data = FileHelper.writeBoard(TabbedPanelScripting.this.curScriptProgram, slotNumber, TabbedPanelScripting.this.mainView);
                        ((EditorJTextPane)TabbedPanelScripting.this.jTextPaneScript).setIsChanged(false);
                        TabbedPanelScripting.this.addScriptStatusMessage(data == null ? TabbedPanelScripting.this.resourceMap.getString("status.delete_script.done", slotNumber) : TabbedPanelScripting.this.resourceMap.getString("status.write_script.done", slotNumber, data.length), true);
                        BoardInfo info = BoardInfo.getBoardInfo();
                        if (info != null) {
                            info.scriptSize[slotNumber - 1] = data != null ? data.length : 0;
                            ((DeviceSlotJComboBox)TabbedPanelScripting.this.jComboBoxScriptSlot).updateScriptSlotsInfo(info.scriptSize);
                        }
                        ((EditorJTextPane)TabbedPanelScripting.this.jTextPaneScript).setIsChanged(false);
                        if (andRun) {
                            SwingUtilities.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    try {
                                        TabbedPanelScripting.this.jButtonScriptRun.doClick();
                                    }
                                    catch (Exception exception) {
                                        // empty catch block
                                    }
                                }
                            });
                        }
                    }
                    catch (Exception e) {
                        logger.error(e.toString() + Log.formatStackTrace(e));
                        TabbedPanelScripting.this.mainView.showErrorMessage(e.getMessage());
                    }
                    finally {
                        TabbedPanelScripting.this.mainView.onProgressFinish(true);
                        TabbedPanelScripting.this.setScriptButtonsEnabled(true);
                    }
                }
            }).start();
        } else {
            this.mainView.showErrorMessage(this.resourceMap.getString("error.select_script_slot", new Object[0]));
        }
    }

    public void setScriptButtonsEnabled(boolean state) {
        this.jButtonScriptWrite.setEnabled(state);
        this.jButtonScriptRead.setEnabled(state);
        this.jButtonScriptLoadFile.setEnabled(state);
        this.jButtonScriptSaveFile.setEnabled(state);
    }

    @Action(enabledProperty="connected")
    public void buttonScriptRun() {
        int reply;
        if (!this.isScriptRun && ((EditorJTextPane)this.jTextPaneScript).isChanged() && (reply = ((EditorJTextPane)this.jTextPaneScript).showWriteConfirmDialog()) == 0) {
            this.scriptWrite(true);
            return;
        }
        int slotNumber = ((DeviceSlotJComboBox)this.jComboBoxScriptSlot).getSlotNumber();
        if (slotNumber > 0) {
            try {
                SerialCommand cmd = new SerialCommand(57);
                cmd.writeByte(this.isScriptRun ? 0 : 2);
                cmd.writeByte(slotNumber - 1);
                cmd.writeEmptyArr(32);
                SerialCommandProcessor.sendCommand(cmd);
                this.setScriptRunState(!this.isScriptRun);
            }
            catch (Exception e) {
                logger.error(e.toString());
            }
        }
    }

    public void setScriptRunState(boolean state) {
        this.isScriptRun = state;
        this.jButtonScriptRun.setText(this.resourceMap.getString(this.isScriptRun ? "jButtonScriptRun.text_stop" : "jButtonScriptRun.text", new Object[0]));
        this.jTextPaneScript.setEnabled(!this.isScriptRun);
        if (this.isScriptRun) {
            this.addScriptStatusMessage(this.resourceMap.getString("status.script_is_running", new Object[0]), false);
        }
    }

    public void addScriptStatusMessage(String message, boolean clear) {
        if (clear) {
            this.scriptStatusModel.clear();
        }
        this.scriptStatusModel.addElement(message);
        this.jListScriptStatus.ensureIndexIsVisible(this.scriptStatusModel.getSize() - 1);
    }

    public void processScriptDebugInfo(int cmdNumber, int error) {
        int lineNumber = cmdNumber;
        if (cmdNumber == 0) {
            this.setScriptRunState(false);
            if (error == 0) {
                this.addScriptStatusMessage(this.resourceMap.getString("status.script_is_finished", new Object[0]), false);
            }
        } else if (this.curScriptProgram != null) {
            lineNumber = this.curScriptProgram.cmdIdxToLineNumber(cmdNumber - 1);
        }
        if (error != 0) {
            this.addScriptStatusMessage("Error: " + SerialCommandProcessor.getFileErrorMessage(error), false);
        }
        ScriptHighlighter.highlightProgramLine2(this.jTextPaneScript, lineNumber);
    }
}

