/*
 * Decompiled with CFR 0.152.
 */
package sbgc.ui.chart;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.geom.Line2D;
import java.awt.image.BufferedImage;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.Locale;
import javax.swing.JPanel;
import sbgc.ui.chart.JRealTrace;
import sbgc.ui.chart.TraceDataPoint;

public class JRealChart
extends JPanel {
    private Image buf1;
    private Image buf2;
    private Image curBuf;
    private Image prevBuf;
    Image gridSideBuf;
    private static final double SHIFT_STEP_PER_UPDATE = 3.0;
    private static final int GRID_X_INTERVAL_MS = 1000;
    private double x_pos_time_scale;
    private long prevUpdateTime = 0L;
    private long startTime = 0L;
    private long lastGridXTime = 0L;
    double x_pos = 0.0;
    double x_pos_prev = 0.0;
    double shiftErr = 0.0;
    private int centerY;
    private float offsetY;
    private float zoomY = 0.1f;
    private int width;
    private int height;
    private Color gridColor = null;
    private Stroke gridStroke = null;
    private Stroke gridStrokeZero = null;
    private Color backgroundColor = null;
    private float minVal;
    private float maxVal;
    public static final Color DEFAULT_BACKGROUND_COLOR = new Color(255, 255, 255);
    public static final Color DEFAULT_GRID_COLOR = new Color(204, 204, 204);
    public static final Stroke DEFAULT_GRID_STROKE = new BasicStroke(1.0f);
    public static final Stroke DEFAULT_GRID_STROKE_ZERO = new BasicStroke(2.0f);
    public static final int GRID_SIDE_WIDTH = 50;
    public static final Font labelFont = new Font("Arial", 1, 9);
    public static final Color labelColor = new Color(153, 153, 153);
    public static final DecimalFormat labelFormatter = new DecimalFormat("#.##", new DecimalFormatSymbols(Locale.ENGLISH));
    private static final float MAX_VAL = 1000000.0f;
    public ArrayList<JRealTrace> traces;
    private boolean needUpdate = false;
    private int bufSize = 0;

    public JRealChart() {
        this.setVisible(true);
        this.backgroundColor = DEFAULT_BACKGROUND_COLOR;
        this.gridColor = DEFAULT_GRID_COLOR;
        this.gridStroke = DEFAULT_GRID_STROKE;
        this.gridStrokeZero = DEFAULT_GRID_STROKE_ZERO;
        this.traces = new ArrayList();
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                JRealChart.this.onResize();
            }
        });
    }

    void onResize() {
        this.bufSize = (int)((double)(this.getWidth() + 50) / 3.0);
        for (JRealTrace trace : this.traces) {
            trace.setBufSize(this.bufSize);
        }
        this.createBuffers();
        this.redraw();
    }

    void createBuffers() {
        this.buf1 = this.createImage(this.getWidth(), this.getHeight());
        this.width = this.buf1.getWidth(this);
        this.height = this.buf1.getHeight(this);
        this.centerY = this.height / 2;
        this.curBuf = this.buf2 = this.createImage(this.getWidth(), this.getHeight());
        this.gridSideBuf = new BufferedImage(50, this.getHeight(), 2);
    }

    public void start() {
        this.startTime = System.currentTimeMillis() - this.prevUpdateTime;
        this.redraw();
    }

    public void setUpdateRate(int updateRate) {
        this.x_pos_time_scale = 3.0 * (double)Math.max(updateRate, 1) / 1000.0;
    }

    public void addTrace(JRealTrace trace) {
        trace.id = this.traces.size();
        this.traces.add(trace);
        if (this.bufSize > 0) {
            trace.setBufSize(this.bufSize);
        }
    }

    float gridAutoStep(float viewScale) {
        int step;
        float[] steps = new float[]{5.0f, 2.0f};
        float v_step = (float)Math.pow(10.0, Math.floor(Math.log10(10.0f / viewScale)));
        int i = 0;
        while ((step = (int)(v_step * viewScale)) <= 10) {
            v_step *= steps[i++];
            i %= steps.length;
        }
        return v_step;
    }

    private void drawGridYLine(Graphics2D bufG, Graphics2D sideBufG, int x1, int x2) {
        bufG.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        bufG.setBackground(this.backgroundColor);
        bufG.clearRect(x1, 0, x2 - x1 + 1, this.height);
        bufG.setColor(this.gridColor);
        if (sideBufG != null) {
            sideBufG.setBackground(new Color(0xFFFFFF, true));
            sideBufG.clearRect(0, 0, 50, this.height);
        }
        float valStep = this.gridAutoStep(this.zoomY);
        block0: for (int dir = -1; dir <= 1; dir += 2) {
            int i = 0;
            while (true) {
                if (i != 0 || dir != -1) {
                    bufG.setStroke(i == 0 ? this.gridStrokeZero : this.gridStroke);
                    float val = (float)(dir * i) * valStep;
                    int viewVal = Math.round(val * this.zoomY + this.offsetY);
                    int y1 = this.centerY - viewVal;
                    if (dir < 0 && y1 > this.height || dir > 0 && y1 < 0) continue block0;
                    if (!(dir > 0 && y1 > this.height || dir < 0 && y1 < 0)) {
                        bufG.drawLine(x1, y1, x2, y1);
                        if (sideBufG != null) {
                            sideBufG.setFont(labelFont);
                            sideBufG.setColor(labelColor);
                            FontMetrics fm = sideBufG.getFontMetrics();
                            String s = labelFormatter.format(val);
                            int label_h = fm.getHeight() - fm.getAscent();
                            int label_y = y1 - label_h + 1;
                            if (label_y >= -2) {
                                sideBufG.drawString(s, 1, label_y);
                            }
                        }
                    }
                }
                ++i;
            }
        }
    }

    private void drawGrid() {
        Graphics2D bufG = (Graphics2D)this.curBuf.getGraphics();
        Graphics2D sideBufG = (Graphics2D)this.gridSideBuf.getGraphics();
        this.drawGridYLine(bufG, sideBufG, 0, this.width - 1);
        if (this.startTime != 0L && this.x_pos_time_scale != 0.0) {
            int x;
            long deltaT = this.prevUpdateTime - this.lastGridXTime;
            do {
                int gridX = (int)((double)(deltaT - 1000L) * this.x_pos_time_scale);
                x = this.width - 1 - gridX;
                bufG.drawLine(x, 0, x, this.height);
                deltaT += 1000L;
            } while (x > 0);
        }
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.curBuf == null) {
            this.onResize();
        }
        if (this.curBuf != null) {
            g.drawImage(this.curBuf, 0, 0, this);
            g.drawImage(this.gridSideBuf, 0, 0, this);
        }
    }

    public synchronized void update() {
        if (this.curBuf == null || !this.isShowing()) {
            return;
        }
        long curTime = System.currentTimeMillis() - this.startTime;
        int deltaTime = (int)(curTime - this.prevUpdateTime);
        this.prevUpdateTime = curTime;
        this.x_pos += (double)deltaTime * this.x_pos_time_scale;
        double shiftStep_d = this.x_pos - this.x_pos_prev;
        int shiftStep = (int)Math.round(shiftStep_d);
        this.shiftErr = shiftStep_d - (double)shiftStep;
        this.x_pos_prev = this.x_pos;
        if (this.curBuf == this.buf1) {
            this.curBuf = this.buf2;
            this.prevBuf = this.buf1;
        } else {
            this.curBuf = this.buf1;
            this.prevBuf = this.buf2;
        }
        Graphics2D bufG = (Graphics2D)this.curBuf.getGraphics();
        bufG.drawImage(this.prevBuf, -shiftStep, 0, this);
        int x1 = this.width - shiftStep;
        int x2 = this.width - 1;
        this.drawGridYLine(bufG, null, x1, x2);
        int gridX = x2 - (int)((double)(curTime - this.lastGridXTime) * this.x_pos_time_scale);
        if (gridX < this.width) {
            bufG.drawLine(gridX, 0, gridX, this.height);
            this.lastGridXTime = curTime + 1000L;
        }
        bufG.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        bufG.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
        for (JRealTrace trace : this.traces) {
            TraceDataPoint p;
            if (!trace.isEnabled()) continue;
            while ((p = trace.displayLastData()) != null) {
                double xx1 = (double)x2 - (double)(curTime - p.t0) * this.x_pos_time_scale + this.shiftErr;
                double xx2 = (double)x2 - (double)(curTime - p.t1) * this.x_pos_time_scale + this.shiftErr;
                if (!(xx2 >= 0.0) || !(xx2 - xx1 < 60.0)) continue;
                bufG.setColor(trace.getColor());
                bufG.setStroke(trace.getStroke());
                bufG.draw(new Line2D.Double(xx1, (float)this.centerY - (p.val0 * this.zoomY + this.offsetY), xx2, (float)this.centerY - (p.val1 * this.zoomY + this.offsetY)));
            }
        }
        this.updateMinMax();
        this.needUpdate = false;
        this.repaint();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void redraw() {
        if (this.curBuf == null) {
            return;
        }
        Graphics2D bufG = (Graphics2D)this.curBuf.getGraphics();
        this.drawGrid();
        bufG.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        for (JRealTrace trace : this.traces) {
            if (!trace.isEnabled()) continue;
            bufG.setColor(trace.getColor());
            bufG.setStroke(trace.getStroke());
            JRealTrace jRealTrace = trace;
            synchronized (jRealTrace) {
                for (TraceDataPoint p : trace) {
                    double x1 = (double)this.width - (double)(this.prevUpdateTime - p.t0) * this.x_pos_time_scale + this.shiftErr;
                    double x2 = (double)this.width - (double)(this.prevUpdateTime - p.t1) * this.x_pos_time_scale + this.shiftErr;
                    if (x2 < 0.0) break;
                    bufG.draw(new Line2D.Double(x1, (float)this.centerY - (p.val0 * this.zoomY + this.offsetY), x2, (float)this.centerY - (p.val1 * this.zoomY + this.offsetY)));
                }
                trace.resetLastDisplayPos();
            }
        }
        this.updateMinMax();
        this.repaint();
    }

    private void updateMinMax() {
        this.minVal = 1000000.0f;
        this.maxVal = -1000000.0f;
        for (JRealTrace trace : this.traces) {
            if (!trace.isEnabled()) continue;
            this.minVal = Math.min(this.minVal, trace.getMin() * trace.getScale());
            this.maxVal = Math.max(this.maxVal, trace.getMax() * trace.getScale());
        }
        if (this.minVal > this.maxVal) {
            this.minVal = 0.0f;
            this.maxVal = 0.0f;
        } else {
            this.minVal *= this.zoomY;
            this.maxVal *= this.zoomY;
        }
    }

    public Color getGridColor() {
        return this.gridColor;
    }

    public void setGridColor(Color gridColor) {
        this.gridColor = gridColor;
    }

    public Stroke getGridStroke() {
        return this.gridStroke;
    }

    public void setGridStroke(Stroke gridStroke) {
        this.gridStroke = gridStroke;
    }

    public Color getBackgroundColor() {
        return this.backgroundColor;
    }

    public void setBackgroundColor(Color backgroundColor) {
        this.backgroundColor = backgroundColor;
    }

    public float getZoomY() {
        return this.zoomY;
    }

    public void setZoomY(float zoomY) {
        this.zoomY = Math.max(zoomY, 0.001f);
        this.redraw();
    }

    public void addData(int chartId, float data, long time_ms) {
        this.traces.get(chartId).addData(data, time_ms - this.startTime);
        this.needUpdate = true;
    }

    public float getDataMaxY() {
        return this.maxVal;
    }

    public float getDataMinY() {
        return this.minVal;
    }

    public void setOffsetY(float offsetY) {
        this.offsetY = offsetY;
    }
}

