/*
 * Decompiled with CFR 0.152.
 */
package sbgc.ui.dataview;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Stroke;
import java.util.ArrayList;
import sbgc.ui.dataview.DataViewSample;
import sbgc.utils.MathUtils;

public class DataViewSeries {
    public Color strokeColor;
    public Stroke stroke;
    public float[] min = new float[]{0.0f, 0.0f};
    public float[] max = new float[]{0.0f, 0.0f};
    public float[] view_min_range = new float[]{0.0f, 0.0f};
    public float[] view_min = new float[]{0.0f, 0.0f};
    public float[] view_max = new float[]{0.0f, 0.0f};
    public boolean[] absolute = new boolean[]{true, true};
    public AutoScaleType[] auto_scale = new AutoScaleType[]{AutoScaleType.NO, AutoScaleType.NO};
    public float[] wrap_min = new float[]{0.0f, 0.0f};
    public float[] wrap_max = new float[]{0.0f, 0.0f};
    public boolean[] wrap = new boolean[]{false, false};
    public boolean needRepaint;
    ArrayList<DataViewSample> samples = new ArrayList();
    int iterator_pos;
    float threshold_x = 0.0f;
    boolean enabled = true;

    public DataViewSeries(Color strokeColor, float strokeWidth) {
        this.stroke = new BasicStroke(strokeWidth);
        this.strokeColor = strokeColor;
    }

    public void clear() {
        this.samples.clear();
        for (int xy = 0; xy < 2; ++xy) {
            this.max[xy] = 0.0f;
            this.min[xy] = 0.0f;
            if (this.auto_scale[xy] != AutoScaleType.NO) {
                this.view_max[xy] = 0.0f;
                this.view_min[xy] = 0.0f;
            }
            this.iterator_pos = 0;
            this.needRepaint = true;
        }
    }

    public void set_xy_range(int xy, float min, float max, boolean absolute, AutoScaleType auto_scale, float view_min_range) {
        this.view_min[xy] = min;
        this.view_max[xy] = max;
        this.absolute[xy] = absolute;
        this.auto_scale[xy] = auto_scale;
        this.view_min_range[xy] = view_min_range;
    }

    public void set_wrap(int xy, float min, float max, boolean wrap) throws Exception {
        if (!this.samples.isEmpty()) {
            throw new Exception("Configure series before adding samples!");
        }
        this.wrap_min[xy] = min;
        this.wrap_max[xy] = max;
        this.wrap[xy] = wrap;
    }

    public void addSample(DataViewSample s) {
        this.addSample(s.getX(), s.getY());
    }

    public float getFullVal(DataViewSample s, int xy) {
        return s.val[xy] + (float)s.period[xy] * (this.wrap_max[xy] - this.wrap_min[xy]);
    }

    public void addSample(float x, float y) {
        DataViewSample last = this.samples.isEmpty() ? null : this.samples.get(this.samples.size() - 1);
        DataViewSample s = new DataViewSample(x, y);
        s = this.wrap(s);
        if (last != null && this.threshold_x != 0.0f && Math.abs(this.getFullVal(last, 0) - this.getFullVal(s, 0)) < this.threshold_x) {
            return;
        }
        for (int xy = 0; xy < 2; ++xy) {
            if (this.samples.isEmpty()) {
                this.min[xy] = this.max[xy] = s.val[xy];
            } else {
                if (s.val[xy] < this.min[xy]) {
                    this.min[xy] = s.val[xy];
                }
                if (s.val[xy] > this.max[xy]) {
                    this.max[xy] = s.val[xy];
                }
            }
            if (this.auto_scale[xy] == AutoScaleType.NO) continue;
            float prev_min = this.view_min[xy];
            float prev_max = this.view_max[xy];
            if (this.auto_scale[xy] == AutoScaleType.ALL) {
                float range_miss;
                float data_range = this.max[xy] - this.min[xy];
                float view_range = Math.max(data_range, this.view_min_range[xy]);
                float extend = view_range * 0.1f;
                if (this.min[xy] < this.view_min[xy] || this.samples.isEmpty()) {
                    this.view_min[xy] = this.min[xy] - Math.max(extend, (view_range - data_range) / 2.0f);
                    if (this.wrap[xy]) {
                        this.view_min[xy] = Math.max(this.view_min[xy], this.wrap_min[xy]);
                    }
                }
                if (this.max[xy] > this.view_max[xy] || this.samples.isEmpty()) {
                    this.view_max[xy] = this.max[xy] + extend;
                }
                if ((range_miss = this.view_min_range[xy] - (this.view_max[xy] - this.view_min[xy])) > 0.0f) {
                    int n = xy;
                    this.view_max[n] = this.view_max[n] + range_miss;
                }
                if (this.wrap[xy]) {
                    this.view_max[xy] = Math.min(this.view_max[xy], this.wrap_max[xy]);
                }
            } else if (this.auto_scale[xy] == AutoScaleType.LAST) {
                float range = Math.max(Math.abs(s.val[xy]) * 0.5f, this.view_min_range[xy]);
                float min_v = s.val[xy] - range;
                float max_v = s.val[xy] + range;
                this.view_min[xy] = MathUtils.constrain(this.view_min[xy], min_v, min_v + (range *= 0.5f));
                this.view_max[xy] = MathUtils.constrain(this.view_max[xy], max_v - range, max_v);
            }
            if (this.view_min[xy] == prev_min && this.view_max[xy] == prev_max) continue;
            this.needRepaint = true;
        }
        this.samples.add(s);
    }

    public DataViewSample getSample(int idx) {
        return this.samples.get(idx);
    }

    public int size() {
        return this.samples.size();
    }

    public float getDataRange(int xy) {
        return this.max[xy] - this.min[xy];
    }

    public void setThreshold(float threshold) {
        this.threshold_x = threshold;
    }

    public void iteratorStart() {
        this.iterator_pos = 0;
    }

    public DataViewSample iteratorCur() {
        return this.samples.isEmpty() ? null : this.samples.get(this.iterator_pos);
    }

    public DataViewSample iteratorNext() {
        if (this.iteratorHasNext()) {
            ++this.iterator_pos;
            return this.iteratorCur();
        }
        return null;
    }

    public boolean iteratorHasNext() {
        return this.iterator_pos < this.samples.size() - 1;
    }

    public float unwrap(float val, int xy, float min, float max) {
        DataViewSample last;
        if (val < min || val > max) {
            throw new IllegalArgumentException("Value '" + val + "' is outside range [" + min + "," + max + "]");
        }
        DataViewSample dataViewSample = last = this.samples.isEmpty() ? null : this.samples.get(this.samples.size() - 1);
        if (last != null) {
            float last_val = this.getFullVal(last, xy);
            float range = max - min;
            float range2 = range / 2.0f;
            WrappedVal last_w = DataViewSeries.wrapValue(last_val, min, max);
            float delta = val - last_w.val;
            int period = delta < -range2 ? last_w.period + 1 : (delta > range2 ? last_w.period - 1 : last_w.period);
            val += (float)period * range;
        }
        return val;
    }

    public static WrappedVal wrapValue(float val, float min, float max) {
        WrappedVal w = new WrappedVal();
        w.val = val;
        w.period = 0;
        float range = max - min;
        if (range > 0.0f) {
            float f;
            float diff = min - val;
            if (f > 0.0f) {
                float period = (float)Math.ceil(diff / range);
                w.val = val + range * period;
                w.period = -Math.round(period);
            } else {
                float f2;
                diff = val - max;
                if (f2 > 0.0f) {
                    float period = (float)Math.ceil(diff / range);
                    w.val = val - range * period;
                    w.period = Math.round(period);
                }
            }
        }
        return w;
    }

    public DataViewSample wrap(DataViewSample s) {
        DataViewSample ws = new DataViewSample(s);
        for (int xy = 0; xy < 2; ++xy) {
            if (!this.wrap[xy]) continue;
            WrappedVal w = DataViewSeries.wrapValue(s.val[xy], this.wrap_min[xy], this.wrap_max[xy]);
            ws.val[xy] = w.val;
            ws.period[xy] = w.period;
        }
        return ws;
    }

    public DataViewSample[][] splitWrap(DataViewSample s1, DataViewSample s2) {
        block3: {
            if (s1.period[0] == s2.period[0] && s1.period[1] == s2.period[1]) break block3;
            DataViewSample ss1 = new DataViewSample(s1);
            DataViewSample ss2 = new DataViewSample(s2);
            DataViewSample[][] split = new DataViewSample[][]{{s1, ss1}, {ss2, s2}};
            int xy = 0;
            int yx = 1;
            while (xy < 2) {
                block6: {
                    float val_yx;
                    block5: {
                        float range;
                        block4: {
                            range = this.wrap_max[xy] - this.wrap_min[xy];
                            if (s1.period[xy] >= s2.period[xy]) break block4;
                            ss1.val[xy] = this.wrap_max[xy];
                            ss2.val[xy] = this.wrap_min[xy];
                            val_yx = s1.val[yx] + (s2.val[yx] - s1.val[yx]) / (s2.val[xy] - s1.val[xy] + range) * (this.wrap_max[xy] - s1.val[xy]);
                            break block5;
                        }
                        if (s1.period[xy] <= s2.period[xy]) break block6;
                        ss1.val[xy] = this.wrap_min[xy];
                        ss2.val[xy] = this.wrap_max[xy];
                        val_yx = s2.val[yx] + (s1.val[yx] - s2.val[yx]) / (s1.val[xy] - s2.val[xy] + range) * (this.wrap_max[xy] - s2.val[xy]);
                    }
                    ss1.val[yx] = ss2.val[yx] = val_yx;
                }
                ++xy;
                --yx;
            }
            return split;
        }
        return null;
    }

    public void setEnabled(boolean state) {
        if (this.enabled != state) {
            this.enabled = state;
            this.needRepaint = true;
        }
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    static class WrappedVal {
        public float val;
        public int period;

        WrappedVal() {
        }
    }

    public static enum AutoScaleType {
        NO,
        ALL,
        LAST;

    }
}

