/*
 * Decompiled with CFR 0.152.
 */
package sbgc.ui.dataview;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.Locale;
import javax.swing.JPanel;
import sbgc.ui.dataview.DataViewSample;
import sbgc.ui.dataview.DataViewSeries;

public class LUTViewPanel
extends JPanel {
    public static final Color[] PRIMARY_COLORS = new Color[]{new Color(0, 191, 255), new Color(255, 127, 81), new Color(255, 229, 117), new Color(255, 119, 241)};
    public static final Color[] SECONDARY_COLORS = new Color[]{new Color(110, 175, 67), new Color(145, 123, 24), new Color(106, 119, 183), new Color(153, 153, 153)};
    public static final Color backgroundColor = new Color(85, 85, 85);
    public static final Color gridColor = new Color(153, 153, 153);
    public static final Stroke gridStroke = new BasicStroke(1.0f);
    public static final Color gridBoldColor = new Color(204, 204, 204);
    public static final Font labelFont = new Font("Arial", 1, 9);
    public static final Color labelColor = new Color(187, 187, 187);
    public static final DecimalFormat labelFormatter = new DecimalFormat("#.##", new DecimalFormatSymbols(Locale.ENGLISH));
    private static final int LABEL_SPACING_X = 10;
    private static final int LABEL_SPACING_Y = 5;
    ArrayList<DataViewSeries> series = new ArrayList();
    float[] grid = new float[]{0.0f, 0.0f};
    String[] label = new String[]{null, null};
    boolean[] gridAutoStep = new boolean[]{true, true};
    float[] view_min = new float[]{0.0f, 0.0f};
    float[] view_max = new float[]{0.0f, 0.0f};
    float[] view_scale = new float[]{0.0f, 0.0f};
    Image buf;
    int width;
    int height;
    int[] size = new int[]{0, 0};

    public LUTViewPanel() {
        this.setVisible(true);
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                LUTViewPanel.this.changeBufSize();
            }
        });
    }

    public void addSeries(DataViewSeries s) {
        this.series.add(s);
    }

    public boolean checkAutoScale() {
        int xy;
        boolean needRepaint = false;
        for (DataViewSeries s : this.series) {
            if (!s.isEnabled() || !s.needRepaint) continue;
            needRepaint = true;
            for (xy = 0; xy < 2; ++xy) {
                this.view_min[xy] = 1.0E10f;
                this.view_max[xy] = -1.0E10f;
            }
        }
        for (DataViewSeries s : this.series) {
            if (s.isEnabled() && !s.samples.isEmpty()) {
                for (xy = 0; xy < 2; ++xy) {
                    if (!s.absolute[xy]) continue;
                    if (s.view_min[xy] < this.view_min[xy]) {
                        this.view_min[xy] = s.view_min[xy];
                        needRepaint = true;
                    }
                    if (!(s.view_max[xy] > this.view_max[xy])) continue;
                    this.view_max[xy] = s.view_max[xy];
                    needRepaint = true;
                }
            }
            s.needRepaint = false;
        }
        if (needRepaint) {
            this.drawAll();
        }
        return needRepaint;
    }

    public void setGrid(int xy, float step, String label, boolean autoStep) {
        this.grid[xy] = step;
        this.label[xy] = label;
        this.gridAutoStep[xy] = autoStep;
    }

    void changeBufSize() {
        int new_width = this.getWidth() - this.getInsets().left - this.getInsets().right - 1;
        int new_height = this.getHeight() - this.getInsets().top - this.getInsets().bottom - 1;
        if (this.buf == null || new_width != this.width || new_height != this.height) {
            this.width = this.size[0] = new_width;
            this.height = this.size[1] = new_height;
            this.buf = this.createImage(this.width, this.height);
            this.drawAll();
        }
    }

    public void drawAll() {
        for (int xy = 0; xy < 2; ++xy) {
            float range = this.view_max[xy] - this.view_min[xy];
            this.view_scale[xy] = range > 0.0f ? (float)this.size[xy] / range : 1.0f;
        }
        Graphics2D bufG = (Graphics2D)this.buf.getGraphics();
        this.drawGrid(bufG);
        for (DataViewSeries s : this.series) {
            if (!s.isEnabled()) continue;
            s.iteratorStart();
        }
        this.drawAllSeries();
        this.repaint();
    }

    protected int viewToScreen(int xy, float val) {
        int res = Math.round((val - this.view_min[xy]) * this.view_scale[xy]);
        if (xy == 1) {
            res = this.size[xy] - res;
        }
        return res;
    }

    boolean drawNextSample(DataViewSeries series, Graphics2D bufG) {
        DataViewSample s2;
        DataViewSample s1;
        if (series.iteratorHasNext() && (s1 = series.iteratorCur()) != (s2 = series.iteratorNext())) {
            DataViewSample[][] splitPairs = series.splitWrap(s1, s2);
            if (splitPairs != null) {
                for (DataViewSample[] pair : splitPairs) {
                    this.drawLine(series, pair[0], pair[1], bufG);
                }
            } else {
                this.drawLine(series, s1, s2, bufG);
            }
        }
        return series.iteratorHasNext();
    }

    void drawLine(DataViewSeries series, DataViewSample s1, DataViewSample s2, Graphics2D bufG) {
        int x1 = this.viewToScreen(0, s1.getX());
        int y1 = this.viewToScreen(1, s1.getY());
        int x2 = this.viewToScreen(0, s2.getX());
        int y2 = this.viewToScreen(1, s2.getY());
        bufG.drawLine(x1, y1, x2, y2);
    }

    void drawAllSeries() {
        for (DataViewSeries s : this.series) {
            if (!s.isEnabled()) continue;
            Graphics2D bufG = (Graphics2D)this.buf.getGraphics();
            bufG.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
            bufG.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            bufG.setStroke(s.stroke);
            bufG.setColor(s.strokeColor);
            while (this.drawNextSample(s, bufG)) {
            }
        }
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.buf == null) {
            this.changeBufSize();
        }
        g.drawImage(this.buf, this.getInsets().left, this.getInsets().top, this);
    }

    public void onUpdate() {
        if (!this.checkAutoScale()) {
            this.drawAllSeries();
            this.repaint();
        }
    }

    void drawGrid(Graphics2D bufG) {
        bufG.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        bufG.setColor(backgroundColor);
        bufG.fillRect(0, 0, this.width, this.height);
        for (int xy = 0; xy < 2; ++xy) {
            float range = this.view_max[xy] - this.view_min[xy];
            if (!(this.grid[xy] > 0.0f) || !(range > 0.0f)) continue;
            float grid_step = this.gridAutoStep[xy] ? this.gridAutoStep(this.view_scale[xy]) : this.grid[xy];
            int step_from = Math.round(this.view_min[xy] / grid_step) - 1;
            int step_to = Math.round(this.view_max[xy] / grid_step) + 1;
            int prev_label_border = xy == 0 ? 0 : this.height;
            for (int step = step_from; step <= step_to; ++step) {
                float grid_val = grid_step * (float)step;
                int screen_pos = this.viewToScreen(xy, grid_val);
                if (screen_pos < 0 || screen_pos >= this.size[xy]) continue;
                bufG.setStroke(gridStroke);
                bufG.setColor(step == 0 ? gridBoldColor : gridColor);
                if (xy == 0) {
                    bufG.drawLine(screen_pos, 0, screen_pos, this.height);
                } else {
                    bufG.drawLine(0, screen_pos, this.width, screen_pos);
                }
                if (this.label[xy] == null) continue;
                bufG.setFont(labelFont);
                bufG.setColor(labelColor);
                FontMetrics fm = bufG.getFontMetrics();
                String s = labelFormatter.format(grid_val) + this.label[xy];
                int label_h = fm.getHeight() - fm.getAscent();
                int label_w = fm.stringWidth(s);
                if (xy == 0) {
                    int label_x = screen_pos + 2;
                    if (label_x <= prev_label_border || label_x + label_w >= this.width) continue;
                    bufG.drawString(s, label_x, this.height - label_h - 1);
                    prev_label_border = label_x + label_w + 10;
                    continue;
                }
                int label_y = screen_pos - label_h + 1;
                if (label_y >= prev_label_border || label_y < -2) continue;
                bufG.drawString(s, this.width - label_w - 1, label_y);
                prev_label_border = label_y - label_h - 5;
            }
        }
    }

    float gridAutoStep(float viewScale) {
        int step;
        float[] steps = new float[]{2.0f, 2.5f, 2.0f};
        float v_step = (float)Math.pow(10.0, Math.floor(Math.log10(10.0f / viewScale)));
        int i = 0;
        while ((step = (int)(v_step * viewScale)) <= 10) {
            v_step *= steps[i++];
            i %= steps.length;
        }
        return v_step;
    }
}

