/*
 * Decompiled with CFR 0.152.
 */
package sbgc.utils;

import java.util.Iterator;
import java.util.NoSuchElementException;

public class ArrayIterator<T>
implements Iterator<T>,
Iterable<T> {
    T[] samples;
    int startIdx;
    int endIdx;
    int curIdx;

    public ArrayIterator(T[] samples, int startIdx, int endIdx) {
        this.samples = samples;
        this.startIdx = this.curIdx = Math.max(startIdx, 0);
        this.endIdx = Math.min(endIdx, samples.length);
    }

    public void reset() {
        this.curIdx = this.startIdx;
    }

    public int size() {
        return this.endIdx - this.startIdx;
    }

    @Override
    public boolean hasNext() {
        return this.curIdx < this.endIdx;
    }

    @Override
    public T next() {
        if (this.curIdx < this.endIdx) {
            return this.samples[this.curIdx++];
        }
        throw new NoSuchElementException();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Iterator<T> iterator() {
        return new ArrayIterator<T>(this.samples, this.startIdx, this.endIdx);
    }
}

