/*
 * Decompiled with CFR 0.152.
 */
package sbgc.utils;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

public class DateUtil {
    public static final String DEFAULT_DATE_FORMAT = "dd.MM.yyyy";
    public static final long DAY = 86400000L;
    public static final long SECOND = 1000L;

    public static Date truncate(Date source) {
        Calendar destination = Calendar.getInstance();
        destination.setTime(source);
        destination.set(11, 0);
        destination.set(12, 0);
        destination.set(13, 0);
        destination.set(14, 0);
        return destination.getTime();
    }

    public static Date truncateMonth(Date source) {
        Calendar destination = Calendar.getInstance();
        destination.setTime(source);
        destination.set(11, 0);
        destination.set(12, 0);
        destination.set(13, 0);
        destination.set(14, 0);
        destination.set(5, 1);
        return destination.getTime();
    }

    public static Date truncatePreviousMonth(Date source) {
        Date currentMonth = DateUtil.truncateMonth(source);
        Date previousMonth = DateUtil.truncateMonth(new Date(currentMonth.getTime() - 86400000L));
        return previousMonth;
    }

    public static Date parse(String date, String mask) throws Exception {
        return new SimpleDateFormat(mask).parse(date);
    }

    public static String format(Date date, String mask) {
        return new SimpleDateFormat(mask).format(date);
    }

    public static Date shift(Date source, int days) {
        return DateUtil.shiftDay(source, days);
    }

    public static Date shiftDay(Date source, int days) {
        Calendar destination = Calendar.getInstance();
        destination.setTime(source);
        destination.add(5, days);
        return destination.getTime();
    }

    public static Date shiftMonth(Date source, int monthes) {
        Calendar destination = Calendar.getInstance();
        destination.setTime(source);
        destination.add(2, monthes);
        return destination.getTime();
    }

    public static Date shiftHour(Date source, int hours) {
        Calendar destination = Calendar.getInstance();
        destination.setTime(source);
        destination.roll(11, hours);
        return destination.getTime();
    }
}

