/*
 * Decompiled with CFR 0.152.
 */
package sbgc.utils;

public class EulerAngles {
    public static final int X = 0;
    public static final int Y = 1;
    public static final int Z = 2;
    public static final int ROLL = 0;
    public static final int PITCH = 1;
    public static final int YAW = 2;
    public static final int ANGLE_FULL_TURN = 16384;
    public static final int EULER_PITCH_ROLL_YAW = 0;
    public static final int EULER_ROLL_PITCH_YAW = 1;
    public static final float RAD_ANGLE14_SCALE = 2607.5945f;
    int eulerOrder = 0;
    public float[] roll1 = new float[3];
    public float[] pitch1 = new float[3];
    public float[] yaw1 = new float[3];
    public float[] angle = new float[3];
    public int[] angle14 = new int[3];

    public int getEulerOrder() {
        return this.eulerOrder;
    }

    public void setEulerOrder(int eulerOrder) {
        this.eulerOrder = eulerOrder;
    }

    static float inverse_sqrt(float x) {
        return 1.0f / (float)Math.sqrt(x);
    }

    static float vector_dot_product_f(float[] a, float[] b) {
        return a[0] * b[0] + a[1] * b[1] + a[2] * b[2];
    }

    public void update(float[][] rotationMatrix) {
        float[] H1 = rotationMatrix[1];
        float[] Z1 = rotationMatrix[2];
        if (this.eulerOrder == 1) {
            float InvZxz = EulerAngles.inverse_sqrt(Z1[0] * Z1[0] + Z1[2] * Z1[2]);
            this.pitch1[0] = Z1[2] * InvZxz;
            this.pitch1[1] = 0.0f;
            this.pitch1[2] = -Z1[0] * InvZxz;
            this.roll1[0] = Z1[1] * this.pitch1[2];
            this.roll1[1] = -Z1[0] * this.pitch1[2] + Z1[2] * this.pitch1[0];
            this.roll1[2] = -Z1[1] * this.pitch1[0];
            this.angle[1] = (float)Math.atan2(Z1[1], this.roll1[1]);
            this.angle[0] = (float)Math.atan2(Z1[0], Z1[2]);
        } else {
            float InvZyz = EulerAngles.inverse_sqrt(Z1[1] * Z1[1] + Z1[2] * Z1[2]);
            this.roll1[0] = 0.0f;
            this.roll1[1] = Z1[2] * InvZyz;
            this.roll1[2] = -Z1[1] * InvZyz;
            this.pitch1[0] = Z1[2] * this.roll1[1] - Z1[1] * this.roll1[2];
            this.pitch1[1] = Z1[0] * this.roll1[2];
            this.pitch1[2] = -Z1[0] * this.roll1[1];
            this.angle[1] = (float)Math.atan2(Z1[1], Z1[2]);
            this.angle[0] = (float)Math.atan2(Z1[0], this.pitch1[0]);
        }
        this.yaw1[0] = Z1[0];
        this.yaw1[1] = Z1[1];
        this.yaw1[2] = Z1[2];
        this.angle[2] = (float)Math.atan2(-EulerAngles.vector_dot_product_f(H1, this.pitch1), EulerAngles.vector_dot_product_f(H1, this.roll1));
        this.angle14[1] = (int)(this.angle[1] * 2607.5945f);
        this.angle14[0] = (int)(this.angle[0] * 2607.5945f);
        this.angle14[2] = (int)(this.angle[2] * 2607.5945f);
    }

    public float[] mapGyroData(float[] gyroData) {
        float[] speed = new float[]{EulerAngles.vector_dot_product_f(gyroData, this.roll1), EulerAngles.vector_dot_product_f(gyroData, this.pitch1), EulerAngles.vector_dot_product_f(gyroData, this.yaw1)};
        return speed;
    }
}

