/*
 * Decompiled with CFR 0.152.
 */
package sbgc.utils;

public class LinearRegression {
    float xy_sum;
    float x2_sum;
    float y_sum;
    float x_sum;
    float cnt;

    public void addData(float x, float y, float weight) {
        this.x_sum += x * weight;
        this.y_sum += y * weight;
        this.xy_sum += x * y * weight;
        this.x2_sum += x * x * weight;
        this.cnt += weight;
    }

    public float[] calculate() {
        float[] ab = new float[2];
        if (this.cnt != 0.0f) {
            ab[0] = (this.xy_sum * this.cnt - this.x_sum * this.y_sum) / (this.x2_sum * this.cnt - this.x_sum * this.x_sum);
            ab[1] = (this.y_sum - ab[0] * this.x_sum) / this.cnt;
        }
        return ab;
    }

    public float calculate_a() {
        return this.calculate()[0];
    }

    public float calculate_b() {
        return this.calculate()[1];
    }

    public void invert_x() {
        this.xy_sum = -this.xy_sum;
        this.x_sum = -this.x_sum;
    }

    public void invert_y() {
        this.xy_sum = -this.xy_sum;
        this.y_sum = -this.y_sum;
    }

    public float get_avg_x() {
        return this.x_sum / this.cnt;
    }

    public float get_avg_y() {
        return this.y_sum / this.cnt;
    }
}

