/*
 * Decompiled with CFR 0.152.
 */
package sbgc.utils;

import sbgc.utils.MathUtils;

public class LogScale {
    public static final float LN_10 = 2.3025851f;
    public static final float GAIN_5_DB = 1.78f;
    public static final float GAIN_10_DB = 3.16f;
    public static final float GAIN_15_DB = 5.62f;
    public static final float GAIN_20_DB = 10.0f;
    public static final float GAIN_30_DB = 31.6f;
    public static final float GAIN_100_DB = 100000.0f;
    float scale;
    float scale_inv;
    float offset;
    float linear_offset;
    boolean logScale;
    float log_range;
    public float step_mult;

    public LogScale(float log_range, float linear_start_val, float linear_end_val) {
        this(log_range, linear_start_val, linear_end_val, 0.0f);
    }

    public LogScale(float log_range, float linear_start_val, float linear_end_val, float linear_offset) {
        if (linear_start_val >= linear_end_val) {
            throw new IllegalArgumentException();
        }
        if (Float.isNaN(linear_offset) || linear_start_val + linear_offset <= 0.0f) {
            this.offset = -linear_start_val;
            this.scale = log_range / (linear_end_val - linear_start_val);
            this.step_mult = this.scale_inv = 1.0f / this.scale;
            this.logScale = false;
        } else {
            this.log_range = log_range;
            this.linear_offset = linear_offset;
            this.scale = log_range / (float)Math.log((linear_end_val += linear_offset) / (linear_start_val += linear_offset));
            this.scale_inv = 1.0f / this.scale;
            this.offset = (float)Math.log(linear_start_val);
            this.step_mult = (float)Math.exp(this.scale_inv);
            this.logScale = true;
        }
    }

    public float to_log(float linear_val) {
        if (this.logScale) {
            return ((float)Math.log(linear_val + this.linear_offset) - this.offset) * this.scale;
        }
        return (linear_val + this.offset) * this.scale;
    }

    public int to_log_int(float linear_val) {
        return MathUtils.constrain(Math.round(this.to_log(linear_val)), 0, (int)this.log_range);
    }

    public float from_log(float log_val) {
        if (this.logScale) {
            return (float)Math.exp(log_val * this.scale_inv + this.offset) - this.linear_offset;
        }
        return log_val / this.scale - this.offset;
    }

    public static float log_to_linear(float min_val, float max_val, float log_range, float log_val) {
        LogScale s = new LogScale(log_range, min_val, max_val);
        return s.from_log(log_val);
    }

    public static float linear_to_dB(float val) {
        return 8.685889f * (float)Math.log(val);
    }

    public static float linear_to_dB2(float val) {
        return 4.3429446f * (float)Math.log(val);
    }

    public static float dB_to_linear(float val) {
        return (float)Math.exp(val * 0.115129255f);
    }

    public static float param_log_to_linear(int int_val, int int_range, float min, float max, float offset) {
        return new LogScale(int_range, min, max, offset).from_log(int_val);
    }

    public static int param_linear_to_log(float val, int int_range, float min, float max, float offset) {
        return new LogScale(int_range, min, max, offset).to_log_int(val);
    }
}

