/*
 * Decompiled with CFR 0.152.
 */
package sbgc.utils;

import java.util.Arrays;

public class MathUtils {
    public static final int X = 0;
    public static final int Y = 1;
    public static final int Z = 2;
    public static final float RAD_DEG_SCALE = 57.29578f;
    public static final float DEG_RAD_SCALE = (float)Math.PI / 180;
    public static final int ANGLE14 = 16384;
    public static final float ANGLE14_f = 16384.0f;
    public static final int ANGLE20 = 0x100000;
    public static final int ANGLE20_180 = 524288;
    public static final double ANGLE14_DEG_SCALE = 0.02197265625;
    public static final double DEG_ANGLE14_SCALE = 45.511112213134766;
    public static final double ANGLE20_DEG_SCALE = 3.4332275390625E-4;
    public static final double DEG_ANGLE20_SCALE = 2912.711181640625;
    public static final float COS_10 = 0.9848077f;
    public static final float COS_15 = 0.9659258f;
    public static final float SIN_15 = 0.25881904f;
    public static final float SIN_20 = 0.34202015f;
    public static final float SLOW_ROTATION_RAD_S = 5.0E-6f;

    public static int deg_to_angle14(float a) {
        return (int)Math.round((double)a * 45.511112213134766);
    }

    public static float angle14_to_deg(int a) {
        return (float)Math.round((double)a * 0.02197265625 * 100.0) * 0.01f;
    }

    public static float wrap_angleDeg_180(float a) {
        return (float)((double)(((long)((double)a * 2912.711181640625) + 524288L & 0xFFFFFL) - 524288L) * 3.4332275390625E-4);
    }

    public static void vector_copy(float[] to, float[] from) {
        to[0] = from[0];
        to[1] = from[1];
        to[2] = from[2];
    }

    public static void vector_rotate(float[] v, float[] delta) {
        float[] delta_v_cross = new float[3];
        MathUtils.vector_cross_product(delta, v, delta_v_cross);
        double v_dot_delta = MathUtils.vector_dot_product(v, delta);
        double delta2 = MathUtils.vector_pow2(delta);
        for (int i = 0; i < 3; ++i) {
            int n = i;
            v[n] = (float)((double)v[n] + ((double)delta_v_cross[i] + ((double)delta[i] * v_dot_delta - (double)(delta_v_cross[i] / 3.0f + v[i]) * delta2) * 0.5));
        }
    }

    public static void vector_cross_product(float[] a, float[] b, float[] res) {
        res[0] = a[1] * b[2] - a[2] * b[1];
        res[1] = a[2] * b[0] - a[0] * b[2];
        res[2] = a[0] * b[1] - a[1] * b[0];
    }

    public static float vector_dot_product(float[] a, float[] b) {
        return a[0] * b[0] + a[1] * b[1] + a[2] * b[2];
    }

    public static float vector_pow2(float[] v) {
        return MathUtils.vector_dot_product(v, v);
    }

    public static float vector_mod(float[] v) {
        return (float)Math.sqrt(MathUtils.vector_dot_product(v, v));
    }

    public static void vector_inc(float[] v, float[] delta) {
        v[0] = v[0] + delta[0];
        v[1] = v[1] + delta[1];
        v[2] = v[2] + delta[2];
    }

    public static void vector_sub(float[] v, float[] delta, float[] res) {
        res[0] = v[0] - delta[0];
        res[1] = v[1] - delta[1];
        res[2] = v[2] - delta[2];
    }

    public static void vector_add(float[] v, float[] delta, float[] res) {
        res[0] = v[0] + delta[0];
        res[1] = v[1] + delta[1];
        res[2] = v[2] + delta[2];
    }

    public static void vector_inc_mult_var(float[] v, float[] delta, float var) {
        v[0] = v[0] + delta[0] * var;
        v[1] = v[1] + delta[1] * var;
        v[2] = v[2] + delta[2] * var;
    }

    public static void vector_dec(float[] v, float[] delta) {
        v[0] = v[0] - delta[0];
        v[1] = v[1] - delta[1];
        v[2] = v[2] - delta[2];
    }

    public static void vector_mult_var(float[] v, float mult) {
        v[0] = v[0] * mult;
        v[1] = v[1] * mult;
        v[2] = v[2] * mult;
    }

    public static void vector_mult(float[] v, float mult, float[] res) {
        res[0] = v[0] * mult;
        res[1] = v[1] * mult;
        res[2] = v[2] * mult;
    }

    public static void vector_set_zero(float[] v) {
        Arrays.fill(v, 0.0f);
    }

    public static float constrain(float val, float min, float max) {
        if (val > max) {
            return max;
        }
        if (val < min) {
            return min;
        }
        return val;
    }

    public static int constrain(int val, int min, int max) {
        if (val > max) {
            return max;
        }
        if (val < min) {
            return min;
        }
        return val;
    }

    public static int floatToIntScaled(Number val, float offset, float scale, int min, int max) {
        return MathUtils.constrain(Math.round((val.floatValue() - offset) / scale), min, max);
    }

    public static float vector_cos_angle(float[] v1, float[] v2) {
        float v1_v2_mod2 = MathUtils.vector_dot_product(v1, v1) * MathUtils.vector_dot_product(v2, v2);
        if (v1_v2_mod2 != 0.0f) {
            return MathUtils.vector_dot_product(v1, v2) / (float)Math.sqrt(v1_v2_mod2);
        }
        return 0.0f;
    }

    public static float vector_dist(float[] v1, float[] v2) {
        float pow2 = 0.0f;
        for (int i = 0; i < 3; ++i) {
            float d = v1[i] - v2[i];
            pow2 += d * d;
        }
        return (float)Math.sqrt(pow2);
    }

    public static void vector_correct_by_ref(float[] v, float[] v_ref, float K) {
        for (int i = 0; i < 3; ++i) {
            int n = i;
            v[n] = v[n] + (v_ref[i] - v[i]) * K;
        }
        float v_mod_cur = MathUtils.vector_mod(v);
        if (v_mod_cur > 1.0E-10f) {
            float v_mod = MathUtils.vector_mod(v);
            float v_ref_mod = MathUtils.vector_mod(v_ref);
            float v_mod_new = v_mod + (v_ref_mod - v_mod) * K;
            MathUtils.vector_mult_var(v, v_mod_new / v_mod_cur);
        }
    }

    public static void vector_copy(double[] to, float[] from) {
        to[0] = from[0];
        to[1] = from[1];
        to[2] = from[2];
    }

    public static void vector_copy(float[] to, double[] from) {
        to[0] = (float)from[0];
        to[1] = (float)from[1];
        to[2] = (float)from[2];
    }

    public static void vector_rotate(double[] v, double[] delta) {
        double[] delta_v_cross = new double[3];
        MathUtils.vector_cross_product(delta, v, delta_v_cross);
        double v_dot_delta = MathUtils.vector_dot_product(v, delta);
        double delta2 = MathUtils.vector_pow2(delta);
        for (int i = 0; i < 3; ++i) {
            int n = i;
            v[n] = v[n] + (delta_v_cross[i] + (delta[i] * v_dot_delta - (delta_v_cross[i] / 3.0 + v[i]) * delta2) * 0.5);
        }
    }

    public static void vector_dec(double[] v, double[] delta) {
        v[0] = v[0] - delta[0];
        v[1] = v[1] - delta[1];
        v[2] = v[2] - delta[2];
    }

    public static void vector_inc(double[] v, double[] delta) {
        v[0] = v[0] + delta[0];
        v[1] = v[1] + delta[1];
        v[2] = v[2] + delta[2];
    }

    public static double vector_pow2(double[] v) {
        return MathUtils.vector_dot_product(v, v);
    }

    public static double vector_mod(double[] v) {
        return Math.sqrt(MathUtils.vector_dot_product(v, v));
    }

    public static void vector_cross_product(double[] a, double[] b, double[] res) {
        res[0] = a[1] * b[2] - a[2] * b[1];
        res[1] = a[2] * b[0] - a[0] * b[2];
        res[2] = a[0] * b[1] - a[1] * b[0];
    }

    public static double vector_dot_product(double[] a, double[] b) {
        return a[0] * b[0] + a[1] * b[1] + a[2] * b[2];
    }

    public static void vector_reverse(float[] v) {
        v[0] = -v[0];
        v[1] = -v[1];
        v[2] = -v[2];
    }

    public static float[] fitParabola(float[] x, float[] y) {
        float[] abc;
        float x2_x1 = x[1] - x[0];
        float x2px1 = x[0] + x[1];
        float y2_y1 = y[1] - y[0];
        float x1x2 = x[0] * x[1];
        float tmp1 = x[1] * y[0] - x[0] * y[1];
        abc = new float[]{(y[2] - (x[2] * y2_y1 + tmp1) / x2_x1) / (x[2] * (x[2] - x2px1) + x1x2), y2_y1 / x2_x1 - abc[0] * x2px1, tmp1 / x2_x1 + abc[0] * x1x2};
        return abc;
    }

    public static float[] minMaxInit() {
        return new float[]{Float.MAX_VALUE, -3.4028235E38f};
    }

    public static void minMax(float[] minMax, float val) {
        if (val < minMax[0]) {
            minMax[0] = val;
        }
        if (val > minMax[1]) {
            minMax[1] = val;
        }
    }

    public static float insert_deadband(float val, float deadband) {
        return val > deadband ? val - deadband : (val < -deadband ? val + deadband : 0.0f);
    }
}

