/*
 * Decompiled with CFR 0.152.
 */
package sbgc.utils;

import com.sun.jna.Platform;
import com.sun.jna.platform.win32.Guid;
import com.sun.jna.platform.win32.KnownFolders;
import com.sun.jna.platform.win32.Shell32Util;
import java.awt.event.KeyEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import javax.swing.JCheckBox;
import javax.swing.JSpinner;
import javax.swing.JToggleButton;
import javax.swing.KeyStroke;
import org.apache.log4j.Logger;
import org.jdesktop.application.ResourceMap;
import sbgc.utils.Log;
import sbgc.utils.OrderedProperties;
import simplebgc_gui.SimpleBGC_GUIApp;

public class Settings {
    public static final String LAST_USED_PROFILES_DIRECTORY = "last_used_profiles_directory";
    public static final String LAST_USED_FIRMWARE_DIRECTORY = "last_used_firmware_directory";
    public static final String LAST_USED_EXT_DEVICE_FIRMWARE_DIRECTORY = "last_used_ext_device_firmware_dir";
    public static final String CONF_DIRECTORY = "conf";
    public static final String PROFILES_DIRECTORY = "profiles";
    public static final String PROPERTIES_FILE = "bgc.properties";
    public static final String SHORTCUTS_FILE = "shortcuts.properties";
    public static final String LATEST_VERSION_AUTOCHECK = "latest.versions.autocheck";
    public static final String FIRMWARE_UPDATE_CHECK_BETA = "firmware_update.check_beta";
    public static final String FIRMWARE_UPDATE_EXPERIMENTAL = "firmware_update.experimental";
    public static final String LAST_VERSION_CHECK_DATE = "last.version.check.date";
    public static final String LAST_USED_PORT = "last.used.port";
    public static final String LATEST_VERSION_GUI = "latest.version.gui";
    public static final String LATEST_VERSION_FIRMWARE = "latest.version.firmware";
    public static final String LATEST_SERIAL_BAUD = "latest.serial.baud";
    public static final String LATEST_SERIAL_PARITY = "latest.serial.parity";
    public static final String IGNORED_FIRMWARE_VERSION = "ignored.firmware.version";
    public static final String REGISTRATION_DATA_SENT = "registration.data.sent";
    public static final String REGISTRATION_DATA_NAME = "registration.data.name";
    public static final String REGISTRATION_DATA_EMAIL = "registration.data.email";
    public static final String REGISTRATION_DATA_COUNTRY = "registration.data.country";
    public static final String BGC_SERVER_HOST = "bgc_server_host";
    public static final String BGC_SERVER_PORT = "bgc_server_port";
    public static final String BGC_SERVER_PATH = "bgc_server_path";
    public static final String BGC_SERVER_TIMEOUT = "bgc_server_timeout";
    public static final String DEFAULT_BGC_SERVER_HOST = "www.basecamelectronics.com";
    public static final String DEFAULT_BGC_SERVER_PORT = "443";
    public static final String DEFAULT_BGC_SERVER_PATH = "/cgi-bin/main.cgi";
    public static final String DEFAULT_BGC_SERVER_TIMEOUT = "30";
    public static final String TEMPORARY_SESSION = "temporary_session";
    public static final String TEMPORARY_SIGNATURE = "temporary_signature";
    public static final String REALTIME_DATA_PAUSED = "realtime.data.paused";
    public static final String REQUEST_DEBUG_VARS = "realtime.debug_vars";
    public static final String REQUEST_CAN_DRV = "realtime.can_drv";
    public static final String LOG_RT_DATA = "realtime.log_to_file";
    public static final String LOG_RT_DATA_REWRITE = "realtime.log_rewrite";
    public static final String SCRIPTING_LAST_USED_DIR = "scripting.last_used_script_dir";
    public static final String BODE_TEST_LAST_DIR = "bode_test.last_used_dir";
    public static final String BODE_TEST_AXIS = "bode_test.axis";
    public static final String BODE_TEST_STIMULUS = "bode_test.stimulus";
    public static final String BODE_TEST_STIMULUS_GAIN = "bode_test.stimulus_gain";
    public static final String BODE_TEST_START_FREQ = "bode_test.start_freq";
    public static final String BODE_TEST_CUTOFF_FREQ = "bode_test.cutoff_freq";
    public static final String BODE_TEST_SYSTEM = "bode_test.system";
    public static final String BODE_TEST_LAST_FILE = "bode_test.last_used_file";
    public static final String DEBUG_LAST_USED_DIR = "debug.last_used_dir";
    public static final String BACKUP_SERVICE_EMAIL = "backup.service_email";
    public static final String BACKUP_SERVICE_PASSWORD = "backup.service_password";
    public static final String BACKUP_NAME = "backup.name";
    public static final String PROFILE_TEMPLATES_COUNT = "profile.templates.count";
    public static final String PROFILE_TEMPLATE = "profile.template";
    public static final String JOYSTICK_CONTROLLER = "joystick.controller";
    public static final String JOYSTICK_UPDATE_INTERVAL = "joystick.update_interval";
    public static final String JOYSTICK_ENABLED = "joystick.enabled";
    public static final String JOYSTICK_API_VIRT_CH_ENABLED = "joystick.api_virt_ch_enabled";
    public static final String DEBUG_PORT_CMD_FILTER = "debug_port.filter.";
    public static final String SCREEN_JOY_INTERVAL_ENABLED = "screen_joy.interval_enabled";
    public static final String SCREEN_JOY_INTERVAL = "screen_joy.interval";
    public static final String SCREEN_JOY_SEND_MODE = "screen_joy.send_mode";
    public static final String SCREEN_JOY_AUTO_CENTER = "screen_joy.auto_center";
    public static final String SCREEN_JOY_MODE_RC_AXES = "screen_joy.mode_rc_axes";
    public static final String SCREEN_JOY_ENABLED = "screen_joy.enabled";
    public static final String SCREEN_JOY_QUAT_MODE = "screen_joy.quat_control_mode";
    public static final String FIRMWARE_UPDATE_HIGH_SPEED = "firmware_update.flash_high_speed";
    public static final String SERVICE_SHOW_FILES = "service.show_files";
    public static final String BOARD_DEFAULT_PASSWORD = "board_password.default";
    public static final int BOARD_PASSWORD_MAX_SIZE = 20;
    private static final Log logger = new Log(Logger.getLogger((String)Settings.class.getName()));
    private static final Properties properties = new OrderedProperties();
    private static final HashMap<String, String> temporary = new HashMap();
    private static final Properties shortcuts = new Properties();
    private static String userDir = null;

    public static void load() {
        logger.trace("Loading application settings...");
        String propertiesFileName = null;
        try {
            propertiesFileName = Settings.getPropertiesFileName();
            properties.load(new FileInputStream(propertiesFileName));
            logger.debug("Settings were loaded.");
        }
        catch (Exception e) {
            logger.error("Error loading properties file (" + propertiesFileName + "): " + e.toString());
        }
        try {
            propertiesFileName = Settings.getPropertiesFileName(SHORTCUTS_FILE, false);
            shortcuts.load(new FileInputStream(propertiesFileName));
        }
        catch (Exception e) {
            logger.error("Error loading shorctucts file (" + propertiesFileName + "): " + e.toString());
        }
    }

    public static void remove(String name) {
        properties.remove(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void save() {
        Class<Settings> clazz = Settings.class;
        synchronized (Settings.class) {
            logger.trace("Saving application settings...");
            String propertiesFileName = null;
            try {
                propertiesFileName = Settings.getPropertiesFileName();
                properties.store(new FileOutputStream(propertiesFileName), "");
            }
            catch (Exception e) {
                logger.error("Error saving properties file (" + propertiesFileName + "): " + e.toString());
            }
            return;
        }
    }

    public static String getUserDir() throws Exception {
        if (userDir != null) {
            return userDir;
        }
        String homeDir = null;
        if (Platform.isWindows()) {
            homeDir = System.getenv("APPDATA");
            try {
                if (homeDir == null) {
                    homeDir = Shell32Util.getKnownFolderPath((Guid.GUID)KnownFolders.FOLDERID_LocalAppData);
                }
            }
            catch (Exception exception) {}
        } else {
            homeDir = Platform.isMac() ? System.getProperty("user.home") + "/Library/Application Support" : System.getProperty("user.home");
        }
        if (homeDir == null) {
            return new File(".").getCanonicalPath();
        }
        ResourceMap resourceMap = SimpleBGC_GUIApp.getResourceMap();
        String dir = homeDir + File.separatorChar + resourceMap.getString("Application.vendorId", new Object[0]) + File.separatorChar + resourceMap.getString("Application.id", new Object[0]);
        logger.debug("User directory: " + dir);
        try {
            Files.createDirectories(new File(dir).toPath(), new FileAttribute[0]);
        }
        catch (Exception e) {
            logger.warn("Failed to create sub-directories: " + e.toString());
        }
        return dir;
    }

    public static String getWorkingDirectory() throws Exception {
        return Settings.getExecutablePath();
    }

    public static String getExecutablePath() throws Exception {
        String jarPath = SimpleBGC_GUIApp.class.getProtectionDomain().getCodeSource().getLocation().toURI().getPath();
        return new File(jarPath).getParent();
    }

    public static void initUserDir() throws IOException {
        String[] dirs;
        logger.info("Creating user diretory structure..");
        for (String dir : dirs = new String[]{CONF_DIRECTORY, PROFILES_DIRECTORY, "firmware", "logs", "tmp"}) {
            File dirHandle = new File(userDir + File.separatorChar + dir);
            if (dirHandle.exists()) continue;
            logger.info("Creating '" + dir + "' directory...");
            dirHandle.mkdirs();
        }
    }

    private static void copyDefaultConfFile(String propertiesFileName, File propFile) throws Exception {
        File propFileDefault = new File(Settings.getWorkingDirectory() + File.separatorChar + CONF_DIRECTORY + File.separatorChar + propertiesFileName + ".default");
        if (propFileDefault.exists()) {
            Files.copy(propFileDefault.toPath(), propFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
        } else {
            logger.error("Default file " + propFileDefault + " doesn't exists, creating empty file..");
            Files.createFile(propFile.toPath(), new FileAttribute[0]);
        }
    }

    public static String getPropertiesFileName(String propertiesFileName, boolean testWrite) throws Exception {
        File propFile;
        if (userDir == null) {
            userDir = Settings.getWorkingDirectory();
            propFile = new File(userDir + File.separatorChar + CONF_DIRECTORY + File.separatorChar + propertiesFileName);
            if (!propFile.exists()) {
                try {
                    Settings.copyDefaultConfFile(propertiesFileName, propFile);
                }
                catch (Exception e) {
                    logger.debug("Failed to create '" + propertiesFileName + "' in working directory");
                    userDir = null;
                }
            }
            if (testWrite && !Files.isWritable(propFile.toPath())) {
                logger.info("No write permissions for " + propFile);
                userDir = null;
            }
            if (userDir == null) {
                userDir = Settings.getUserDir();
                logger.info("Using " + userDir + " for user data..");
                File confDirectory = new File(userDir + File.separatorChar + CONF_DIRECTORY);
                if (!confDirectory.exists()) {
                    Settings.initUserDir();
                }
            }
        }
        if (!(propFile = new File(userDir + File.separatorChar + CONF_DIRECTORY + File.separatorChar + propertiesFileName)).exists()) {
            try {
                Settings.copyDefaultConfFile(propertiesFileName, propFile);
            }
            catch (Exception e) {
                logger.error("Failed to create default properties file " + propFile.getPath() + ": " + e.toString());
            }
        }
        return propFile.getPath();
    }

    public static String getPropertiesFileName() throws Exception {
        return Settings.getPropertiesFileName(PROPERTIES_FILE, true);
    }

    public static boolean is(String name) {
        String value = Settings.get(name);
        return value != null && ("1".equals(value) || "true".equalsIgnoreCase(value));
    }

    public static boolean is(String name, boolean defVal) {
        String value = Settings.get(name);
        if (value != null) {
            return "1".equals(value) || "true".equalsIgnoreCase(value);
        }
        return defVal;
    }

    public static String get(String name) {
        return Settings.get(name, null);
    }

    public static String get(String name, String defaultValue) {
        String value = temporary.get(name);
        if (value == null) {
            value = properties.getProperty(name);
        }
        if (value == null) {
            return defaultValue;
        }
        return value;
    }

    public static int getInt(String name, int defaultValue) {
        try {
            return Integer.parseInt(Settings.get(name));
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public static float getFloat(String name, float defaultValue) {
        try {
            return Float.parseFloat(Settings.get(name));
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public static List<String> getStrings(String prefix) {
        ArrayList<String> list = new ArrayList<String>();
        for (String key : properties.stringPropertyNames()) {
            if (!key.startsWith(prefix)) continue;
            list.add(properties.getProperty(key));
        }
        return list;
    }

    public static void selectToggleButton(String name, JToggleButton[] list, int defaultBits) {
        int selectedBits = Settings.getInt(name, -1);
        if (selectedBits == -1) {
            selectedBits = defaultBits;
        }
        int bitCnt = 0;
        for (JToggleButton rb : list) {
            rb.setSelected((selectedBits & 1 << bitCnt) != 0);
            ++bitCnt;
        }
    }

    public static void setToggleButton(String name, JToggleButton[] list) {
        int selectedBits = 0;
        int bitCnt = 0;
        for (JToggleButton rb : list) {
            if (rb.isSelected()) {
                selectedBits |= 1 << bitCnt;
            }
            ++bitCnt;
        }
        Settings.set(name, selectedBits);
    }

    public static void set(String name, String value) {
        if (value != null) {
            properties.setProperty(name, value);
        }
    }

    public static void set(String name, int value) {
        properties.setProperty(name, Integer.toString(value));
    }

    public static void set(String name, float value) {
        properties.setProperty(name, Float.toString(value));
    }

    public static void set(String name, boolean value) {
        properties.setProperty(name, value ? "true" : "false");
    }

    public static void setTemporary(String name, String value) {
        if (value != null) {
            temporary.put(name, value);
        }
    }

    public static Locale getLocale() {
        String language = Settings.get("locale.language", "en");
        String country = Settings.get("locale.country", "EN");
        Locale locale = new Locale(language, country);
        return locale;
    }

    public static <T> T[] concatArrays(T[] first, T[] ... rest) {
        int totalLength = first.length;
        for (T[] array : rest) {
            totalLength += array.length;
        }
        T[] result = Arrays.copyOf(first, totalLength);
        int offset = first.length;
        for (T[] array : rest) {
            System.arraycopy(array, 0, result, offset, array.length);
            offset += array.length;
        }
        return result;
    }

    public static void restoreSpinnerValues(JSpinner[] items) {
        for (JSpinner s : items) {
            try {
                String val = Settings.get(s.getName());
                if (val == null) continue;
                s.setValue(Double.parseDouble(val));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void saveSpinnerValues(JSpinner[] items) {
        for (JSpinner s : items) {
            try {
                Settings.set(s.getName(), s.getValue().toString());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void restoreCheckBoxValues(JCheckBox[] items, boolean default_state) {
        for (JCheckBox s : items) {
            s.setSelected(Settings.is(s.getName(), default_state));
        }
    }

    public static void saveCheckBoxValues(JCheckBox[] items) {
        for (JCheckBox s : items) {
            Settings.set(s.getName(), s.isSelected());
        }
    }

    public static KeyStroke getShortcutKey(String actionName, int modifier) {
        String s = shortcuts.getProperty(actionName);
        if (s != null && s.length() == 1) {
            int keyCode = KeyEvent.getExtendedKeyCodeForChar(s.charAt(0));
            return KeyStroke.getKeyStroke(keyCode, modifier);
        }
        return null;
    }
}

