/*
 * Decompiled with CFR 0.152.
 */
package sbgc.utils;

import org.apache.log4j.Logger;
import sbgc.object.RealtimeData;
import sbgc.serial.command.CmdControlConfigHelper;
import sbgc.serial.command.CmdControlHelper;
import sbgc.service.CommandResponseListener;
import sbgc.service.SerialCommand;
import sbgc.service.SerialCommandProcessor;
import sbgc.utils.Log;
import simplebgc_gui.SimpleBGC_GUIApp;
import simplebgc_gui.SimpleBGC_GUIView;

public class apiTestUtils {
    static Log logger = new Log(Logger.getLogger((String)apiTestUtils.class.getName()));
    static SimpleBGC_GUIView mainView = SimpleBGC_GUIApp.mainView;
    static boolean direction;

    static void goInitialPosition(int testAxis, float initAngle) throws InterruptedException {
        Thread.sleep(100L);
        logger.debug("Returning to initial position");
        CmdControlHelper cmd_control = new CmdControlHelper();
        cmd_control.angle[testAxis] = initAngle;
        cmd_control.speed[testAxis] = 300.0f;
        cmd_control.mode[testAxis] = 66;
        CommandResponseListener.sendCommandAndWaitAnswers(cmd_control.getCmd(), 3000L, null, 2);
        cmd_control.mode[testAxis] = 0;
        SerialCommandProcessor.sendCommand(cmd_control.getCmd());
    }

    static boolean waitForAngle(int axis, float targetAngle, int timeout_ms) {
        try {
            for (int time = 0; time < timeout_ms; time += 100) {
                if (Math.abs(RealtimeData.getRealtimeData().rc_angle[axis] - targetAngle) < 0.5f) {
                    return true;
                }
                Thread.sleep(100L);
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return false;
    }

    public static void runTest1() throws Exception {
        int testAxis = 2;
        float startAngle = RealtimeData.getRealtimeData().rc_angle[testAxis];
        CmdControlHelper cmd_control = new CmdControlHelper();
        cmd_control.mode[testAxis] = 98;
        cmd_control.speed[testAxis] = 500.0f;
        CmdControlConfigHelper cmd_cfg = new CmdControlConfigHelper();
        cmd_cfg.acc_limit[testAxis] = 1000;
        for (int i = 1; i < 10; ++i) {
            SerialCommandProcessor.sendCommand(cmd_cfg.getCmd());
            cmd_control.angle[testAxis] = startAngle + (float)(i * 5);
            SerialCommand cmd = cmd_control.getCmd();
            logger.debug("sending CMD_CONTROL..");
            SerialCommand resp = CommandResponseListener.sendCommandAndWaitAnswer(cmd, 1000L);
            if (resp != null) {
                if (resp.len == 1) {
                    logger.debug("CMD_CONTROL confirmed.");
                    if ((cmd_control.mode[testAxis] & 0x40) != 0) {
                        resp = CommandResponseListener.waitFor(67, 5000L);
                        if (resp != null && resp.len == 2) {
                            logger.debug("target reached.");
                        } else {
                            logger.debug("Timeout waiting target.");
                        }
                    }
                }
            } else {
                logger.debug("Timeout waiting answer.");
            }
            Thread.sleep(50L);
            if (mainView.isConnected()) continue;
            return;
        }
        SerialCommandProcessor.sendCommand(cmd_cfg.getCmd());
        apiTestUtils.goInitialPosition(testAxis, startAngle);
    }

    public static void runTest3() throws Exception {
        float speed;
        int testAxis = 2;
        int testDuration = 5;
        int frameRate = 5;
        float varyAngle = 10.0f;
        float varyRC = 300.0f;
        CmdControlHelper cmd_control = new CmdControlHelper();
        float initAngle = RealtimeData.getRealtimeData().rc_angle[testAxis];
        int mode = 2;
        int flags = 0;
        cmd_control.speed[testAxis] = speed = 100.0f;
        float startAngle = 0.0f;
        if (((flags |= 0x10) & 0x10) == 0) {
            startAngle = initAngle;
        }
        for (int i = 0; i < testDuration * frameRate; ++i) {
            if (mode == 6) {
                cmd_control.angle[testAxis] = ((float)Math.random() - 0.5f) * 2.0f * varyRC;
            } else if (mode == 1) {
                cmd_control.speed[testAxis] = ((float)Math.random() - 0.5f) * 2.0f * speed;
            } else {
                float incAngle = ((float)Math.random() - 0.5f) * 2.0f * varyAngle;
                cmd_control.angle[testAxis] = startAngle + incAngle;
            }
            cmd_control.mode[testAxis] = mode | flags;
            SerialCommandProcessor.sendCommand(cmd_control.getCmd());
            Thread.sleep(Math.round(1000.0f / (float)frameRate));
            if (mainView.isConnected()) continue;
            return;
        }
        apiTestUtils.goInitialPosition(testAxis, initAngle);
    }

    public static void runTest4() throws Exception {
        float initAngle;
        int testAxis = 2;
        int testDuration = 5;
        int frameRate = 30;
        float incAngle = 90.0f;
        int mode = 2;
        int flags = 0;
        flags |= 0x20;
        flags |= 0x10;
        float speed = 500.0f;
        int lpf = 5;
        int acc_limit = 500;
        float startAngle = initAngle = RealtimeData.getRealtimeData().rc_angle[testAxis];
        if (mode == 5) {
            startAngle = 0.0f;
        }
        CmdControlHelper cmd_control = new CmdControlHelper();
        cmd_control.speed[testAxis] = mode == 3 ? incAngle / (float)testDuration : speed;
        cmd_control.mode[testAxis] = mode + flags;
        CmdControlConfigHelper cmd_cfg = new CmdControlConfigHelper();
        cmd_cfg.acc_limit[testAxis] = acc_limit;
        cmd_cfg.angle_lpf[testAxis] = lpf;
        cmd_cfg.speed_lpf[testAxis] = lpf;
        SerialCommandProcessor.sendCommand(cmd_cfg.getCmd());
        for (int i = 1; i < testDuration * frameRate; ++i) {
            cmd_control.angle[testAxis] = startAngle + incAngle * (float)i / (float)(testDuration * frameRate);
            SerialCommandProcessor.sendCommand(cmd_control.getCmd());
            Thread.sleep(Math.round(1000.0f / (float)frameRate));
            if (mainView.isConnected()) continue;
            return;
        }
        apiTestUtils.goInitialPosition(testAxis, initAngle);
    }

    public static void runTest5() throws Exception {
        float initAngle;
        int testAxis = 0;
        float incAngle = 90.0f;
        int repeat_cnt = 7;
        int mode = 2;
        int flags = 0;
        flags |= 0x20;
        float speed = 60.0f;
        int lpf = 0;
        int acc_limit = 0;
        int jerk_slope_ms = 500;
        float startAngle = initAngle = RealtimeData.getRealtimeData().rc_angle[testAxis];
        if (mode == 5) {
            startAngle = 0.0f;
        }
        CmdControlHelper cmd_control = new CmdControlHelper();
        cmd_control.speed[testAxis] = speed;
        cmd_control.mode[testAxis] = mode + flags;
        CmdControlConfigHelper cmd_cfg = new CmdControlConfigHelper();
        cmd_cfg.acc_limit[testAxis] = acc_limit;
        cmd_cfg.angle_lpf[testAxis] = lpf;
        cmd_cfg.speed_lpf[testAxis] = lpf;
        SerialCommandProcessor.sendCommand(cmd_cfg.getCmd());
        for (int i = 1; i <= repeat_cnt; ++i) {
            cmd_cfg.jerk_slope_ms[testAxis] = jerk_slope_ms > 1 ? 1 + jerk_slope_ms * (i - 1) / (repeat_cnt - 1) : jerk_slope_ms;
            SerialCommandProcessor.sendCommand(cmd_cfg.getCmd());
            cmd_control.angle[testAxis] = startAngle + incAngle * (float)(i % 2);
            SerialCommandProcessor.sendCommand(cmd_control.getCmd());
            if (!apiTestUtils.waitForAngle(testAxis, cmd_control.angle[testAxis], 50000)) {
                logger.warn("Failed to reach target angle " + cmd_control.angle[testAxis] + ". Interrupting test..");
                break;
            }
            logger.info("Target angle " + cmd_control.angle[testAxis] + " reached.");
            Thread.sleep(500L);
            if (mainView.isConnected()) continue;
            return;
        }
        apiTestUtils.goInitialPosition(testAxis, initAngle);
    }

    public static void runTest6() throws Exception {
        float initAngle;
        int testAxis = 0;
        float rotateAngle = 1440.0f;
        int mode = 2;
        int flags = 0;
        float speed = 60.0f;
        int lpf = 4;
        int acc_limit = 300;
        int jerk_slope_ms = 20;
        int cmdRate = 50;
        float startAngle = initAngle = RealtimeData.getRealtimeData().rc_angle[testAxis];
        CmdControlHelper cmd_control = new CmdControlHelper();
        cmd_control.speed[testAxis] = speed;
        cmd_control.mode[testAxis] = mode + flags;
        CmdControlConfigHelper cmd_cfg = new CmdControlConfigHelper();
        cmd_cfg.acc_limit[testAxis] = acc_limit;
        cmd_cfg.angle_lpf[testAxis] = lpf;
        cmd_cfg.speed_lpf[testAxis] = lpf;
        cmd_cfg.jerk_slope_ms[testAxis] = jerk_slope_ms;
        SerialCommandProcessor.sendCommand(cmd_cfg.getCmd());
        direction = !direction;
        float angleInc = speed / (float)cmdRate;
        for (float angle = 0.0f; angle < rotateAngle; angle += angleInc) {
            cmd_control.angle[testAxis] = startAngle + (direction ? angle : -angle);
            SerialCommandProcessor.sendCommand(cmd_control.getCmd());
            if (!mainView.isConnected()) {
                return;
            }
            Thread.sleep(1000 / cmdRate);
        }
    }
}

