/*
 * Decompiled with CFR 0.152.
 */
package sbgc.utils.intelhex;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import sbgc.utils.intelhex.Memory;
import sbgc.utils.intelhex.Record;
import sbgc.utils.intelhex.Row;

public final class Converter {
    private final Memory memory = new Memory();
    private final short pad;
    private int startAddress = 0;
    private int highAddress = 0;
    private boolean endOfFile = false;

    public Converter(short pad, int startAddress) {
        this.pad = pad;
        this.startAddress = startAddress;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public byte[] convert(File hexFile) throws Exception {
        int lineCnt = 0;
        try (BufferedReader in = new BufferedReader(new FileReader(hexFile));){
            String line = null;
            while ((line = in.readLine()) != null) {
                ++lineCnt;
                try {
                    this.convertLine(line);
                }
                catch (Exception e) {
                    throw new Exception("Line " + lineCnt + " \"" + line + "\" error: " + e.toString());
                    return this.memory.toArray();
                }
            }
        }
    }

    private void convertLine(String line) throws Exception {
        Row row = new Row(line);
        Record record = new Record(row);
        if (this.endOfFile) {
            throw new Exception("Unexpected records after the 'end of file' record!");
        }
        switch (record.getRecordType()) {
            case DATA: {
                this.updateMemory(record);
                break;
            }
            case EXTENDED_SEGMENT_ADDRESS: {
                this.highAddress = record.getUnsigned16BitFromData(0) << 4;
                break;
            }
            case EXTENDED_LINEAR_ADDRESS: {
                this.highAddress = record.getUnsigned16BitFromData(0) << 16;
                break;
            }
            case END_OF_FILE: {
                this.endOfFile = true;
                break;
            }
            case START_LINEAR_ADDRESS: 
            case START_SEGMENT_ADDRESS: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown record type: " + record);
            }
        }
    }

    private void updateMemory(Record record) throws Exception {
        int addr = this.highAddress + record.getAddress();
        if (addr < this.startAddress) {
            throw new Exception("Address 0x" + Integer.toHexString(addr) + " is lower then the minimal allowed address 0x" + Integer.toHexString(this.startAddress));
        }
        int addr0 = addr - this.startAddress;
        this.memory.expand(addr0 + record.getByteCount(), this.pad);
        short[] data = record.getData();
        for (int i = 0; i < data.length; ++i) {
            this.memory.set(addr0 + i, data[i]);
        }
    }
}

