/*
 * Decompiled with CFR 0.152.
 */
package sbgc.utils.intelhex;

import sbgc.utils.intelhex.Hex;
import sbgc.utils.intelhex.RecordType;
import sbgc.utils.intelhex.Row;

public final class Record {
    private final short byteCount;
    private final int address;
    private final RecordType recordType;
    private final short[] data;
    private final short checksum;

    public Record(Row row) throws Exception {
        this.byteCount = row.getUnsigned8Bit();
        this.address = row.getUnsigned16Bit();
        this.recordType = RecordType.of(row.getUnsigned8Bit());
        this.data = new short[this.byteCount];
        for (int i = 0; i < this.byteCount; ++i) {
            this.data[i] = row.getUnsigned8Bit();
        }
        this.checksum = row.getUnsigned8Bit();
        if (!row.isEmpty()) {
            throw new Exception("Wrong bytes count in the record: " + this);
        }
        this.validateChecksum();
    }

    private void validateChecksum() throws Exception {
        short sum = this.byteCount;
        sum = (short)(sum + (this.address >> 8));
        sum = (short)(sum + (this.address & 0xFF));
        sum = (short)(sum + this.recordType.getCode());
        for (int i = 0; i < this.byteCount; ++i) {
            sum = (short)(sum + this.data[i]);
        }
        if ((sum = (short)(~sum + 1 & 0xFF)) != this.checksum) {
            throw new Exception(String.format("Wrong checksum %s in the record: %s", Hex.to8BitHexString(sum)));
        }
    }

    private short getUnsigned8BitFromData(int index) {
        return this.getData()[index];
    }

    public int getUnsigned16BitFromData(int index) {
        return (this.getUnsigned8BitFromData(index) << 8) + this.getUnsigned8BitFromData(index + 1);
    }

    public short getByteCount() {
        return this.byteCount;
    }

    public int getAddress() {
        return this.address;
    }

    public RecordType getRecordType() {
        return this.recordType;
    }

    public short[] getData() {
        return this.data;
    }

    public short getChecksum() {
        return this.checksum;
    }

    public String toString() {
        return "Record{byteCount=" + Hex.to8BitHexString(this.byteCount) + ", address=" + Hex.to16BitHexString(this.address) + ", recordType=" + (Object)((Object)this.recordType) + ", data=" + Hex.to8BitHexString(this.data) + ", checksum=" + Hex.to8BitHexString(this.checksum) + '}';
    }
}

