/*
 * Decompiled with CFR 0.152.
 */
package sbgc.utils.intelhex;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class Row {
    private static final Pattern LINE_PATTERN = Pattern.compile("^[0-9A-Fa-f]+$");
    private String line;

    static void checkArgument(boolean cond, String err_msg) throws Exception {
        if (!cond) {
            throw new Exception(err_msg);
        }
    }

    public Row(String line) throws Exception {
        Row.checkArgument(line.indexOf(58) != -1, "Line must start with a colon: " + line);
        line = line.substring(1);
        Matcher matcher = LINE_PATTERN.matcher(line);
        Row.checkArgument(matcher.matches(), "Line must contain only hexadecimal chars: " + line);
        Row.checkArgument(line.length() % 2 == 0, "Line must contain even number of hexadecimal chars: " + line);
        this.line = line;
    }

    public short getUnsigned8Bit() throws Exception {
        Row.checkArgument(this.line.length() >= 2, "Unexpected end of line");
        short value = (short)(Integer.parseInt(this.line.substring(0, 2).toUpperCase(), 16) & 0xFFFF);
        this.line = this.line.substring(2);
        return value;
    }

    public int getUnsigned16Bit() throws Exception {
        Row.checkArgument(this.line.length() >= 4, "Unexpected end of line");
        return (this.getUnsigned8Bit() << 8) + this.getUnsigned8Bit();
    }

    public boolean isEmpty() {
        return this.line.isEmpty();
    }
}

