/*
 * Decompiled with CFR 0.152.
 */
package simplebgc_gui;

import java.nio.charset.Charset;
import simplebgc_gui.BTModule;
import simplebgc_gui.UartCmdSender;

class BTModuleHC03_05
implements BTModule {
    protected UartCmdSender uartCmdSender;
    static final int[] speed2baud = new int[]{115200, 57600, 38400, 19200, 9600};

    BTModuleHC03_05(UartCmdSender uartCmdSender) {
        this.uartCmdSender = uartCmdSender;
    }

    @Override
    public void validateName(String name) throws Exception {
        if (name.length() > 20) {
            throw new Exception("Name should be less than 20 characters long!");
        }
    }

    @Override
    public void validatePin(String pin) throws Exception {
        if (pin.length() != 4) {
            throw new Exception("PIN should be exactly 4 digits long!");
        }
    }

    @Override
    public String getTitle() {
        return "HC-03, HC-05 (Bluetooth 2.1)";
    }

    @Override
    public void sendAtCmd(String atCmd) throws Exception {
        atCmd = "AT\r\n" + atCmd + "\r\n";
        this.uartCmdSender.sendUartCmd(atCmd.getBytes(Charset.forName("ISO-8859-1")), 1, 0, 1500);
    }

    @Override
    public String[] cmdFactoryDefaults() {
        return new String[]{"AT+ORGL"};
    }

    @Override
    public String[] cmdSetPin(String pin) {
        return new String[]{"AT+PSWD=" + pin};
    }

    @Override
    public String[] cmdSetName(String name) {
        return new String[]{"AT+NAME=" + name};
    }

    @Override
    public String[] cmdSetOtherParams() {
        return new String[]{"AT+ROLE=0"};
    }

    @Override
    public String[] cmdSetSpeedParity(int speed, int parity) {
        int baud = speed >= 0 && speed < speed2baud.length ? speed2baud[speed] : speed2baud[0];
        return new String[]{"AT+UART=" + baud + ",0," + (parity > 0 ? 3 - parity : 0)};
    }

    @Override
    public String[] cmdReset() {
        return new String[]{"AT+RESET"};
    }

    @Override
    public boolean needReset() {
        return false;
    }
}

