/*
 * Decompiled with CFR 0.152.
 */
package simplebgc_gui;

import java.nio.charset.Charset;
import simplebgc_gui.BTModule;
import simplebgc_gui.UartCmdSender;

class BTModuleHM12
implements BTModule {
    static final char delimiter = '|';
    protected UartCmdSender uartCmdSender;
    static final int[] speed2baud = new int[]{6, 5, 4, 3, 2};

    BTModuleHM12(UartCmdSender uartCmdSender) {
        this.uartCmdSender = uartCmdSender;
    }

    @Override
    public void validateName(String name) throws Exception {
        if (name.length() > 28) {
            throw new Exception("Name should be less than 28 characters long!");
        }
    }

    @Override
    public void validatePin(String pin) throws Exception {
        if (!pin.matches("^[0-9]{6}$")) {
            throw new Exception("PIN should be exactly 6 digits long!");
        }
    }

    @Override
    public String getTitle() {
        return "HM-12, HM-13 (BLE+EDR)";
    }

    @Override
    public void sendAtCmd(String atCmd) throws Exception {
        atCmd = "AT+VERS?|AT|" + atCmd;
        this.uartCmdSender.sendUartCmd(atCmd.getBytes(Charset.forName("ISO-8859-1")), 1, 124, 1000);
    }

    @Override
    public String[] cmdFactoryDefaults() {
        return new String[]{"AT+RENEW"};
    }

    @Override
    public String[] cmdSetPin(String pin) {
        return new String[]{"AT+PINE" + pin, "AT+PINB" + pin};
    }

    @Override
    public String[] cmdSetName(String name) {
        return new String[]{"AT+NAME" + name, "AT+NAMB" + name};
    }

    @Override
    public String[] cmdSetOtherParams() {
        return new String[]{"AT+HIGH0"};
    }

    @Override
    public String[] cmdSetSpeedParity(int speed, int parity) {
        int baud = speed >= 0 && speed < speed2baud.length ? speed2baud[speed] : speed2baud[0];
        return new String[]{"AT+BAUD" + baud, "AT+PARI" + parity};
    }

    @Override
    public String[] cmdReset() {
        return new String[]{"AT+RESET"};
    }

    @Override
    public boolean needReset() {
        return true;
    }
}

