/*
 * Decompiled with CFR 0.152.
 */
package simplebgc_gui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.LayoutManager;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSlider;
import javax.swing.LayoutStyle;
import org.jdesktop.application.Action;
import org.jdesktop.application.Application;
import org.jdesktop.application.ApplicationActionMap;
import org.jdesktop.application.ResourceMap;
import org.netbeans.lib.awtextra.AbsoluteConstraints;
import org.netbeans.lib.awtextra.AbsoluteLayout;
import sbgc.object.AutoPIDCfg;
import sbgc.object.AutoPIDInfo;
import sbgc.object.BoardParams;
import sbgc.service.SerialCommand;
import sbgc.service.SerialCommandProcessor;
import sbgc.utils.DataLogger;
import simplebgc_gui.MyDialog;
import simplebgc_gui.SimpleBGC_GUIApp;

public class DialogAutoPID
extends MyDialog {
    public static final int RES_START = 10;
    public static final int RES_STOP = 11;
    DataLogger autoPIDLog = null;
    AutoPIDCfg cfg = null;
    private ButtonGroup buttonGroupStart;
    private ButtonGroup buttonGroupTuneParams;
    private JButton jButtonCancel;
    private JButton jButtonSave;
    private JButton jButtonStart;
    private JButton jButtonStop;
    private JCheckBox jCheckBoxAllProfiles;
    private JCheckBox jCheckBoxLogFile;
    private JCheckBox jCheckBoxMomentumAuto;
    private JCheckBox jCheckBoxPITCH;
    private JCheckBox jCheckBoxROLL;
    private JCheckBox jCheckBoxSendGUI;
    private JCheckBox jCheckBoxTuneLPF;
    private JCheckBox jCheckBoxYAW;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JLabel jLabel8;
    private JLabel jLabelCriterion;
    private JLabel jLabelErrPITCH;
    private JLabel jLabelErrROLL;
    private JLabel jLabelErrYAW;
    private JPanel jPanelButtonsController;
    private JPanel jPanelCfg;
    private JRadioButton jRadioButtonKeepCurrent;
    private JRadioButton jRadioButtonStartZero;
    private JSlider jSliderGain;
    private JSlider jSliderMomentum;

    public DialogAutoPID(Frame parent, AutoPIDCfg cfgInit) {
        super(DialogAutoPID.class, parent, SimpleBGC_GUIApp.getResourceMap(DialogAutoPID.class).getString("Form.title", new Object[0]));
        this.cfg = cfgInit;
        this.initComponents();
        try {
            if (this.cfg == null) {
                this.cfg = new AutoPIDCfg();
                BoardParams params = BoardParams.getCurParams();
                if (params != null && params.auto_pid_cfg != 0) {
                    this.cfg.fromParams(params);
                } else {
                    this.cfg.loadFromSettings();
                }
            }
            this.jCheckBoxROLL.setSelected(this.cfg.isRollSelected());
            this.jCheckBoxPITCH.setSelected(this.cfg.isPitchSelected());
            this.jCheckBoxYAW.setSelected(this.cfg.isYawSelected());
            this.jCheckBoxSendGUI.setSelected(this.cfg.isSendGUI());
            this.jRadioButtonStartZero.setSelected(!this.cfg.isStartFromCurrent());
            this.jCheckBoxTuneLPF.setSelected(this.cfg.isTuneLPF());
            this.jCheckBoxAllProfiles.setSelected(this.cfg.isAllProfiles());
            this.jSliderGain.setValue(this.cfg.gain);
            this.jSliderMomentum.setValue(Math.max(this.cfg.stimulus_gain, 1));
            this.jCheckBoxMomentumAuto.setSelected(false);
            this.jCheckBoxMomentumAuto.setEnabled(false);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.getRootPane().setDefaultButton(this.jButtonStart);
    }

    public AutoPIDCfg applyParams() {
        this.cfg.flags = (this.jCheckBoxROLL.isSelected() ? 1 : 0) | (this.jCheckBoxPITCH.isSelected() ? 2 : 0) | (this.jCheckBoxYAW.isSelected() ? 4 : 0) | (this.jCheckBoxSendGUI.isSelected() ? 8 : 0) | (this.jRadioButtonStartZero.isSelected() ? 0 : 16) | (this.jCheckBoxTuneLPF.isSelected() ? 32 : 0) | (this.jCheckBoxAllProfiles.isSelected() ? 64 : 0);
        this.cfg.gain = this.jSliderGain.getValue();
        this.cfg.stimulus_gain = this.jCheckBoxMomentumAuto.isSelected() ? 0 : this.jSliderMomentum.getValue();
        return this.cfg;
    }

    public boolean logFileSelected() {
        return this.jCheckBoxLogFile.isSelected();
    }

    public void showState(AutoPIDInfo info) {
        this.jLabelErrROLL.setText(String.format("%.4f", Float.valueOf(info.error[0])));
        this.jLabelErrPITCH.setText(String.format("%.4f", Float.valueOf(info.error[1])));
        this.jLabelErrYAW.setText(String.format("%.4f", Float.valueOf(info.error[2])));
        if (info.auto_momentum > 0) {
            this.jSliderMomentum.setValue(info.auto_momentum);
        }
        if (this.autoPIDLog != null) {
            info.log_data(this.autoPIDLog);
            this.autoPIDLog.flush();
        }
    }

    @Override
    public void onCloseDialog() {
    }

    private void initComponents() {
        this.buttonGroupStart = new ButtonGroup();
        this.buttonGroupTuneParams = new ButtonGroup();
        this.jPanelCfg = new JPanel();
        this.jLabel1 = new JLabel();
        this.jSliderGain = new JSlider();
        this.jLabel2 = new JLabel();
        this.jLabel3 = new JLabel();
        this.jSliderMomentum = new JSlider();
        this.jLabel7 = new JLabel();
        this.jLabel8 = new JLabel();
        this.jCheckBoxMomentumAuto = new JCheckBox();
        this.jLabel6 = new JLabel();
        this.jLabel4 = new JLabel();
        this.jCheckBoxROLL = new JCheckBox();
        this.jCheckBoxPITCH = new JCheckBox();
        this.jCheckBoxYAW = new JCheckBox();
        this.jRadioButtonStartZero = new JRadioButton();
        this.jRadioButtonKeepCurrent = new JRadioButton();
        this.jLabel5 = new JLabel();
        this.jCheckBoxTuneLPF = new JCheckBox();
        this.jPanelButtonsController = new JPanel();
        this.jCheckBoxSendGUI = new JCheckBox();
        this.jButtonStart = new JButton();
        this.jButtonStop = new JButton();
        this.jButtonCancel = new JButton();
        this.jCheckBoxLogFile = new JCheckBox();
        this.jLabelCriterion = new JLabel();
        this.jLabelErrYAW = new JLabel();
        this.jLabelErrROLL = new JLabel();
        this.jLabelErrPITCH = new JLabel();
        this.jCheckBoxAllProfiles = new JCheckBox();
        this.jButtonSave = new JButton();
        ResourceMap resourceMap = Application.getInstance(SimpleBGC_GUIApp.class).getContext().getResourceMap(DialogAutoPID.class);
        this.setTitle(resourceMap.getString("Form.title", new Object[0]));
        this.setMinimumSize(new Dimension(420, 280));
        this.setModal(true);
        this.setName("Form");
        this.setResizable(false);
        this.jPanelCfg.setBorder(BorderFactory.createTitledBorder(resourceMap.getString("jPanelCfg.border.title", new Object[0])));
        this.jPanelCfg.setName("jPanelCfg");
        this.jPanelCfg.setLayout((LayoutManager)new AbsoluteLayout());
        this.jLabel1.setText(resourceMap.getString("jLabel1.text", new Object[0]));
        this.jLabel1.setName("jLabel1");
        this.jPanelCfg.add((Component)this.jLabel1, new AbsoluteConstraints(20, 20, -1, -1));
        this.jSliderGain.setMaximum(255);
        this.jSliderGain.setValue(127);
        this.jSliderGain.setName("jSliderGain");
        this.jPanelCfg.add((Component)this.jSliderGain, new AbsoluteConstraints(50, 40, 250, -1));
        this.jLabel2.setHorizontalAlignment(0);
        this.jLabel2.setText(resourceMap.getString("jLabel2.text", new Object[0]));
        this.jLabel2.setName("jLabel2");
        this.jPanelCfg.add((Component)this.jLabel2, new AbsoluteConstraints(10, 60, 160, -1));
        this.jLabel3.setHorizontalAlignment(0);
        this.jLabel3.setText(resourceMap.getString("jLabel3.text", new Object[0]));
        this.jLabel3.setName("jLabel3");
        this.jPanelCfg.add((Component)this.jLabel3, new AbsoluteConstraints(190, 60, 190, -1));
        this.jSliderMomentum.setMaximum(255);
        this.jSliderMomentum.setMinimum(1);
        this.jSliderMomentum.setValue(1);
        this.jSliderMomentum.setName("jSliderMomentum");
        this.jPanelCfg.add((Component)this.jSliderMomentum, new AbsoluteConstraints(50, 130, 250, -1));
        this.jLabel7.setHorizontalAlignment(0);
        this.jLabel7.setText(resourceMap.getString("jLabel7.text", new Object[0]));
        this.jLabel7.setName("jLabel7");
        this.jPanelCfg.add((Component)this.jLabel7, new AbsoluteConstraints(180, 150, 160, -1));
        this.jLabel8.setHorizontalAlignment(0);
        this.jLabel8.setText(resourceMap.getString("jLabel8.text", new Object[0]));
        this.jLabel8.setName("jLabel8");
        this.jPanelCfg.add((Component)this.jLabel8, new AbsoluteConstraints(10, 150, 160, -1));
        this.jCheckBoxMomentumAuto.setSelected(true);
        this.jCheckBoxMomentumAuto.setText(resourceMap.getString("jCheckBoxMomentumAuto.text", new Object[0]));
        this.jCheckBoxMomentumAuto.setName("jCheckBoxMomentumAuto");
        this.jPanelCfg.add((Component)this.jCheckBoxMomentumAuto, new AbsoluteConstraints(300, 130, -1, -1));
        this.jLabel6.setText(resourceMap.getString("jLabel6.text", new Object[0]));
        this.jLabel6.setName("jLabel6");
        this.jPanelCfg.add((Component)this.jLabel6, new AbsoluteConstraints(20, 110, -1, -1));
        this.jLabel4.setText(resourceMap.getString("jLabel4.text", new Object[0]));
        this.jLabel4.setName("jLabel4");
        this.jPanelCfg.add((Component)this.jLabel4, new AbsoluteConstraints(20, 190, -1, -1));
        this.jCheckBoxROLL.setSelected(true);
        this.jCheckBoxROLL.setText(resourceMap.getString("labelRoll.text", new Object[0]));
        this.jCheckBoxROLL.setName("jCheckBoxROLL");
        this.jPanelCfg.add((Component)this.jCheckBoxROLL, new AbsoluteConstraints(150, 190, -1, -1));
        this.jCheckBoxPITCH.setSelected(true);
        this.jCheckBoxPITCH.setText(resourceMap.getString("labelPitch.text", new Object[0]));
        this.jCheckBoxPITCH.setName("jCheckBoxPITCH");
        this.jPanelCfg.add((Component)this.jCheckBoxPITCH, new AbsoluteConstraints(220, 190, -1, -1));
        this.jCheckBoxYAW.setSelected(true);
        this.jCheckBoxYAW.setText(resourceMap.getString("labelYaw.text", new Object[0]));
        this.jCheckBoxYAW.setName("jCheckBoxYAW");
        this.jPanelCfg.add((Component)this.jCheckBoxYAW, new AbsoluteConstraints(290, 190, -1, -1));
        this.buttonGroupStart.add(this.jRadioButtonStartZero);
        this.jRadioButtonStartZero.setText(resourceMap.getString("jRadioButtonStartZero.text", new Object[0]));
        this.jRadioButtonStartZero.setName("jRadioButtonStartZero");
        this.jPanelCfg.add((Component)this.jRadioButtonStartZero, new AbsoluteConstraints(150, 250, -1, -1));
        this.buttonGroupStart.add(this.jRadioButtonKeepCurrent);
        this.jRadioButtonKeepCurrent.setSelected(true);
        this.jRadioButtonKeepCurrent.setText(resourceMap.getString("jRadioButtonKeepCurrent.text", new Object[0]));
        this.jRadioButtonKeepCurrent.setName("jRadioButtonKeepCurrent");
        this.jPanelCfg.add((Component)this.jRadioButtonKeepCurrent, new AbsoluteConstraints(150, 270, -1, -1));
        this.jLabel5.setText(resourceMap.getString("jLabel5.text", new Object[0]));
        this.jLabel5.setName("jLabel5");
        this.jPanelCfg.add((Component)this.jLabel5, new AbsoluteConstraints(20, 250, -1, -1));
        this.jCheckBoxTuneLPF.setSelected(true);
        this.jCheckBoxTuneLPF.setText(resourceMap.getString("jCheckBoxTuneLPF.text", new Object[0]));
        this.jCheckBoxTuneLPF.setName("jCheckBoxTuneLPF");
        this.jPanelCfg.add((Component)this.jCheckBoxTuneLPF, new AbsoluteConstraints(150, 220, -1, -1));
        this.jPanelButtonsController.setName("jPanelButtonsController");
        this.jPanelButtonsController.setLayout((LayoutManager)new AbsoluteLayout());
        this.jCheckBoxSendGUI.setSelected(true);
        this.jCheckBoxSendGUI.setText(resourceMap.getString("jCheckBoxSendGUI.text", new Object[0]));
        this.jCheckBoxSendGUI.setName("jCheckBoxSendGUI");
        this.jPanelButtonsController.add((Component)this.jCheckBoxSendGUI, new AbsoluteConstraints(20, 30, 200, -1));
        ApplicationActionMap actionMap = Application.getInstance(SimpleBGC_GUIApp.class).getContext().getActionMap(DialogAutoPID.class, this);
        this.jButtonStart.setAction(actionMap.get("buttonStart"));
        this.jButtonStart.setText(resourceMap.getString("jButtonStart.text", new Object[0]));
        this.jButtonStart.setName("jButtonStart");
        this.jPanelButtonsController.add((Component)this.jButtonStart, new AbsoluteConstraints(10, 130, 120, -1));
        this.jButtonStop.setAction(actionMap.get("buttonStop"));
        this.jButtonStop.setText(resourceMap.getString("jButtonStop.text", new Object[0]));
        this.jButtonStop.setName("jButtonStop");
        this.jPanelButtonsController.add((Component)this.jButtonStop, new AbsoluteConstraints(140, 130, 120, -1));
        this.jButtonCancel.setAction(actionMap.get("buttonCancel"));
        this.jButtonCancel.setText(resourceMap.getString("jButtonCancel.text", new Object[0]));
        this.jButtonCancel.setName("jButtonCancel");
        this.jPanelButtonsController.add((Component)this.jButtonCancel, new AbsoluteConstraints(270, 130, 120, -1));
        this.jCheckBoxLogFile.setText(resourceMap.getString("jCheckBoxLogFile.text", new Object[0]));
        this.jCheckBoxLogFile.setEnabled(false);
        this.jCheckBoxLogFile.setName("jCheckBoxLogFile");
        this.jPanelButtonsController.add((Component)this.jCheckBoxLogFile, new AbsoluteConstraints(230, 30, 160, -1));
        this.jLabelCriterion.setText(resourceMap.getString("jLabelCriterion.text", new Object[0]));
        this.jLabelCriterion.setName("jLabelCriterion");
        this.jPanelButtonsController.add((Component)this.jLabelCriterion, new AbsoluteConstraints(20, 90, -1, -1));
        this.jLabelErrYAW.setFont(this.jLabelErrYAW.getFont().deriveFont((float)this.jLabelErrYAW.getFont().getSize() + 2.0f));
        this.jLabelErrYAW.setText(resourceMap.getString("jLabelErrYAW.text", new Object[0]));
        this.jLabelErrYAW.setName("jLabelErrYAW");
        this.jPanelButtonsController.add((Component)this.jLabelErrYAW, new AbsoluteConstraints(310, 90, 80, -1));
        this.jLabelErrROLL.setFont(this.jLabelErrROLL.getFont().deriveFont((float)this.jLabelErrROLL.getFont().getSize() + 2.0f));
        this.jLabelErrROLL.setText(resourceMap.getString("jLabelErrROLL.text", new Object[0]));
        this.jLabelErrROLL.setName("jLabelErrROLL");
        this.jPanelButtonsController.add((Component)this.jLabelErrROLL, new AbsoluteConstraints(130, 90, 80, -1));
        this.jLabelErrPITCH.setFont(this.jLabelErrPITCH.getFont().deriveFont((float)this.jLabelErrPITCH.getFont().getSize() + 2.0f));
        this.jLabelErrPITCH.setText(resourceMap.getString("jLabelErrPITCH.text", new Object[0]));
        this.jLabelErrPITCH.setName("jLabelErrPITCH");
        this.jPanelButtonsController.add((Component)this.jLabelErrPITCH, new AbsoluteConstraints(220, 90, 80, -1));
        this.jCheckBoxAllProfiles.setText(resourceMap.getString("jCheckBoxAllProfiles.text", new Object[0]));
        this.jCheckBoxAllProfiles.setName("jCheckBoxAllProfiles");
        this.jPanelButtonsController.add((Component)this.jCheckBoxAllProfiles, new AbsoluteConstraints(20, 10, 370, -1));
        this.jButtonSave.setAction(actionMap.get("buttonSave"));
        this.jButtonSave.setText(resourceMap.getString("jButtonSave.text", new Object[0]));
        this.jButtonSave.setName("jButtonSave");
        this.jPanelButtonsController.add((Component)this.jButtonSave, new AbsoluteConstraints(230, 60, 160, -1));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanelCfg, -2, 400, -2).addComponent(this.jPanelButtonsController, -2, 400, -2)).addContainerGap(44, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jPanelCfg, -2, 302, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanelButtonsController, -2, 161, -2).addContainerGap(26, Short.MAX_VALUE)));
        this.pack();
    }

    @Action
    public void buttonStart() {
        if (this.autoPIDLog != null) {
            this.autoPIDLog.finish();
        }
        this.autoPIDLog = null;
        if (this.logFileSelected()) {
            try {
                this.autoPIDLog = new DataLogger("auto_pid_log.csv", false);
                AutoPIDInfo.log_header(this.autoPIDLog);
            }
            catch (Exception e) {
                this.logger.error("Failed to open log file " + e.getMessage());
            }
        }
        this.sendCmdAutoPid(0);
    }

    private void sendCmdAutoPid(int action) {
        AutoPIDCfg cfg = this.applyParams();
        cfg.saveToSettings();
        BoardParams params = BoardParams.getCurParams();
        if (params != null) {
            cfg.toParams(params);
        }
        try {
            SerialCommand cmd = new SerialCommand(35);
            cmd.writeByte(BoardParams.getCurParams().curProfile);
            cmd.writeByte(cfg.flags);
            cmd.writeByte(cfg.gain);
            cmd.writeByte(cfg.stimulus_gain);
            cmd.writeByte(action);
            cmd.writeEmptyArr(14);
            SerialCommandProcessor.sendCommand(cmd);
        }
        catch (Exception e) {
            this.logger.error("Failed to send CMD_AUTOPID: " + e.toString());
        }
    }

    @Action
    public void buttonStop() {
        try {
            SerialCommand cmd = new SerialCommand(35);
            cmd.writeByte(BoardParams.getCurParams().curProfile);
            cmd.writeEmptyArr(18);
            SerialCommandProcessor.sendCommand(cmd);
        }
        catch (Exception e) {
            this.logger.error("Failed to send CMD_AUTOPID: " + e.toString());
        }
        this.result = 11;
        this.setVisible(false);
    }

    @Action
    public void buttonCancel() {
        this.cancelDialog();
    }

    @Action
    public void buttonSave() {
        this.sendCmdAutoPid(1);
    }

    @Action
    public void buttonStartModal() {
        this.applyParams();
        this.closeDialog(1);
    }
}

