/*
 * Decompiled with CFR 0.152.
 */
package simplebgc_gui;

import java.awt.Component;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JProgressBar;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.jdesktop.application.Action;
import org.jdesktop.application.Application;
import org.jdesktop.application.ApplicationActionMap;
import org.jdesktop.application.ResourceMap;
import org.netbeans.lib.awtextra.AbsoluteConstraints;
import org.netbeans.lib.awtextra.AbsoluteLayout;
import sbgc.object.BackupData;
import sbgc.object.BoardInfo;
import sbgc.object.ErrorInfo;
import sbgc.serial.command.SerialCommandSignMessageImpl;
import sbgc.service.RealtimeDataThread;
import sbgc.service.SerialCommand;
import sbgc.service.SerialCommandProcessor;
import sbgc.service.upgrade.IProgressListener;
import sbgc.service.upgrade.VersionImpl;
import sbgc.utils.BGCJFileLoader;
import sbgc.utils.BGCJFileSaver;
import sbgc.utils.FileUtil;
import sbgc.utils.HexUtil;
import sbgc.utils.Settings;
import sbgc.utils.http.HttpTransportFactory;
import sbgc.utils.http.IRequest;
import sbgc.utils.http.IResponse;
import sbgc.utils.http.RequestFactory;
import simplebgc_gui.MyDialog;
import simplebgc_gui.SimpleBGC_GUIApp;

public class DialogBackupManager
extends MyDialog
implements IProgressListener {
    private ButtonGroup buttonGroupBackup;
    private ButtonGroup buttonGroupRestore;
    private JButton jButtonBackup;
    private JButton jButtonBackupFileBrowse;
    private JButton jButtonCancel;
    private JButton jButtonRefresh;
    private JButton jButtonRestore;
    private JButton jButtonRestoreFileBrowse;
    private JLabel jLabelBackupName;
    private JLabel jLabelEmail;
    private JLabel jLabelPassword;
    private JLabel jLabelServer;
    private JLabel jLabelStatus;
    private JPanel jPanelBackup;
    private JPanel jPanelRestore;
    private JPasswordField jPasswordField;
    private JProgressBar jProgressBar;
    private JRadioButton jRadioBackupFactory;
    private JRadioButton jRadioBackupFile;
    private JRadioButton jRadioBackupUser1;
    private JRadioButton jRadioBackupUser2;
    private JRadioButton jRadioBackupUser3;
    private JRadioButton jRadioRestoreFactory;
    private JRadioButton jRadioRestoreFile;
    private JRadioButton jRadioRestoreUser1;
    private JRadioButton jRadioRestoreUser2;
    private JRadioButton jRadioRestoreUser3;
    private JTextField jTextBackupFilename;
    private JTextField jTextBackupName;
    private JTextField jTextEmail;
    private JTextField jTextRestoreFilename;
    public static final int BACKUP_SLOT_FACTORY = 1;
    public static final int BACKUP_SLOT_USER1 = 2;
    public static final int BACKUP_SLOT_USER2 = 3;
    public static final int BACKUP_SLOT_USER3 = 4;
    public static final int BACKUP_SLOT_FILE = 5;
    boolean oldRtDataState;
    boolean[] canBackup = new boolean[4];
    boolean[] canRestore = new boolean[4];
    String[] restoreInfo = new String[4];
    String[] restoreName = new String[4];
    JRadioButton[] backupItems;
    JRadioButton[] restoreItems;
    String temporarySession = null;
    int slot = 0;
    File file = null;
    String email = null;
    String password = null;
    String descr = null;

    private void initComponents() {
        this.buttonGroupBackup = new ButtonGroup();
        this.buttonGroupRestore = new ButtonGroup();
        this.jPanelBackup = new JPanel();
        this.jRadioBackupFactory = new JRadioButton();
        this.jRadioBackupUser1 = new JRadioButton();
        this.jRadioBackupUser2 = new JRadioButton();
        this.jRadioBackupUser3 = new JRadioButton();
        this.jTextEmail = new JTextField();
        this.jLabelEmail = new JLabel();
        this.jLabelPassword = new JLabel();
        this.jPasswordField = new JPasswordField();
        this.jLabelBackupName = new JLabel();
        this.jTextBackupName = new JTextField();
        this.jRadioBackupFile = new JRadioButton();
        this.jTextBackupFilename = new JTextField();
        this.jButtonBackupFileBrowse = new JButton();
        this.jButtonBackup = new JButton();
        this.jLabelServer = new JLabel();
        this.jButtonRefresh = new JButton();
        this.jButtonCancel = new JButton();
        this.jProgressBar = new JProgressBar();
        this.jPanelRestore = new JPanel();
        this.jRadioRestoreFactory = new JRadioButton();
        this.jRadioRestoreUser1 = new JRadioButton();
        this.jRadioRestoreUser2 = new JRadioButton();
        this.jRadioRestoreUser3 = new JRadioButton();
        this.jRadioRestoreFile = new JRadioButton();
        this.jTextRestoreFilename = new JTextField();
        this.jButtonRestoreFileBrowse = new JButton();
        this.jButtonRestore = new JButton();
        this.jLabelStatus = new JLabel();
        this.setDefaultCloseOperation(0);
        this.setModal(true);
        this.setName("Form");
        this.setResizable(false);
        this.getContentPane().setLayout((LayoutManager)new AbsoluteLayout());
        ResourceMap resourceMap = Application.getInstance(SimpleBGC_GUIApp.class).getContext().getResourceMap(DialogBackupManager.class);
        this.jPanelBackup.setBorder(BorderFactory.createTitledBorder(resourceMap.getString("jPanelBackup.border.title", new Object[0])));
        this.jPanelBackup.setName("jPanelBackup");
        this.jPanelBackup.setLayout((LayoutManager)new AbsoluteLayout());
        this.buttonGroupBackup.add(this.jRadioBackupFactory);
        this.jRadioBackupFactory.setText(resourceMap.getString("jRadioBackupFactory.text", new Object[0]));
        this.jRadioBackupFactory.setName("jRadioBackupFactory");
        this.jRadioBackupFactory.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                DialogBackupManager.this.jRadioBackupItemStateChanged(evt);
            }
        });
        this.jPanelBackup.add((Component)this.jRadioBackupFactory, new AbsoluteConstraints(10, 40, -1, -1));
        this.buttonGroupBackup.add(this.jRadioBackupUser1);
        this.jRadioBackupUser1.setText(resourceMap.getString("jRadioBackupUser1.text", new Object[0]));
        this.jRadioBackupUser1.setName("jRadioBackupUser1");
        this.jRadioBackupUser1.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                DialogBackupManager.this.jRadioBackupItemStateChanged(evt);
            }
        });
        this.jPanelBackup.add((Component)this.jRadioBackupUser1, new AbsoluteConstraints(10, 80, -1, -1));
        this.buttonGroupBackup.add(this.jRadioBackupUser2);
        this.jRadioBackupUser2.setText(resourceMap.getString("jRadioBackupUser2.text", new Object[0]));
        this.jRadioBackupUser2.setName("jRadioBackupUser2");
        this.jRadioBackupUser2.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                DialogBackupManager.this.jRadioBackupItemStateChanged(evt);
            }
        });
        this.jPanelBackup.add((Component)this.jRadioBackupUser2, new AbsoluteConstraints(10, 100, -1, -1));
        this.buttonGroupBackup.add(this.jRadioBackupUser3);
        this.jRadioBackupUser3.setText(resourceMap.getString("jRadioBackupUser3.text", new Object[0]));
        this.jRadioBackupUser3.setName("jRadioBackupUser3");
        this.jRadioBackupUser3.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                DialogBackupManager.this.jRadioBackupItemStateChanged(evt);
            }
        });
        this.jPanelBackup.add((Component)this.jRadioBackupUser3, new AbsoluteConstraints(10, 120, -1, -1));
        this.jTextEmail.setText(resourceMap.getString("jTextEmail.text", new Object[0]));
        this.jTextEmail.setName("jTextEmail");
        this.jPanelBackup.add((Component)this.jTextEmail, new AbsoluteConstraints(160, 60, 180, -1));
        this.jLabelEmail.setText(resourceMap.getString("jLabelEmail.text", new Object[0]));
        this.jLabelEmail.setName("jLabelEmail");
        this.jPanelBackup.add((Component)this.jLabelEmail, new AbsoluteConstraints(160, 40, 180, -1));
        this.jLabelPassword.setText(resourceMap.getString("jLabelPassword.text", new Object[0]));
        this.jLabelPassword.setName("jLabelPassword");
        this.jPanelBackup.add((Component)this.jLabelPassword, new AbsoluteConstraints(380, 40, 180, -1));
        this.jPasswordField.setText(resourceMap.getString("jPasswordField.text", new Object[0]));
        this.jPasswordField.setName("jPasswordField");
        this.jPanelBackup.add((Component)this.jPasswordField, new AbsoluteConstraints(380, 60, 180, -1));
        this.jLabelBackupName.setText(resourceMap.getString("jLabelBackupName.text", new Object[0]));
        this.jLabelBackupName.setName("jLabelBackupName");
        this.jPanelBackup.add((Component)this.jLabelBackupName, new AbsoluteConstraints(160, 90, -1, -1));
        this.jTextBackupName.setText(resourceMap.getString("jTextBackupName.text", new Object[0]));
        this.jTextBackupName.setName("jTextBackupName");
        this.jPanelBackup.add((Component)this.jTextBackupName, new AbsoluteConstraints(160, 110, 440, -1));
        this.buttonGroupBackup.add(this.jRadioBackupFile);
        this.jRadioBackupFile.setSelected(true);
        this.jRadioBackupFile.setText(resourceMap.getString("jRadioBackupFile.text", new Object[0]));
        this.jRadioBackupFile.setName("jRadioBackupFile");
        this.jRadioBackupFile.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                DialogBackupManager.this.jRadioBackupItemStateChanged(evt);
            }
        });
        this.jPanelBackup.add((Component)this.jRadioBackupFile, new AbsoluteConstraints(10, 160, -1, -1));
        this.jTextBackupFilename.setText(resourceMap.getString("jTextBackupFilename.text", new Object[0]));
        this.jTextBackupFilename.setName("jTextBackupFilename");
        this.jPanelBackup.add((Component)this.jTextBackupFilename, new AbsoluteConstraints(160, 160, 330, -1));
        ApplicationActionMap actionMap = Application.getInstance(SimpleBGC_GUIApp.class).getContext().getActionMap(DialogBackupManager.class, this);
        this.jButtonBackupFileBrowse.setAction(actionMap.get("buttonBackupFileBrowse"));
        this.jButtonBackupFileBrowse.setText(resourceMap.getString("jButtonBackupFileBrowse.text", new Object[0]));
        this.jButtonBackupFileBrowse.setName("jButtonBackupFileBrowse");
        this.jPanelBackup.add((Component)this.jButtonBackupFileBrowse, new AbsoluteConstraints(500, 160, 100, -1));
        this.jButtonBackup.setAction(actionMap.get("buttonBackupStart"));
        this.jButtonBackup.setText(resourceMap.getString("jButtonBackup.text", new Object[0]));
        this.jButtonBackup.setName("jButtonBackup");
        this.jPanelBackup.add((Component)this.jButtonBackup, new AbsoluteConstraints(420, 210, 180, 30));
        this.jLabelServer.setText(resourceMap.getString("jLabelServer.text", new Object[0]));
        this.jLabelServer.setName("jLabelServer");
        this.jPanelBackup.add((Component)this.jLabelServer, new AbsoluteConstraints(20, 20, -1, -1));
        this.getContentPane().add((Component)this.jPanelBackup, new AbsoluteConstraints(0, 0, 620, 250));
        this.jButtonRefresh.setAction(actionMap.get("buttonRefresh"));
        this.jButtonRefresh.setText(resourceMap.getString("jButtonRefresh.text", new Object[0]));
        this.jButtonRefresh.setName("jButtonRefresh");
        this.getContentPane().add((Component)this.jButtonRefresh, new AbsoluteConstraints(360, 480, 120, 30));
        this.jButtonCancel.setAction(actionMap.get("buttonCancel"));
        this.jButtonCancel.setText(resourceMap.getString("jButtonCancel.text", new Object[0]));
        this.jButtonCancel.setName("jButtonCancel");
        this.getContentPane().add((Component)this.jButtonCancel, new AbsoluteConstraints(490, 480, 120, 30));
        this.jProgressBar.setName("jProgressBar");
        this.jProgressBar.setStringPainted(true);
        this.getContentPane().add((Component)this.jProgressBar, new AbsoluteConstraints(10, 480, 330, 20));
        this.jPanelRestore.setBorder(BorderFactory.createTitledBorder(resourceMap.getString("jPanelRestore.border.title", new Object[0])));
        this.jPanelRestore.setName("jPanelRestore");
        this.jPanelRestore.setLayout((LayoutManager)new AbsoluteLayout());
        this.buttonGroupRestore.add(this.jRadioRestoreFactory);
        this.jRadioRestoreFactory.setText(resourceMap.getString("jRadioBackupFactory.text", new Object[0]));
        this.jRadioRestoreFactory.setName("jRadioRestoreFactory");
        this.jRadioRestoreFactory.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                DialogBackupManager.this.jRadioBackupItemStateChanged(evt);
            }
        });
        this.jPanelRestore.add((Component)this.jRadioRestoreFactory, new AbsoluteConstraints(10, 20, -1, -1));
        this.buttonGroupRestore.add(this.jRadioRestoreUser1);
        this.jRadioRestoreUser1.setText(resourceMap.getString("jRadioBackupUser1.text", new Object[0]));
        this.jRadioRestoreUser1.setName("jRadioRestoreUser1");
        this.jRadioRestoreUser1.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                DialogBackupManager.this.jRadioBackupItemStateChanged(evt);
            }
        });
        this.jPanelRestore.add((Component)this.jRadioRestoreUser1, new AbsoluteConstraints(10, 40, -1, -1));
        this.buttonGroupRestore.add(this.jRadioRestoreUser2);
        this.jRadioRestoreUser2.setText(resourceMap.getString("jRadioBackupUser2.text", new Object[0]));
        this.jRadioRestoreUser2.setName("jRadioRestoreUser2");
        this.jRadioRestoreUser2.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                DialogBackupManager.this.jRadioBackupItemStateChanged(evt);
            }
        });
        this.jPanelRestore.add((Component)this.jRadioRestoreUser2, new AbsoluteConstraints(10, 60, -1, -1));
        this.buttonGroupRestore.add(this.jRadioRestoreUser3);
        this.jRadioRestoreUser3.setText(resourceMap.getString("jRadioBackupUser3.text", new Object[0]));
        this.jRadioRestoreUser3.setName("jRadioRestoreUser3");
        this.jRadioRestoreUser3.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                DialogBackupManager.this.jRadioBackupItemStateChanged(evt);
            }
        });
        this.jPanelRestore.add((Component)this.jRadioRestoreUser3, new AbsoluteConstraints(10, 80, -1, -1));
        this.buttonGroupRestore.add(this.jRadioRestoreFile);
        this.jRadioRestoreFile.setSelected(true);
        this.jRadioRestoreFile.setText(resourceMap.getString("jRadioRestoreFile.text", new Object[0]));
        this.jRadioRestoreFile.setName("jRadioRestoreFile");
        this.jRadioRestoreFile.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                DialogBackupManager.this.jRadioBackupItemStateChanged(evt);
            }
        });
        this.jPanelRestore.add((Component)this.jRadioRestoreFile, new AbsoluteConstraints(10, 110, 110, -1));
        this.jTextRestoreFilename.setName("jTextRestoreFilename");
        this.jPanelRestore.add((Component)this.jTextRestoreFilename, new AbsoluteConstraints(160, 110, 330, -1));
        this.jButtonRestoreFileBrowse.setAction(actionMap.get("buttonRestoreFileBrowse"));
        this.jButtonRestoreFileBrowse.setText(resourceMap.getString("jButtonRestoreFileBrowse.text", new Object[0]));
        this.jButtonRestoreFileBrowse.setName("jButtonRestoreFileBrowse");
        this.jPanelRestore.add((Component)this.jButtonRestoreFileBrowse, new AbsoluteConstraints(500, 110, 100, -1));
        this.jButtonRestore.setAction(actionMap.get("buttonRestoreStart"));
        this.jButtonRestore.setText(resourceMap.getString("jButtonRestore.text", new Object[0]));
        this.jButtonRestore.setName("jButtonRestore");
        this.jPanelRestore.add((Component)this.jButtonRestore, new AbsoluteConstraints(420, 140, 180, 30));
        this.getContentPane().add((Component)this.jPanelRestore, new AbsoluteConstraints(0, 250, 620, 180));
        this.jLabelStatus.setText(resourceMap.getString("jLabelStatus.text", new Object[0]));
        this.jLabelStatus.setName("jLabelStatus");
        this.getContentPane().add((Component)this.jLabelStatus, new AbsoluteConstraints(10, 430, 610, 50));
        this.pack();
    }

    private void jRadioBackupItemStateChanged(ItemEvent evt) {
        this.updateBackupRestoreItemState();
    }

    public DialogBackupManager(Frame parent) {
        super(DialogBackupManager.class, parent, SimpleBGC_GUIApp.getResourceMap().getString("title.dialog_backup_manager", new Object[0]));
        this.initComponents();
        this.backupItems = new JRadioButton[]{this.jRadioBackupFactory, this.jRadioBackupUser1, this.jRadioBackupUser2, this.jRadioBackupUser3, this.jRadioBackupFile};
        this.restoreItems = new JRadioButton[]{this.jRadioRestoreFactory, this.jRadioRestoreUser1, this.jRadioRestoreUser2, this.jRadioRestoreUser3, this.jRadioRestoreFile};
        for (int slot = 0; slot < 4; ++slot) {
            this.canBackup[slot] = false;
            this.restoreInfo[slot] = null;
        }
        this.oldRtDataState = RealtimeDataThread.pause(true);
        this.jProgressBar.setVisible(false);
        this.updateBackupRestoreItemState();
        this.jTextEmail.setText(Settings.get("backup.service_email", ""));
        this.jPasswordField.setText(Settings.get("backup.service_password", ""));
        this.jTextBackupName.setText(Settings.get("backup.name", ""));
        this.requestBackupInformationFromServer();
        ItemListener backupItemListener = new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                if (evt.getStateChange() == 1) {
                    for (int i = 2; i <= 4; ++i) {
                        if (!DialogBackupManager.this.backupItems[i - 1].isSelected() || DialogBackupManager.this.restoreInfo[i - 1] == null) continue;
                        DialogBackupManager.this.jTextBackupName.setText(DialogBackupManager.this.restoreName[i - 1]);
                    }
                }
            }
        };
        for (JRadioButton b : this.backupItems) {
            b.addItemListener(backupItemListener);
        }
    }

    private void updateBackupRestoreItemState() {
        boolean userSelected = false;
        for (int slot = 0; slot < 4; ++slot) {
            this.backupItems[slot].setEnabled(this.canBackup[slot]);
            if (slot < 1 || slot > 3 || !this.canBackup[slot] || !this.backupItems[slot].isSelected()) continue;
            userSelected = true;
        }
        boolean factorySelected = this.canBackup[0] && this.jRadioBackupFactory.isSelected();
        this.jTextEmail.setEnabled(factorySelected);
        this.jLabelEmail.setEnabled(factorySelected);
        this.jPasswordField.setEnabled(factorySelected);
        this.jLabelPassword.setEnabled(factorySelected);
        this.jTextBackupName.setEnabled(userSelected || factorySelected);
        this.jLabelBackupName.setEnabled(userSelected || factorySelected);
        boolean fileSelected = this.jRadioBackupFile.isSelected();
        this.jTextBackupFilename.setEnabled(fileSelected);
        this.jButtonBackupFileBrowse.setEnabled(fileSelected);
        for (int slot = 0; slot < 4; ++slot) {
            this.restoreItems[slot].setEnabled(this.restoreInfo[slot] != null);
            this.restoreItems[slot].setText(this.backupItems[slot].getText() + (this.restoreInfo[slot] != null ? " (" + this.restoreInfo[slot] + ")" : ""));
        }
        fileSelected = this.jRadioRestoreFile.isSelected();
        this.jTextRestoreFilename.setEnabled(fileSelected);
        this.jButtonRestoreFileBrowse.setEnabled(fileSelected);
    }

    @Action
    public void buttonCancel() {
        this.cancelDialog();
    }

    /*
     * Enabled aggressive block sorting
     */
    @Action
    public void buttonBackupStart() {
        BoardInfo boardInfo;
        block9: {
            boardInfo = BoardInfo.getBoardInfo();
            if (boardInfo == null || boardInfo.eeprom_size == 0) {
                this.showError("BoardInfo is not received, or EEPROM reading is not supported!");
            }
            this.slot = 0;
            this.descr = this.jTextBackupName.getText();
            Settings.set("backup.name", this.descr);
            if (this.jRadioBackupFile.isSelected()) {
                if (this.jTextBackupFilename.getText().isEmpty()) {
                    this.showError(this.resourceMap.getString("error.filename_is_not_provided", new Object[0]));
                    return;
                }
                this.file = new File(this.jTextBackupFilename.getText());
                this.slot = 5;
            } else {
                if (this.jRadioBackupFactory.isSelected() && this.canBackup[0]) {
                    if (!this.jTextEmail.getText().isEmpty() && this.jPasswordField.getPassword().length > 0) {
                        this.slot = 1;
                        this.email = this.jTextEmail.getText();
                        this.password = new String(this.jPasswordField.getPassword());
                        Settings.set("backup.service_email", this.email);
                        Settings.setTemporary("backup.service_password", this.password);
                        break block9;
                    } else {
                        this.showError(this.resourceMap.getString("error.missed_service_account", new Object[0]));
                        return;
                    }
                }
                for (int i = 2; i <= 4; ++i) {
                    if (!this.backupItems[i - 1].isSelected() || !this.canBackup[i - 1]) continue;
                    this.slot = i;
                }
            }
        }
        if (this.slot == 0) {
            this.showError(this.resourceMap.getString("error.backup_slot_not_selected", new Object[0]));
            return;
        }
        Settings.save();
        final DialogBackupManager dialogBackupManager = this;
        final DialogBackupManager progressListener = this;
        new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    progressListener.onProgressStart(DialogBackupManager.this.resourceMap.getString("progress.reading_eeprom", new Object[0]), true);
                    SerialCommandProcessor.sendCommand(new SerialCommand(109, 0));
                    byte[] data = SerialCommandProcessor.readEEPROM(0, boardInfo.eeprom_size, progressListener);
                    if (dialogBackupManager.slot == 5) {
                        FileUtil.saveBackupData(1, dialogBackupManager.file, data);
                    } else {
                        progressListener.onProgressStart(DialogBackupManager.this.resourceMap.getString("progress.backup_to_server", new Object[0]), true);
                        String sign = SerialCommandSignMessageImpl.signMessage(DialogBackupManager.this.temporarySession, 2);
                        progressListener.onProgressChange(30);
                        IRequest request = RequestFactory.getRequest();
                        request.setMethod(2);
                        request.addParameter("act", "sbgc.save_backup");
                        request.addParameter("device_id", boardInfo.getDeviceId());
                        request.addParameter("mcu_id", boardInfo.getMcuId());
                        request.addParameter("slot", Integer.toString(dialogBackupManager.slot));
                        request.addParameter("sign", sign);
                        request.addParameter("firmware_ver", Integer.toString(boardInfo.getFrwVerShow()));
                        if (dialogBackupManager.descr != null) {
                            request.addParameter("descr", dialogBackupManager.descr);
                        }
                        if (dialogBackupManager.email != null) {
                            request.addParameter("email", dialogBackupManager.email);
                        }
                        if (dialogBackupManager.password != null) {
                            request.addParameter("password", dialogBackupManager.password);
                        }
                        request.addParameter("data", HexUtil.toHex(data));
                        IResponse response = HttpTransportFactory.getTransport().send(request);
                        progressListener.onProgressChange(100);
                        if (response.getErrorCode() != null && response.getErrorCode() == 0) {
                            dialogBackupManager.parseBackupInfoResponse(response);
                        } else {
                            throw new Exception(response.getErrorMessage() != null ? response.getErrorMessage() : "Invalid response" + (response.getErrorCode() != null ? " code: " + response.getErrorCode() + "!" : "!"));
                        }
                    }
                    DialogBackupManager.this.updateStatus(DialogBackupManager.this.resourceMap.getString("status.backup_EEPROM.done", new Object[0]));
                }
                catch (Exception e) {
                    DialogBackupManager.this.showError(e.getMessage());
                }
                finally {
                    progressListener.onProgressFinish(true);
                }
            }
        }).start();
    }

    /*
     * Enabled aggressive block sorting
     */
    @Action
    public void buttonRestoreStart() {
        final BoardInfo boardInfo = BoardInfo.getBoardInfo();
        if (boardInfo == null || boardInfo.eeprom_size == 0) {
            return;
        }
        this.slot = 0;
        if (this.jRadioRestoreFile.isSelected()) {
            if (this.jTextRestoreFilename.getText().isEmpty()) {
                this.showError(this.resourceMap.getString("error.filename_is_not_provided", new Object[0]));
                return;
            }
            this.slot = 5;
            this.file = new File(this.jTextRestoreFilename.getText());
        } else {
            for (int i = 1; i <= 4; ++i) {
                if (!this.restoreItems[i - 1].isSelected() || this.restoreInfo[i - 1] == null) continue;
                this.slot = i;
            }
        }
        if (this.slot == 0) {
            this.showError(this.resourceMap.getString("error.restore_slot_not_selected", new Object[0]));
            return;
        }
        if (JOptionPane.showConfirmDialog(this, this.resourceMap.getString("confirm.restore_EEPROM", new Object[0]), this.resourceMap.getString("messageDialog.confirm.title", new Object[0]), 0) == 0) {
            final DialogBackupManager dialogBackupManager = this;
            final DialogBackupManager progressListener = this;
            new Thread(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        progressListener.onProgressStart("", true);
                        BackupData data = null;
                        if (dialogBackupManager.slot == 5) {
                            data = FileUtil.readBackupData(1, dialogBackupManager.file);
                            if (data == null) {
                                return;
                            }
                        } else {
                            progressListener.onProgressStart(DialogBackupManager.this.resourceMap.getString("progress.downloading_eeprom", new Object[0]), true);
                            String sign = SerialCommandSignMessageImpl.signMessage(DialogBackupManager.this.temporarySession, 2);
                            progressListener.onProgressChange(30);
                            IRequest request = RequestFactory.getRequest();
                            request.addParameter("act", "sbgc.get_backup");
                            request.addParameter("device_id", boardInfo.getDeviceId());
                            request.addParameter("mcu_id", boardInfo.getMcuId());
                            request.addParameter("slot", Integer.toString(dialogBackupManager.slot));
                            request.addParameter("sign", sign);
                            IResponse response = HttpTransportFactory.getTransport().send(request);
                            progressListener.onProgressChange(100);
                            if (response.getErrorCode() != null && response.getErrorCode() == 0) {
                                String hex_data = response.getResultData().get("data");
                                if (hex_data == null || hex_data.isEmpty()) {
                                    throw new Exception("'data' missed in response.");
                                }
                                data = new BackupData();
                                data.data = HexUtil.fromHex(hex_data);
                                String frwVerStr = response.getResultData().get("firmware_ver");
                                data.frwVer = frwVerStr != null ? Integer.parseInt(frwVerStr) : 0;
                            } else {
                                throw new Exception(response.getErrorMessage() != null ? response.getErrorMessage() : "Invalid response" + (response.getErrorCode() != null ? " code: " + response.getErrorCode() + "!" : "!"));
                            }
                        }
                        if (boardInfo.getFrwVer() < data.frwVer && boardInfo.getFrwVer() > 0) {
                            Object[] options = new Object[]{SimpleBGC_GUIApp.getResourceMap().getString("confirm.restore_EEPROM.yes_button", new Object[0]), SimpleBGC_GUIApp.getResourceMap().getString("confirm.restore_EEPROM.no_button", new Object[0]), UIManager.get("OptionPane.cancelButtonText")};
                            int res = JOptionPane.showOptionDialog(SimpleBGC_GUIApp.mainView.getFrame(), SimpleBGC_GUIApp.getResourceMap().getString("confirm.restore_EEPROM.firmware_ver_mismatch", new VersionImpl(data.frwVer).toString()), SimpleBGC_GUIApp.getResourceMap().getString("messageDialog.confirm.title", new Object[0]), 1, 2, null, options, options[1]);
                            if (res == 1) {
                                dialogBackupManager.closeDialog(-1);
                                SimpleBGC_GUIApp.mainView.setSelectedTab(SimpleBGC_GUIApp.mainView.panelFirmwareUpdate);
                                return;
                            }
                            if (res == 2) {
                                return;
                            }
                        }
                        progressListener.onProgressStart(DialogBackupManager.this.resourceMap.getString("progress.writing_eeprom", new Object[0]), true);
                        SerialCommandProcessor.sendCommand(new SerialCommand(109, 0));
                        SerialCommandProcessor.writeEEPROM(0, data.data, progressListener);
                        progressListener.onProgressStart(DialogBackupManager.this.resourceMap.getString("progress.restarting_board", new Object[0]), true);
                        SerialCommandProcessor.sendCommand(new SerialCommand(114));
                        SerialCommandProcessor.waitForReset(progressListener);
                        DialogBackupManager.this.updateStatus(DialogBackupManager.this.resourceMap.getString("status.restore_EEPROM.done", new Object[0]));
                    }
                    catch (Exception e) {
                        DialogBackupManager.this.showError(e.getMessage());
                        return;
                    }
                    finally {
                        progressListener.onProgressFinish(true);
                    }
                    SerialCommandProcessor.readAllParams(-1);
                }
            }).start();
        }
    }

    public void updateStatus(final String statusMessage) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                DialogBackupManager.this.jLabelStatus.setText("<html>" + statusMessage + "</html>");
            }
        });
    }

    @Override
    public void onProgressStart(final String action, boolean modal) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                DialogBackupManager.this.jButtonRefresh.setEnabled(false);
                DialogBackupManager.this.jButtonBackup.setEnabled(false);
                DialogBackupManager.this.jButtonRestore.setEnabled(false);
                DialogBackupManager.this.jProgressBar.setVisible(true);
                DialogBackupManager.this.updateStatus(action);
            }
        });
    }

    @Override
    public boolean onProgressChange(final int percent) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                DialogBackupManager.this.jProgressBar.setValue(percent);
            }
        });
        return !this.isCancelled();
    }

    @Override
    public void onProgressFinish(final boolean isSuccess) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (!isSuccess) {
                    DialogBackupManager.this.showError(ErrorInfo.getCurErrors());
                    DialogBackupManager.this.result = -2;
                }
                DialogBackupManager.this.jButtonRefresh.setEnabled(true);
                DialogBackupManager.this.jButtonBackup.setEnabled(true);
                DialogBackupManager.this.jButtonRestore.setEnabled(true);
                DialogBackupManager.this.jProgressBar.setVisible(false);
            }
        });
    }

    @Override
    public void onCloseDialog() {
        RealtimeDataThread.pause(this.oldRtDataState);
    }

    public void showError(String error) {
        JOptionPane.showMessageDialog(this, error, this.resourceMap.getString("messageDialog.error.title", new Object[0]), 0);
    }

    public void fatalError(String error) {
        this.showError(error);
        this.closeDialog(-2);
    }

    @Action
    public void buttonBackupFileBrowse() {
        BGCJFileSaver fileSaver = new BGCJFileSaver(this, new String[]{"data"}, SimpleBGC_GUIApp.getResourceMap().getString("file_type.backup.data", new Object[0]), "last_used_profiles_directory");
        String filePath = fileSaver.getFilePath(this.jTextBackupFilename.getText(), true);
        if (filePath != null) {
            this.jTextBackupFilename.setText(filePath);
        }
    }

    @Action
    public void buttonRestoreFileBrowse() {
        BGCJFileLoader fileLoader = new BGCJFileLoader(this, new String[]{"data"}, SimpleBGC_GUIApp.getResourceMap().getString("file_type.backup.data", new Object[0]), "last_used_profiles_directory");
        String filePath = fileLoader.getFilePath();
        if (filePath != null) {
            this.jTextRestoreFilename.setText(filePath);
        }
    }

    private void requestBackupInformationFromServer() {
        final BoardInfo boardInfo = BoardInfo.getBoardInfo();
        if (boardInfo == null) {
            return;
        }
        final DialogBackupManager dialogBackupManager = this;
        final DialogBackupManager progressListener = this;
        new Thread(new Runnable(){

            @Override
            public void run() {
                block6: {
                    try {
                        progressListener.onProgressStart(DialogBackupManager.this.resourceMap.getString("progress.requesting_backup_info_from_server", new Object[0]), true);
                        IRequest request = RequestFactory.getRequest();
                        request.addParameter("act", "sbgc.backup_info");
                        request.addParameter("device_id", boardInfo.getDeviceId());
                        request.addParameter("mcu_id", boardInfo.getMcuId());
                        IResponse response = HttpTransportFactory.getTransport().send(request);
                        progressListener.onProgressChange(100);
                        if (response.getErrorCode() != null && response.getErrorCode() == 0) {
                            dialogBackupManager.parseBackupInfoResponse(response);
                            DialogBackupManager.this.updateStatus(DialogBackupManager.this.resourceMap.getString("status.backup_information_is_loaded", new Object[0]));
                            Thread.sleep(500L);
                            break block6;
                        }
                        throw new Exception(response.getErrorMessage() != null ? response.getErrorMessage() : "Invalid response" + (response.getErrorCode() != null ? " code: " + response.getErrorCode() + "!" : "!"));
                    }
                    catch (Exception e) {
                        DialogBackupManager.this.updateStatus("Backup information is not received:\n" + e.getMessage());
                    }
                    finally {
                        progressListener.onProgressFinish(true);
                    }
                }
            }
        }).start();
    }

    @Action
    public void buttonRefresh() {
        this.requestBackupInformationFromServer();
    }

    public void parseBackupInfoResponse(IResponse response) throws Exception {
        this.temporarySession = response.getResultData().get("session");
        if (this.temporarySession == null) {
            throw new Exception("temporarySession missed!");
        }
        for (int slot = 0; slot < 4; ++slot) {
            this.canBackup[slot] = true;
            String info = response.getResultData().get("slot" + (slot + 1) + "_info");
            this.restoreInfo[slot] = info != null && !info.isEmpty() ? info : null;
            String name = response.getResultData().get("slot" + (slot + 1) + "_name");
            this.restoreName[slot] = name != null && !name.isEmpty() ? name : null;
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                DialogBackupManager.this.updateBackupRestoreItemState();
            }
        });
    }
}

