/*
 * Decompiled with CFR 0.152.
 */
package simplebgc_gui;

import java.awt.Component;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.text.DefaultCaret;
import org.jdesktop.application.Action;
import org.jdesktop.application.Application;
import org.jdesktop.application.ApplicationActionMap;
import org.jdesktop.application.ResourceMap;
import org.netbeans.lib.awtextra.AbsoluteConstraints;
import org.netbeans.lib.awtextra.AbsoluteLayout;
import sbgc.object.BoardInfo;
import sbgc.object.BoardParams;
import sbgc.object.BoardProfile;
import sbgc.service.ICommandResponseListener;
import sbgc.service.RealtimeDataThread;
import sbgc.service.SerialCommand;
import sbgc.service.SerialCommandDispatcher;
import sbgc.service.SerialCommandProcessor;
import sbgc.service.SerialPortService;
import simplebgc_gui.BTModule;
import simplebgc_gui.BTModuleHC03_05;
import simplebgc_gui.BTModuleHC04_06;
import simplebgc_gui.BTModuleHM10;
import simplebgc_gui.BTModuleHM12;
import simplebgc_gui.BTModuleRN42;
import simplebgc_gui.MyDialog;
import simplebgc_gui.SimpleBGC_GUIApp;
import simplebgc_gui.UartCmdSender;

public class DialogBluetooth
extends MyDialog
implements ICommandResponseListener,
UartCmdSender {
    private JButton jButtoCancel;
    private JButton jButtonDefaults;
    private JButton jButtonSend;
    private JButton jButtonWrite;
    private JComboBox jComboBoxCurParity;
    private JComboBox jComboBoxCurSpeed;
    private JComboBox jComboBoxNewParity;
    private JComboBox jComboBoxNewSpeed;
    private JComboBox jComboBoxPort;
    private JComboBox jComboBoxType;
    private JLabel jLabelAT;
    private JLabel jLabelCurBaud;
    private JLabel jLabelName;
    private JLabel jLabelNewBaud;
    private JLabel jLabelPIN;
    private JLabel jLabelPort;
    private JLabel jLabelType;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JScrollPane jScrollPane2;
    private JSeparator jSeparator3;
    private JTextArea jTextAreaDebugCmd;
    private JTextField jTextFieldAT;
    private JTextField jTextFieldName;
    private JTextField jTextFieldPIN;
    JComboBox[] speedBox;
    final BTModule[] BT_MODULE_TYPES = new BTModule[]{new BTModuleHM10(this), new BTModuleHM12(this), new BTModuleHC03_05(this), new BTModuleHC04_06(this), new BTModuleRN42(this)};
    public static final int DEFAULT_TIMEOUT = 3000;
    boolean rtPauseState;
    SerialCommand responseCmd = null;
    int portIdx;
    int curSpeed;
    int curParity;
    BTModule moduleType = null;
    boolean isReady = false;

    private void initComponents() {
        this.jButtoCancel = new JButton();
        this.jButtonWrite = new JButton();
        this.jScrollPane2 = new JScrollPane();
        this.jTextAreaDebugCmd = new JTextArea();
        this.jLabelAT = new JLabel();
        this.jTextFieldAT = new JTextField();
        this.jButtonSend = new JButton();
        this.jButtonDefaults = new JButton();
        this.jSeparator3 = new JSeparator();
        this.jPanel1 = new JPanel();
        this.jLabelPort = new JLabel();
        this.jComboBoxPort = new JComboBox();
        this.jLabelType = new JLabel();
        this.jComboBoxType = new JComboBox();
        this.jLabelCurBaud = new JLabel();
        this.jComboBoxCurSpeed = new JComboBox();
        this.jComboBoxCurParity = new JComboBox();
        this.jPanel2 = new JPanel();
        this.jLabelNewBaud = new JLabel();
        this.jComboBoxNewSpeed = new JComboBox();
        this.jComboBoxNewParity = new JComboBox();
        this.jLabelName = new JLabel();
        this.jTextFieldName = new JTextField();
        this.jTextFieldPIN = new JTextField();
        this.jLabelPIN = new JLabel();
        this.setDefaultCloseOperation(0);
        this.setModal(true);
        this.setName("Form");
        this.setResizable(false);
        this.getContentPane().setLayout((LayoutManager)new AbsoluteLayout());
        ApplicationActionMap actionMap = Application.getInstance(SimpleBGC_GUIApp.class).getContext().getActionMap(DialogBluetooth.class, this);
        this.jButtoCancel.setAction(actionMap.get("buttonCancel"));
        ResourceMap resourceMap = Application.getInstance(SimpleBGC_GUIApp.class).getContext().getResourceMap(DialogBluetooth.class);
        this.jButtoCancel.setText(resourceMap.getString("jButtoCancel.text", new Object[0]));
        this.jButtoCancel.setName("jButtoCancel");
        this.getContentPane().add((Component)this.jButtoCancel, new AbsoluteConstraints(480, 260, 110, 30));
        this.jButtonWrite.setAction(actionMap.get("buttonWrite"));
        this.jButtonWrite.setText(resourceMap.getString("jButtonWrite.text", new Object[0]));
        this.jButtonWrite.setName("jButtonWrite");
        this.getContentPane().add((Component)this.jButtonWrite, new AbsoluteConstraints(360, 260, 110, 30));
        this.jScrollPane2.setName("jScrollPane2");
        this.jTextAreaDebugCmd.setColumns(20);
        this.jTextAreaDebugCmd.setRows(5);
        this.jTextAreaDebugCmd.setName("jTextAreaDebugCmd");
        this.jScrollPane2.setViewportView(this.jTextAreaDebugCmd);
        this.getContentPane().add((Component)this.jScrollPane2, new AbsoluteConstraints(10, 340, 580, 110));
        this.jLabelAT.setText(resourceMap.getString("jLabelAT.text", new Object[0]));
        this.jLabelAT.setName("jLabelAT");
        this.getContentPane().add((Component)this.jLabelAT, new AbsoluteConstraints(10, 310, -1, -1));
        this.jTextFieldAT.setText(resourceMap.getString("jTextFieldAT.text", new Object[0]));
        this.jTextFieldAT.setName("jTextFieldAT");
        this.getContentPane().add((Component)this.jTextFieldAT, new AbsoluteConstraints(210, 310, 310, -1));
        this.jButtonSend.setAction(actionMap.get("buttonSend"));
        this.jButtonSend.setText(resourceMap.getString("jButtonSend.text", new Object[0]));
        this.jButtonSend.setName("jButtonSend");
        this.getContentPane().add((Component)this.jButtonSend, new AbsoluteConstraints(530, 310, -1, -1));
        this.jButtonDefaults.setAction(actionMap.get("buttonResetDefaults"));
        this.jButtonDefaults.setText(resourceMap.getString("jButtonDefaults.text", new Object[0]));
        this.jButtonDefaults.setName("jButtonDefaults");
        this.getContentPane().add((Component)this.jButtonDefaults, new AbsoluteConstraints(20, 260, 190, 30));
        this.jSeparator3.setName("jSeparator3");
        this.getContentPane().add((Component)this.jSeparator3, new AbsoluteConstraints(0, 300, 600, 10));
        this.jPanel1.setBorder(BorderFactory.createTitledBorder(resourceMap.getString("jPanel1.border.title", new Object[0])));
        this.jPanel1.setName("jPanel1");
        this.jPanel1.setLayout((LayoutManager)new AbsoluteLayout());
        this.jLabelPort.setText(resourceMap.getString("jLabelPort.text", new Object[0]));
        this.jLabelPort.setName("jLabelPort");
        this.jPanel1.add((Component)this.jLabelPort, new AbsoluteConstraints(30, 20, -1, -1));
        this.jComboBoxPort.setModel(new DefaultComboBoxModel<String>(new String[]{"UART1", "RC_SERIAL", "UART2"}));
        this.jComboBoxPort.setName("jComboBoxPort");
        this.jPanel1.add((Component)this.jComboBoxPort, new AbsoluteConstraints(240, 20, -1, -1));
        this.jLabelType.setText(resourceMap.getString("jLabelType.text", new Object[0]));
        this.jLabelType.setName("jLabelType");
        this.jPanel1.add((Component)this.jLabelType, new AbsoluteConstraints(30, 50, -1, -1));
        this.jComboBoxType.setName("jComboBoxType");
        this.jPanel1.add((Component)this.jComboBoxType, new AbsoluteConstraints(240, 50, -1, -1));
        this.jLabelCurBaud.setText(resourceMap.getString("jLabelCurBaud.text", new Object[0]));
        this.jLabelCurBaud.setName("jLabelCurBaud");
        this.jPanel1.add((Component)this.jLabelCurBaud, new AbsoluteConstraints(30, 80, -1, -1));
        this.jComboBoxCurSpeed.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.jComboBoxCurSpeed.setToolTipText(resourceMap.getString("jComboBoxCurSpeed.toolTipText", new Object[0]));
        this.jComboBoxCurSpeed.setName("jComboBoxCurSpeed");
        this.jPanel1.add((Component)this.jComboBoxCurSpeed, new AbsoluteConstraints(240, 80, 190, -1));
        this.jComboBoxCurParity.setModel(new DefaultComboBoxModel<String>(new String[]{"None", "Even", "Odd"}));
        this.jComboBoxCurParity.setName("jComboBoxCurParity");
        this.jPanel1.add((Component)this.jComboBoxCurParity, new AbsoluteConstraints(440, 80, -1, -1));
        this.getContentPane().add((Component)this.jPanel1, new AbsoluteConstraints(10, 10, 580, 120));
        this.jPanel2.setBorder(BorderFactory.createTitledBorder(resourceMap.getString("jPanel2.border.title", new Object[0])));
        this.jPanel2.setName("jPanel2");
        this.jPanel2.setLayout((LayoutManager)new AbsoluteLayout());
        this.jLabelNewBaud.setText(resourceMap.getString("jLabelNewBaud.text", new Object[0]));
        this.jLabelNewBaud.setName("jLabelNewBaud");
        this.jPanel2.add((Component)this.jLabelNewBaud, new AbsoluteConstraints(30, 20, -1, -1));
        this.jComboBoxNewSpeed.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.jComboBoxNewSpeed.setToolTipText(resourceMap.getString("jComboBoxNewSpeed.toolTipText", new Object[0]));
        this.jComboBoxNewSpeed.setName("jComboBoxNewSpeed");
        this.jPanel2.add((Component)this.jComboBoxNewSpeed, new AbsoluteConstraints(240, 20, 190, -1));
        this.jComboBoxNewParity.setModel(new DefaultComboBoxModel<String>(new String[]{"None", "Even", "Odd"}));
        this.jComboBoxNewParity.setName("jComboBoxNewParity");
        this.jPanel2.add((Component)this.jComboBoxNewParity, new AbsoluteConstraints(440, 20, -1, -1));
        this.jLabelName.setText(resourceMap.getString("jLabelName.text", new Object[0]));
        this.jLabelName.setName("jLabelName");
        this.jPanel2.add((Component)this.jLabelName, new AbsoluteConstraints(30, 50, -1, -1));
        this.jTextFieldName.setText(resourceMap.getString("jTextFieldName.text", new Object[0]));
        this.jTextFieldName.setName("jTextFieldName");
        this.jPanel2.add((Component)this.jTextFieldName, new AbsoluteConstraints(240, 50, 120, -1));
        this.jTextFieldPIN.setText(resourceMap.getString("jTextFieldPIN.text", new Object[0]));
        this.jTextFieldPIN.setName("jTextFieldPIN");
        this.jPanel2.add((Component)this.jTextFieldPIN, new AbsoluteConstraints(240, 80, 120, -1));
        this.jLabelPIN.setText(resourceMap.getString("jLabelPIN.text", new Object[0]));
        this.jLabelPIN.setName("jLabelPIN");
        this.jPanel2.add((Component)this.jLabelPIN, new AbsoluteConstraints(30, 80, -1, -1));
        this.getContentPane().add((Component)this.jPanel2, new AbsoluteConstraints(10, 130, 580, 120));
        this.pack();
    }

    public DialogBluetooth(Frame parent) throws Exception {
        super(DialogBluetooth.class, parent, SimpleBGC_GUIApp.getResourceMap().getString("title.dialog_bluetooth", new Object[0]));
        if (!BoardInfo.checkMinPartnerFirmwareVer(2553)) {
            throw new Exception("Firmware version 2.55b3 or greater is required!");
        }
        this.initComponents();
        this.getRootPane().registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DialogBluetooth.this.buttonSend();
            }
        }, KeyStroke.getKeyStroke(10, 0), 2);
        for (JComboBox b : this.speedBox = new JComboBox[]{this.jComboBoxCurSpeed, this.jComboBoxNewSpeed}) {
            BoardProfile p;
            int i;
            DefaultComboBoxModel tmp = (DefaultComboBoxModel)b.getModel();
            tmp.removeAllElements();
            if (b.equals(this.jComboBoxCurSpeed) && BoardInfo.checkMinPartnerFirmwareVer(2691)) {
                for (i = 0; i < SerialPortService.SERIAL_BAUD_RATES_EXTENDED.length; ++i) {
                    tmp.addElement(SerialPortService.SERIAL_BAUD_RATES_EXTENDED[i]);
                }
            } else {
                for (i = 0; i < SerialPortService.SERIAL_BAUD_RATES.length - 1; ++i) {
                    tmp.addElement(SerialPortService.SERIAL_BAUD_RATES[i]);
                }
            }
            if ((p = BoardParams.getCurProfile()) == null) continue;
            b.setSelectedIndex(p.serialSpeed < b.getItemCount() ? p.serialSpeed : 0);
        }
        DefaultComboBoxModel m = (DefaultComboBoxModel)this.jComboBoxType.getModel();
        for (int i = 0; i < this.BT_MODULE_TYPES.length; ++i) {
            m.addElement(this.BT_MODULE_TYPES[i].getTitle());
        }
        this.jComboBoxType.setSelectedIndex(0);
        DefaultCaret caret = (DefaultCaret)this.jTextAreaDebugCmd.getCaret();
        caret.setUpdatePolicy(2);
        SerialCommandDispatcher.getInstance().addResponseListener(this);
        this.rtPauseState = RealtimeDataThread.pause(true);
        this.setReady(true);
    }

    void applyConnectionParams() throws Exception {
        int moduleTypeIdx = this.jComboBoxType.getSelectedIndex();
        if (moduleTypeIdx < 0 || moduleTypeIdx >= this.BT_MODULE_TYPES.length) {
            throw new Exception("Select the type of the bluetooth module!");
        }
        this.moduleType = this.BT_MODULE_TYPES[moduleTypeIdx];
        this.portIdx = this.jComboBoxPort.getSelectedIndex();
        this.curSpeed = this.jComboBoxCurSpeed.getSelectedIndex();
        this.curParity = this.jComboBoxCurParity.getSelectedIndex();
    }

    void setCurSpeed(int newSpeed) {
        this.curSpeed = newSpeed;
        this.jComboBoxCurSpeed.setSelectedIndex(this.curSpeed);
    }

    void setCurParity(int newParity) {
        this.curParity = newParity;
        this.jComboBoxCurParity.setSelectedIndex(this.curParity);
    }

    @Action(enabledProperty="ready")
    public void buttonCancel() {
        this.cancelDialog();
    }

    @Action(enabledProperty="ready")
    public void buttonWrite() {
        try {
            this.applyConnectionParams();
            final int newSpeed = this.jComboBoxNewSpeed.getSelectedIndex();
            final int newParity = this.jComboBoxNewParity.getSelectedIndex();
            final String name = this.jTextFieldName.getText();
            final String pin = this.jTextFieldPIN.getText();
            this.moduleType.validateName(name);
            this.moduleType.validatePin(pin);
            new Thread(){

                @Override
                public void run() {
                    DialogBluetooth.this.setReady(false);
                    try {
                        if (DialogBluetooth.this.sendATCommandsAndWaitResponse(DialogBluetooth.this.moduleType.cmdSetPin(pin), 3000L) && DialogBluetooth.this.sendATCommandsAndWaitResponse(DialogBluetooth.this.moduleType.cmdSetName(name), 3000L) && DialogBluetooth.this.sendATCommandsAndWaitResponse(DialogBluetooth.this.moduleType.cmdSetOtherParams(), 3000L) && DialogBluetooth.this.sendATCommandsAndWaitResponse(DialogBluetooth.this.moduleType.cmdSetSpeedParity(newSpeed, newParity), 3000L)) {
                            if (DialogBluetooth.this.moduleType.needReset()) {
                                DialogBluetooth.this.sendATCommandsAndWaitResponse(DialogBluetooth.this.moduleType.cmdReset(), 3000L);
                            }
                            DialogBluetooth.this.setCurSpeed(newSpeed);
                            DialogBluetooth.this.setCurParity(newParity);
                            DialogBluetooth.this.logMessage("Module was configured successfuly.");
                        } else {
                            DialogBluetooth.this.logErrorMessage("Failed to configure module.");
                        }
                    }
                    catch (Exception e) {
                        DialogBluetooth.this.logErrorMessage(e.toString());
                    }
                    DialogBluetooth.this.setReady(true);
                }
            }.start();
        }
        catch (Exception e) {
            this.logErrorMessage(e.toString());
            SimpleBGC_GUIApp.mainView.showErrorMessage(e.getMessage());
        }
    }

    @Override
    public void onCloseDialog() {
        SerialCommandDispatcher.getInstance().removeResponseListener(this);
        RealtimeDataThread.pause(this.rtPauseState);
    }

    @Action(enabledProperty="ready")
    public void buttonSend() {
        try {
            this.applyConnectionParams();
            this.setReady(false);
            this.sendATCmdAndWaitResponse(this.jTextFieldAT.getText(), 3000L);
            this.setReady(true);
        }
        catch (Exception e) {
            this.logErrorMessage(e.toString());
        }
    }

    @Action(enabledProperty="ready")
    public void buttonResetDefaults() {
        if (!SimpleBGC_GUIApp.mainView.showConfirmDialog(this.resourceMap.getString("confirm.bt_reset_to_defaults", new Object[0]))) {
            return;
        }
        try {
            this.applyConnectionParams();
            final String[] atCmds = this.moduleType.cmdFactoryDefaults();
            if (atCmds != null) {
                new Thread(){

                    @Override
                    public void run() {
                        DialogBluetooth.this.setReady(false);
                        try {
                            if (DialogBluetooth.this.sendATCommandsAndWaitResponse(atCmds, 3000L)) {
                                DialogBluetooth.this.logMessage("Module was reset to factory defaults.");
                            }
                        }
                        catch (Exception e) {
                            DialogBluetooth.this.logErrorMessage(e.toString());
                        }
                        DialogBluetooth.this.setReady(true);
                    }
                }.start();
            } else {
                this.logErrorMessage("Command is not supported by this module.");
            }
        }
        catch (Exception e) {
            this.logErrorMessage(e.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onCommandReceived(SerialCommand cmd) {
        DialogBluetooth dialogBluetooth = this;
        synchronized (dialogBluetooth) {
            this.responseCmd = cmd;
            this.notify();
            if (cmd.getBytesAvailable() > 0) {
                try {
                    this.logMessage("<" + new String(cmd.readBytes(cmd.getBytesAvailable()), "ISO-8859-1"));
                }
                catch (Exception e) {
                    this.logErrorMessage(e.toString());
                }
            }
        }
    }

    @Override
    public int getCommandId() {
        return 60;
    }

    @Override
    public void sendUartCmd(byte[] data, int needResponse, int delimiter, int waitTimeout) throws Exception {
        SerialCommand cmd = new SerialCommand(60);
        cmd.writeByte(this.portIdx);
        cmd.writeByte(this.curSpeed);
        cmd.writeByte(this.curParity);
        cmd.writeByte(needResponse);
        cmd.writeByte(delimiter);
        cmd.writeWord(waitTimeout);
        cmd.writeEmptyArr(12);
        cmd.write(data);
        SerialCommandProcessor.sendCommand(cmd);
    }

    synchronized boolean sendATCmdAndWaitResponse(String atCmd, long timeout) throws Exception {
        if (atCmd != null) {
            this.logMessage(">" + atCmd);
            this.responseCmd = null;
            this.moduleType.sendAtCmd(atCmd);
            this.wait(timeout);
            if (this.responseCmd == null) {
                this.logErrorMessage("No response!");
                return false;
            }
        }
        return true;
    }

    boolean sendATCommandsAndWaitResponse(String[] atCommands, long timeout) throws Exception {
        if (atCommands != null) {
            for (String atCmd : atCommands) {
                if (this.sendATCmdAndWaitResponse(atCmd, timeout)) continue;
                return false;
            }
        }
        return true;
    }

    public void logErrorMessage(String msg) {
        this.jTextAreaDebugCmd.append("ERR: " + msg + "\n");
    }

    public void logMessage(String msg) {
        this.jTextAreaDebugCmd.append(msg + "\n");
    }

    public void setReady(boolean busy) {
        boolean old = this.isReady;
        this.isReady = busy;
        this.firePropertyChange("ready", old, this.isReady);
    }

    public boolean isReady() {
        return this.isReady;
    }
}

