/*
 * Decompiled with CFR 0.152.
 */
package simplebgc_gui;

import java.awt.Component;
import java.awt.Frame;
import java.awt.LayoutManager;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JSeparator;
import javax.swing.JSpinner;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;
import org.jdesktop.application.Action;
import org.jdesktop.application.Application;
import org.jdesktop.application.ApplicationActionMap;
import org.jdesktop.application.ResourceMap;
import org.netbeans.lib.awtextra.AbsoluteConstraints;
import org.netbeans.lib.awtextra.AbsoluteLayout;
import sbgc.object.BoardInfo;
import sbgc.object.BodeTest;
import sbgc.object.ErrorInfo;
import sbgc.object.VibrationTest;
import sbgc.service.RealtimeDataThread;
import sbgc.service.SerialPortService;
import sbgc.service.upgrade.IProgressListener;
import sbgc.ui.ParamsUIFactory;
import sbgc.ui.SpravComboBoxModel;
import sbgc.utils.BGCJFileSaver;
import sbgc.utils.Settings;
import simplebgc_gui.MyDialog;
import simplebgc_gui.SimpleBGC_GUIApp;

public class DialogBodeTestRun
extends MyDialog
implements IProgressListener {
    private JButton jButtonCancel;
    private JButton jButtonFileBrowse;
    private JButton jButtonStart;
    private JComboBox jComboBoxBodeTestAxis;
    private JComboBox jComboBoxBodeTestStimulus;
    private JComboBox jComboBoxBodeTestSystem;
    private JComboBox jComboBoxSensor;
    private JLabel jLabelAxis;
    private JLabel jLabelFile;
    private JLabel jLabelSensor;
    private JLabel jLabelStimulus;
    private JLabel jLabelStimulusCutoff;
    private JLabel jLabelStimulusGain;
    private JLabel jLabelSystem;
    private JLabel jLabelVibrationDescr;
    private JPanel jPanelTabSystemResponse;
    private JPanel jPanelTabVibration;
    private JProgressBar jProgressBar;
    private JSeparator jSeparator1;
    private JSpinner jSpinnerBodeTestGain;
    private JSpinner jSpinnerCutoffFreq;
    private JSpinner jSpinnerStartFreq;
    private JTabbedPane jTabbedPane;
    private JTextField jTextFieldFilename;
    boolean oldRtDataState;
    String fileName = null;
    BodeTest bodeTest = null;
    VibrationTest vibrationTest = null;

    private void initComponents() {
        this.jTabbedPane = new JTabbedPane();
        this.jPanelTabSystemResponse = new JPanel();
        this.jLabelAxis = new JLabel();
        this.jComboBoxBodeTestAxis = new JComboBox();
        this.jLabelStimulus = new JLabel();
        this.jLabelStimulusGain = new JLabel();
        this.jSpinnerBodeTestGain = new JSpinner();
        this.jSpinnerStartFreq = new JSpinner();
        this.jLabelStimulusCutoff = new JLabel();
        this.jSpinnerCutoffFreq = new JSpinner();
        this.jComboBoxBodeTestStimulus = new JComboBox();
        this.jLabelSystem = new JLabel();
        this.jComboBoxBodeTestSystem = new JComboBox();
        this.jPanelTabVibration = new JPanel();
        this.jLabelSensor = new JLabel();
        this.jComboBoxSensor = new JComboBox();
        this.jLabelVibrationDescr = new JLabel();
        this.jLabelFile = new JLabel();
        this.jTextFieldFilename = new JTextField();
        this.jButtonFileBrowse = new JButton();
        this.jSeparator1 = new JSeparator();
        this.jProgressBar = new JProgressBar();
        this.jButtonStart = new JButton();
        this.jButtonCancel = new JButton();
        this.setDefaultCloseOperation(0);
        this.setModal(true);
        this.setName("Form");
        this.setResizable(false);
        this.getContentPane().setLayout((LayoutManager)new AbsoluteLayout());
        this.jTabbedPane.setName("");
        this.jPanelTabSystemResponse.setName("jPanelTabSystemResponse");
        this.jPanelTabSystemResponse.setLayout((LayoutManager)new AbsoluteLayout());
        this.jLabelAxis.setHorizontalAlignment(11);
        ResourceMap resourceMap = Application.getInstance(SimpleBGC_GUIApp.class).getContext().getResourceMap(DialogBodeTestRun.class);
        this.jLabelAxis.setText(resourceMap.getString("jLabelAxis.text", new Object[0]));
        this.jLabelAxis.setName("jLabelAxis");
        this.jPanelTabSystemResponse.add((Component)this.jLabelAxis, new AbsoluteConstraints(0, 10, 180, -1));
        this.jComboBoxBodeTestAxis.setModel(new DefaultComboBoxModel<String>(new String[]{"ROLL", "PITCH", "YAW"}));
        this.jComboBoxBodeTestAxis.setName("jComboBoxBodeTestAxis");
        this.jPanelTabSystemResponse.add((Component)this.jComboBoxBodeTestAxis, new AbsoluteConstraints(190, 10, 90, -1));
        this.jLabelStimulus.setHorizontalAlignment(11);
        this.jLabelStimulus.setText(resourceMap.getString("jLabelStimulus.text", new Object[0]));
        this.jLabelStimulus.setName("jLabelStimulus");
        this.jPanelTabSystemResponse.add((Component)this.jLabelStimulus, new AbsoluteConstraints(0, 40, 180, -1));
        this.jLabelStimulusGain.setHorizontalAlignment(11);
        this.jLabelStimulusGain.setText(resourceMap.getString("jLabelStimulusGain.text", new Object[0]));
        this.jLabelStimulusGain.setName("jLabelStimulusGain");
        this.jPanelTabSystemResponse.add((Component)this.jLabelStimulusGain, new AbsoluteConstraints(0, 70, 180, -1));
        this.jSpinnerBodeTestGain.setModel(new SpinnerNumberModel(0, 0, 65535, 10));
        this.jSpinnerBodeTestGain.setToolTipText(resourceMap.getString("jSpinnerBodeTestGain.toolTipText", new Object[0]));
        this.jSpinnerBodeTestGain.setName("jSpinnerBodeTestGain");
        this.jSpinnerBodeTestGain.setValue(100);
        this.jPanelTabSystemResponse.add((Component)this.jSpinnerBodeTestGain, new AbsoluteConstraints(190, 70, 70, -1));
        this.jSpinnerStartFreq.setModel(new SpinnerNumberModel(600, 1, 600, 1));
        this.jSpinnerStartFreq.setToolTipText(resourceMap.getString("jSpinnerStartFreq.toolTipText", new Object[0]));
        this.jSpinnerStartFreq.setName("jSpinnerStartFreq");
        this.jPanelTabSystemResponse.add((Component)this.jSpinnerStartFreq, new AbsoluteConstraints(190, 100, 70, -1));
        this.jLabelStimulusCutoff.setHorizontalAlignment(11);
        this.jLabelStimulusCutoff.setText(resourceMap.getString("jLabelStimulusCutoff.text", new Object[0]));
        this.jLabelStimulusCutoff.setName("jLabelStimulusCutoff");
        this.jPanelTabSystemResponse.add((Component)this.jLabelStimulusCutoff, new AbsoluteConstraints(10, 100, 180, -1));
        this.jSpinnerCutoffFreq.setModel(new SpinnerNumberModel(600, 1, 600, 1));
        this.jSpinnerCutoffFreq.setToolTipText(resourceMap.getString("jSpinnerStartFreq.toolTipText", new Object[0]));
        this.jSpinnerCutoffFreq.setName("jSpinnerCutoffFreq");
        this.jPanelTabSystemResponse.add((Component)this.jSpinnerCutoffFreq, new AbsoluteConstraints(270, 100, 70, -1));
        this.jComboBoxBodeTestStimulus.setModel(new DefaultComboBoxModel<String>(new String[]{"white noise", "sine sweep", "sine sweep (exponential gain)"}));
        this.jComboBoxBodeTestStimulus.setName("jComboBoxBodeTestStimulus");
        this.jPanelTabSystemResponse.add((Component)this.jComboBoxBodeTestStimulus, new AbsoluteConstraints(190, 40, -1, -1));
        this.jLabelSystem.setHorizontalAlignment(11);
        this.jLabelSystem.setText(resourceMap.getString("jLabelSystem.text", new Object[0]));
        this.jLabelSystem.setName("jLabelSystem");
        this.jPanelTabSystemResponse.add((Component)this.jLabelSystem, new AbsoluteConstraints(0, 130, 180, -1));
        this.jComboBoxBodeTestSystem.setName("jComboBoxBodeTestSystem");
        this.jPanelTabSystemResponse.add((Component)this.jComboBoxBodeTestSystem, new AbsoluteConstraints(190, 130, -1, -1));
        this.jTabbedPane.addTab(resourceMap.getString("jPanelTabSystemResponse.TabConstraints.tabTitle", new Object[0]), this.jPanelTabSystemResponse);
        this.jPanelTabVibration.setName("jPanelTabVibration");
        this.jPanelTabVibration.setLayout((LayoutManager)new AbsoluteLayout());
        this.jLabelSensor.setHorizontalAlignment(4);
        this.jLabelSensor.setText(resourceMap.getString("jLabelSensor.text", new Object[0]));
        this.jLabelSensor.setName("jLabelSensor");
        this.jPanelTabVibration.add((Component)this.jLabelSensor, new AbsoluteConstraints(14, 10, 160, -1));
        this.jComboBoxSensor.setName("jComboBoxSensor");
        this.jPanelTabVibration.add((Component)this.jComboBoxSensor, new AbsoluteConstraints(190, 10, 220, -1));
        this.jLabelVibrationDescr.setText(resourceMap.getString("jLabelVibrationDescr.text", new Object[0]));
        this.jLabelVibrationDescr.setVerticalAlignment(1);
        this.jLabelVibrationDescr.setName("jLabelVibrationDescr");
        this.jPanelTabVibration.add((Component)this.jLabelVibrationDescr, new AbsoluteConstraints(20, 50, 570, 110));
        this.jTabbedPane.addTab(resourceMap.getString("jPanelTabVibration.TabConstraints.tabTitle", new Object[0]), this.jPanelTabVibration);
        this.getContentPane().add((Component)this.jTabbedPane, new AbsoluteConstraints(0, 0, 610, 190));
        this.jLabelFile.setHorizontalAlignment(11);
        this.jLabelFile.setText(resourceMap.getString("jLabelFile.text", new Object[0]));
        this.jLabelFile.setName("jLabelFile");
        this.getContentPane().add((Component)this.jLabelFile, new AbsoluteConstraints(10, 200, 120, -1));
        this.jTextFieldFilename.setText(resourceMap.getString("jTextFieldFilename.text", new Object[0]));
        this.jTextFieldFilename.setName("jTextFieldFilename");
        this.getContentPane().add((Component)this.jTextFieldFilename, new AbsoluteConstraints(140, 200, 350, -1));
        ApplicationActionMap actionMap = Application.getInstance(SimpleBGC_GUIApp.class).getContext().getActionMap(DialogBodeTestRun.class, this);
        this.jButtonFileBrowse.setAction(actionMap.get("buttonFileBrowse"));
        this.jButtonFileBrowse.setText(resourceMap.getString("jButtonFileBrowse.text", new Object[0]));
        this.jButtonFileBrowse.setName("jButtonFileBrowse");
        this.getContentPane().add((Component)this.jButtonFileBrowse, new AbsoluteConstraints(500, 200, 100, -1));
        this.jSeparator1.setName("jSeparator1");
        this.getContentPane().add((Component)this.jSeparator1, new AbsoluteConstraints(0, 240, 610, 10));
        this.jProgressBar.setName("jProgressBar");
        this.jProgressBar.setStringPainted(true);
        this.getContentPane().add((Component)this.jProgressBar, new AbsoluteConstraints(10, 250, 310, 20));
        this.jButtonStart.setAction(actionMap.get("buttonStart"));
        this.jButtonStart.setText(resourceMap.getString("jButtonStart.text", new Object[0]));
        this.jButtonStart.setName("jButtonStart");
        this.getContentPane().add((Component)this.jButtonStart, new AbsoluteConstraints(480, 250, 120, 30));
        this.jButtonCancel.setAction(actionMap.get("buttonCancel"));
        this.jButtonCancel.setText(resourceMap.getString("jButtonCancel.text", new Object[0]));
        this.jButtonCancel.setName("jButtonCancel");
        this.getContentPane().add((Component)this.jButtonCancel, new AbsoluteConstraints(350, 250, 120, 30));
        this.pack();
    }

    public DialogBodeTestRun(Frame parent) {
        super(DialogBodeTestRun.class, parent, SimpleBGC_GUIApp.getResourceMap().getString("title.dialog_analize_run_test", new Object[0]));
        this.initComponents();
        this.oldRtDataState = RealtimeDataThread.pause(true);
        this.jProgressBar.setVisible(false);
        if (!BoardInfo.canBodeTest()) {
            this.fatalError(this.resourceMap.getString("error.firmware_not_supported", new Object[0]));
        }
        BoardInfo boardInfo = BoardInfo.getBoardInfo();
        if (boardInfo.connectionFlags != 1) {
            int min_baud;
            int n = min_baud = BoardInfo.checkMinPartnerFirmwareVer(2626) ? 115200 : 256000;
            if (SerialPortService.getBaudRate() < min_baud) {
                this.fatalError(this.resourceMap.getString("error.baud_rate_low", min_baud));
            }
        }
        if (!BoardInfo.hasVibrationTest()) {
            this.jTabbedPane.remove(this.jPanelTabVibration);
        }
        this.jComboBoxBodeTestSystem.setModel(new SpravComboBoxModel(BodeTest.getSystemTypes()));
        try {
            this.jComboBoxBodeTestAxis.setSelectedIndex(Settings.getInt("bode_test.axis", 0));
            if (BoardInfo.hasExtPIDRange() || BoardInfo.checkMinBaseFirmwareVer(2704)) {
                this.jComboBoxBodeTestStimulus.setSelectedIndex(0);
                this.jComboBoxBodeTestStimulus.setEnabled(false);
            } else {
                this.jComboBoxBodeTestStimulus.setSelectedIndex(Settings.getInt("bode_test.stimulus", 0));
            }
            this.jSpinnerBodeTestGain.setValue(Settings.getInt("bode_test.stimulus_gain", 3000));
            this.jSpinnerStartFreq.setValue(Settings.getInt("bode_test.start_freq", 3));
            this.jSpinnerCutoffFreq.setValue(Settings.getInt("bode_test.cutoff_freq", 250));
            ((SpravComboBoxModel)this.jComboBoxBodeTestSystem.getModel()).setCurrent(Settings.getInt("bode_test.system", 70));
            this.jTextFieldFilename.setText(Settings.get("bode_test.last_used_file", ""));
            if (BoardInfo.hasVibrationTest()) {
                this.jComboBoxSensor.setModel(new SpravComboBoxModel(ParamsUIFactory.getVibrationTestSensors()));
                ((SpravComboBoxModel)this.jComboBoxSensor.getModel()).setCurrent(Settings.getInt("vibration_test.sensor", 0));
                this.jTabbedPane.getModel().setSelectedIndex(Settings.getInt("bode_test.tab", 0));
            }
        }
        catch (Exception e) {
            this.logger.stackTrace(e);
        }
        this.updateActiveState(BodeTest.instance.isActive() || VibrationTest.instance.isActive());
    }

    private void updateActiveState(boolean testState) {
        if (testState) {
            this.jButtonStart.setText(this.resourceMap.getString("jButtonStart.text.stop", new Object[0]));
            this.jProgressBar.setVisible(true);
        }
    }

    @Action
    public void buttonCancel() {
        this.cancelDialog();
    }

    @Action
    public void buttonStart() {
        if (this.bodeTest != null || this.vibrationTest != null) {
            this.closeDialog(1);
        } else {
            try {
                this.fileName = this.jTextFieldFilename.getText();
                if (this.fileName.equals("")) {
                    throw new Exception(this.resourceMap.getString("error.filename_is_not_provided", new Object[0]));
                }
                Settings.set("bode_test.last_used_file", this.fileName);
                Settings.set("bode_test.tab", this.jTabbedPane.getModel().getSelectedIndex());
                if (this.jTabbedPane.getModel().getSelectedIndex() == 0) {
                    this.bodeTest = BodeTest.instance;
                    int axis = this.jComboBoxBodeTestAxis.getSelectedIndex();
                    int stimulus = this.jComboBoxBodeTestStimulus.getSelectedIndex() + 1;
                    int gain = ((Number)this.jSpinnerBodeTestGain.getValue()).intValue();
                    int startFreq = ((Number)this.jSpinnerStartFreq.getValue()).intValue();
                    int endFreq = ((Number)this.jSpinnerCutoffFreq.getValue()).intValue();
                    int system = ((SpravComboBoxModel)this.jComboBoxBodeTestSystem.getModel()).getCurrentId();
                    if (endFreq < startFreq || endFreq <= 0) {
                        throw new Exception("The specified frequency range is invalid!");
                    }
                    Settings.set("bode_test.axis", Integer.toString(axis));
                    Settings.set("bode_test.stimulus", Integer.toString(stimulus - 1));
                    Settings.set("bode_test.stimulus_gain", ((Number)this.jSpinnerBodeTestGain.getValue()).toString());
                    Settings.set("bode_test.start_freq", ((Number)this.jSpinnerStartFreq.getValue()).toString());
                    Settings.set("bode_test.cutoff_freq", ((Number)this.jSpinnerCutoffFreq.getValue()).toString());
                    Settings.set("bode_test.system", Integer.toString(system));
                    Settings.save();
                    this.bodeTest.start(axis, stimulus, gain, startFreq, endFreq, system, this.fileName, this);
                } else {
                    this.vibrationTest = VibrationTest.instance;
                    int sensor = ((SpravComboBoxModel)this.jComboBoxSensor.getModel()).getCurrentId();
                    Settings.set("vibration_test.sensor", sensor);
                    Settings.save();
                    this.vibrationTest.start(sensor, this.fileName, this);
                }
                this.updateActiveState(true);
            }
            catch (Exception e) {
                this.showError("Failed to start test:\n" + e.getMessage());
                this.onFinishTest(-2);
            }
        }
    }

    @Override
    public void onProgressStart(String action, boolean modal) {
        ErrorInfo.updateStatus(action);
    }

    @Override
    public boolean onProgressChange(final int percent) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                DialogBodeTestRun.this.jProgressBar.setValue(percent);
            }
        });
        return !this.isCancelled();
    }

    @Override
    public void onProgressFinish(final boolean isSuccess) {
        if (this.result != -1) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (isSuccess) {
                        if (DialogBodeTestRun.this.fileName != null) {
                            SimpleBGC_GUIApp.mainView.panelAnalyze.bodePlotAddFile(DialogBodeTestRun.this.fileName);
                            DialogBodeTestRun.this.result = 1;
                        }
                    } else {
                        if (ErrorInfo.getCurErrors().length() > 0) {
                            DialogBodeTestRun.this.showError(ErrorInfo.getCurErrors());
                        }
                        DialogBodeTestRun.this.result = -2;
                    }
                    DialogBodeTestRun.this.onFinishTest(DialogBodeTestRun.this.result);
                }
            });
        }
    }

    private void onFinishTest(int result) {
        this.bodeTest = null;
        this.vibrationTest = null;
        this.closeDialog(result);
    }

    @Override
    public void onCloseDialog() {
        if (BodeTest.instance.isActive()) {
            BodeTest.instance.sendStopCmd();
        }
        if (VibrationTest.instance.isActive()) {
            VibrationTest.instance.sendStopCmd();
        }
        this.updateActiveState(false);
        RealtimeDataThread.pause(this.oldRtDataState);
    }

    public void showError(String error) {
        JOptionPane.showMessageDialog(this, error, this.resourceMap.getString("messageDialog.error.title", new Object[0]), 0);
    }

    public void fatalError(String error) {
        this.showError(error);
        this.closeDialog(-2);
    }

    @Action
    public void buttonFileBrowse() {
        BGCJFileSaver fileSaver = new BGCJFileSaver(this, new String[]{"csv"}, SimpleBGC_GUIApp.getResourceMap().getString("file_type.csv", new Object[0]), "bode_test.last_used_dir");
        String filePath = fileSaver.getFilePath(this.jTextFieldFilename.getText(), false);
        if (filePath != null) {
            this.jTextFieldFilename.setText(filePath);
        }
    }
}

