/*
 * Decompiled with CFR 0.152.
 */
package simplebgc_gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.io.File;
import java.util.ArrayList;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import org.jdesktop.application.Action;
import org.jdesktop.application.Application;
import org.jdesktop.application.ApplicationActionMap;
import org.jdesktop.application.ResourceMap;
import org.netbeans.lib.awtextra.AbsoluteConstraints;
import org.netbeans.lib.awtextra.AbsoluteLayout;
import sbgc.encoder.EncIntCalibAction;
import sbgc.encoder.EncIntCalibDataType;
import sbgc.encoder.ICMU;
import sbgc.object.ErrorInfo;
import sbgc.object.Sprav;
import sbgc.service.CommandResponseListener;
import sbgc.service.RealtimeDataThread;
import sbgc.service.SerialCommand;
import sbgc.service.SerialCommandDispatcher;
import sbgc.service.SerialCommandProcessor;
import sbgc.service.upgrade.IProgressListener;
import sbgc.ui.SpravComboBoxModel;
import sbgc.ui.dataview.DataViewSeries;
import sbgc.ui.dataview.LUTViewPanel;
import sbgc.utils.FileUtil;
import sbgc.utils.ILogListener;
import sbgc.utils.Settings;
import simplebgc_gui.MyDialog;
import simplebgc_gui.SimpleBGC_GUIApp;
import simplebgc_gui.SimpleBGC_GUIView;
import simplebgc_gui.TabWindow;

public class DialogEncoderICMUCalib
extends MyDialog
implements Runnable,
IProgressListener,
ILogListener {
    public static final int[] ICMU_POLE_PAIRS = new int[]{16, 32, 64};
    public static final int ICMU_POLE_PAIRS_DEFAULT = 32;
    public static final int RAW_DATA_BUF_SIZE = 10;
    LUTViewPanel dataViewPanel;
    DataViewSeries masterDataSeries;
    DataViewSeries noniusDataSeries;
    final SimpleBGC_GUIView mainView;
    final int encoder_port;
    final int encoder_type;
    int progress = 0;
    ActionMap actionMap;
    boolean isActive;
    ICMU icmu;
    boolean isWritten = true;
    boolean logStarted = true;
    CalibState state = CalibState.STATE_IDLE;
    ArrayList<Object[]> rawData;
    private JButton jButtonCalibrate;
    private JButton jButtonFinish;
    private JButton jButtonNewWindow1;
    private JButton jButtonRead;
    private JButton jButtonReset;
    private JButton jButtonWrite;
    private JComboBox jComboBoxNumPoles;
    private JLabel jLabelParamNumPoles;
    private JLabel jLabelStatus;
    private JPanel jPanelPlot;
    private JPanel jPanelPlotContainer;
    private JPanel jPanelPlots;
    private JProgressBar jProgressBar;
    private JScrollPane jScrollPane1;
    private JSeparator jSeparator3;
    private JTextArea jTextAreaLog;

    public DialogEncoderICMUCalib(SimpleBGC_GUIView mainView, boolean modal, int enc_port, int enc_type) throws Exception {
        super(DialogEncoderICMUCalib.class, mainView.getFrame(), SimpleBGC_GUIApp.getResourceMap().getString("title.dialog_enc_int_calibration", new Object[0]), modal);
        this.mainView = mainView;
        this.encoder_port = enc_port;
        this.encoder_type = enc_type;
        this.initComponents();
        this.actionMap = Application.getInstance(SimpleBGC_GUIApp.class).getContext().getActionMap(DialogEncoderICMUCalib.class, this);
        this.jComboBoxNumPoles.setModel(new SpravComboBoxModel(Sprav.forIntArray(ICMU_POLE_PAIRS), 32));
        RealtimeDataThread.suspend(true);
        for (int i = 0; i < 3; ++i) {
            this.dataViewPanel = new LUTViewPanel();
            this.jPanelPlot.add(this.dataViewPanel);
            this.masterDataSeries = new DataViewSeries(LUTViewPanel.PRIMARY_COLORS[0], 3.0f);
            this.masterDataSeries.set_xy_range(0, 0.0f, 1000.0f, true, DataViewSeries.AutoScaleType.ALL, 0.0f);
            this.masterDataSeries.set_xy_range(1, 0.0f, 360.0f, true, DataViewSeries.AutoScaleType.ALL, 0.1f);
            this.masterDataSeries.set_wrap(1, 0.0f, 360.0f, true);
            this.noniusDataSeries = new DataViewSeries(LUTViewPanel.SECONDARY_COLORS[0], 1.5f);
            this.noniusDataSeries.set_xy_range(0, 0.0f, 1000.0f, true, DataViewSeries.AutoScaleType.ALL, 0.0f);
            this.noniusDataSeries.set_xy_range(1, 0.0f, 360.0f, true, DataViewSeries.AutoScaleType.ALL, 0.1f);
            this.noniusDataSeries.set_wrap(1, 0.0f, 360.0f, true);
            this.dataViewPanel.addSeries(this.noniusDataSeries);
            this.dataViewPanel.addSeries(this.masterDataSeries);
            this.dataViewPanel.setGrid(0, 90.0f, "\u00b0", false);
            this.dataViewPanel.setGrid(1, 1.0f, "\u00b0", true);
        }
        this.jTextAreaLog.append("\n\n");
        this.icmu = new ICMU();
        this.icmu.setLogListerner(this);
        try {
            this.icmu.init();
        }
        catch (Throwable e) {
            this.icmu = null;
            throw new Exception("IC-MU library initialization failed: " + e.getMessage());
        }
        this.logStarted = false;
    }

    @Override
    protected void onShowDialog() {
        this.isActive = true;
        this.setActiveState(false);
        new Thread(this).start();
    }

    private void initComponents() {
        this.jButtonRead = new JButton();
        this.jButtonNewWindow1 = new JButton();
        this.jPanelPlotContainer = new JPanel();
        this.jPanelPlots = new JPanel();
        this.jPanelPlot = new JPanel();
        this.jButtonCalibrate = new JButton();
        this.jButtonFinish = new JButton();
        this.jProgressBar = new JProgressBar();
        this.jLabelStatus = new JLabel();
        this.jSeparator3 = new JSeparator();
        this.jButtonWrite = new JButton();
        this.jScrollPane1 = new JScrollPane();
        this.jTextAreaLog = new JTextArea();
        this.jButtonReset = new JButton();
        this.jLabelParamNumPoles = new JLabel();
        this.jComboBoxNumPoles = new JComboBox();
        this.setDefaultCloseOperation(2);
        this.setName("Form");
        this.getContentPane().setLayout((LayoutManager)new AbsoluteLayout());
        ApplicationActionMap actionMap = Application.getInstance(SimpleBGC_GUIApp.class).getContext().getActionMap(DialogEncoderICMUCalib.class, this);
        this.jButtonRead.setAction(actionMap.get("buttonRead"));
        ResourceMap resourceMap = Application.getInstance(SimpleBGC_GUIApp.class).getContext().getResourceMap(DialogEncoderICMUCalib.class);
        this.jButtonRead.setText(resourceMap.getString("jButtonRead.text", new Object[0]));
        this.jButtonRead.setName("jButtonRead");
        this.getContentPane().add((Component)this.jButtonRead, new AbsoluteConstraints(70, 350, 170, 30));
        this.jButtonNewWindow1.setAction(actionMap.get("buttonNewWin"));
        this.jButtonNewWindow1.setToolTipText(resourceMap.getString("jButtonNewWindow1.toolTipText", new Object[0]));
        this.jButtonNewWindow1.setHorizontalTextPosition(0);
        this.jButtonNewWindow1.setIconTextGap(0);
        this.jButtonNewWindow1.setMargin(new Insets(2, 2, 2, 2));
        this.jButtonNewWindow1.setName("jButtonNewWindow1");
        this.getContentPane().add((Component)this.jButtonNewWindow1, new AbsoluteConstraints(10, 350, 30, 30));
        this.jPanelPlotContainer.setName("jPanelPlotContainer");
        this.jPanelPlotContainer.setLayout(new BoxLayout(this.jPanelPlotContainer, 2));
        this.jPanelPlots.setName("jPanelPlots");
        this.jPanelPlots.setLayout(new GridBagLayout());
        this.jPanelPlot.setBorder(BorderFactory.createEtchedBorder(0));
        this.jPanelPlot.setName("jPanelPlot");
        this.jPanelPlot.setLayout(new BorderLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.jPanelPlots.add((Component)this.jPanelPlot, gridBagConstraints);
        this.jPanelPlotContainer.add(this.jPanelPlots);
        this.getContentPane().add((Component)this.jPanelPlotContainer, new AbsoluteConstraints(10, 10, 610, 150));
        this.jButtonCalibrate.setAction(actionMap.get("buttonCalibrate"));
        this.jButtonCalibrate.setFont(this.jButtonCalibrate.getFont().deriveFont(this.jButtonCalibrate.getFont().getStyle() | 1));
        this.jButtonCalibrate.setText(resourceMap.getString("jButtonCalibrate.text", new Object[0]));
        this.jButtonCalibrate.setToolTipText(resourceMap.getString("jButtonCalibrate.toolTipText", new Object[0]));
        this.jButtonCalibrate.setName("jButtonCalibrate");
        this.getContentPane().add((Component)this.jButtonCalibrate, new AbsoluteConstraints(430, 390, 190, 30));
        this.jButtonFinish.setAction(actionMap.get("buttonCancel"));
        this.jButtonFinish.setText(resourceMap.getString("jButtonFinish.text", new Object[0]));
        this.jButtonFinish.setName("jButtonFinish");
        this.getContentPane().add((Component)this.jButtonFinish, new AbsoluteConstraints(490, 440, 120, 30));
        this.jProgressBar.setName("jProgressBar");
        this.jProgressBar.setStringPainted(true);
        this.getContentPane().add((Component)this.jProgressBar, new AbsoluteConstraints(30, 440, 420, 15));
        this.jLabelStatus.setVerticalAlignment(1);
        this.jLabelStatus.setName("jLabelStatus");
        this.jLabelStatus.setVerticalTextPosition(1);
        this.getContentPane().add((Component)this.jLabelStatus, new AbsoluteConstraints(20, 460, 450, 20));
        this.jSeparator3.setName("jSeparator3");
        this.getContentPane().add((Component)this.jSeparator3, new AbsoluteConstraints(10, 430, 620, 10));
        this.jButtonWrite.setAction(actionMap.get("buttonWrite"));
        this.jButtonWrite.setText(resourceMap.getString("jButtonWrite.text", new Object[0]));
        this.jButtonWrite.setName("jButtonWrite");
        this.getContentPane().add((Component)this.jButtonWrite, new AbsoluteConstraints(430, 350, 190, 30));
        this.jScrollPane1.setHorizontalScrollBarPolicy(31);
        this.jScrollPane1.setName("jScrollPane1");
        this.jTextAreaLog.setColumns(20);
        this.jTextAreaLog.setEditable(false);
        this.jTextAreaLog.setLineWrap(true);
        this.jTextAreaLog.setRows(5);
        this.jTextAreaLog.setText(resourceMap.getString("jTextAreaLog.text", new Object[0]));
        this.jTextAreaLog.setWrapStyleWord(true);
        this.jTextAreaLog.setCaretPosition(0);
        this.jTextAreaLog.setName("jTextAreaLog");
        this.jScrollPane1.setViewportView(this.jTextAreaLog);
        this.getContentPane().add((Component)this.jScrollPane1, new AbsoluteConstraints(10, 160, 610, 180));
        this.jButtonReset.setAction(actionMap.get("buttonReset"));
        this.jButtonReset.setText(resourceMap.getString("jButtonReset.text", new Object[0]));
        this.jButtonReset.setName("jButtonReset");
        this.getContentPane().add((Component)this.jButtonReset, new AbsoluteConstraints(250, 350, 170, 30));
        this.jLabelParamNumPoles.setText(resourceMap.getString("jLabelParamNumPoles.text", new Object[0]));
        this.jLabelParamNumPoles.setName("jLabelParamNumPoles");
        this.getContentPane().add((Component)this.jLabelParamNumPoles, new AbsoluteConstraints(20, 400, -1, -1));
        this.jComboBoxNumPoles.setName("jComboBoxNumPoles");
        this.getContentPane().add((Component)this.jComboBoxNumPoles, new AbsoluteConstraints(170, 400, 70, -1));
        this.pack();
    }

    @Action
    public void buttonCancel() {
        this.cancelDialog();
    }

    @Override
    protected boolean onBeforeCloseDialog() {
        return this.checkIsWritten();
    }

    @Override
    public void onCloseDialog() {
        RealtimeDataThread.suspend(false);
        Settings.save();
    }

    private boolean checkIsWritten() {
        return this.isWritten || this.mainView.showConfirmDialog("Calibration data is not written to the board. \nDo you want to discard it and continue?");
    }

    public void updateStatus(final String text) {
        this.logger.info("status: " + text);
        SimpleBGC_GUIView.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                DialogEncoderICMUCalib.this.jLabelStatus.setText(text);
                DialogEncoderICMUCalib.this.log(text);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        CommandResponseListener listener1 = new CommandResponseListener(122);
        listener1.supressLogs = true;
        SerialCommandDispatcher.getInstance().addResponseListener(listener1);
        try {
            while (!this.isClosed()) {
                SerialCommand resp = listener1.waitShort(500L);
                if (resp == null) continue;
                final SerialCommand respf = resp;
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        block5: {
                            try {
                                if (respf.id == 67) {
                                    DialogEncoderICMUCalib.this.onConfirmCmd(respf);
                                    break block5;
                                }
                                if (respf.id == 122) {
                                    DialogEncoderICMUCalib.this.onCalibDataCmd(respf);
                                    break block5;
                                }
                                if (respf.id == 255) {
                                    DialogEncoderICMUCalib.this.error("Operation failed with error " + ErrorInfo.formatCmdErrorInfo(respf));
                                    break block5;
                                }
                                throw new Exception("Unsupported command: " + respf.id);
                            }
                            catch (Exception e) {
                                DialogEncoderICMUCalib.this.error(e.getMessage());
                                DialogEncoderICMUCalib.this.logger.error("Error processing response: " + e.toString());
                            }
                        }
                    }
                });
            }
        }
        catch (InterruptedException e) {
            this.logger.warn("Calibration thread interrupted");
        }
        catch (Exception e) {
            this.logger.warn("Exception in the calibration thread: " + e.toString());
        }
        finally {
            SerialCommandDispatcher.getInstance().removeResponseListener(listener1);
        }
    }

    void onConfirmCmd(SerialCommand cmd) throws Exception {
        cmd.skipBytes(1);
        EncIntCalibAction action = EncIntCalibAction.forInt(cmd.readByte());
        int errorCode = 0;
        if (cmd.getBytesAvailable() > 0) {
            if (cmd.readByte() != this.encoder_port) {
                return;
            }
            if (cmd.getBytesAvailable() > 0) {
                errorCode = cmd.readByte();
            }
        }
        this.logger.trace("Action confirmed: " + action.name() + ", error_code=" + errorCode);
        if (errorCode != 0) {
            this.error(this.resourceMap.getString("error.response", errorCode));
            return;
        }
        switch (action) {
            case ACTION_START: {
                this.updateStatus(this.resourceMap.getString("status.calibration_started", new Object[0]));
                this.setActiveState(true);
                break;
            }
            case ACTION_STOP: {
                this.updateStatus(this.resourceMap.getString("status.calibration_stopped", new Object[0]));
                this.setActiveState(false);
                break;
            }
            case ACTION_RESET_DEFAULTS: {
                this.updateStatus(this.resourceMap.getString("status.reset_okay", new Object[0]));
                break;
            }
            case ACTION_ERROR: {
                int code = cmd.getBytesAvailable() > 0 ? cmd.readByte() : 0;
                this.showErrorMessage(this.resourceMap.getString("error.calibration", code));
                this.setActiveState(false);
                break;
            }
            case ACTION_FINISHED: {
                this.updateStatus(this.resourceMap.getString("status.calibration_finished", new Object[0]));
                this.onSuccessFinish();
                this.setActiveState(false);
                break;
            }
            case ACTION_WRITE: {
                this.updateStatus(this.resourceMap.getString("status.calibration_write_success", new Object[0]));
                this.setActiveState(false);
                this.isWritten = true;
                break;
            }
            default: {
                this.updateStatus("Unknow action confirmed: " + action.name());
            }
        }
    }

    void onCalibDataCmd(SerialCommand cmd) {
        try {
            int enc_port_cmd = cmd.readByte();
            if (enc_port_cmd != this.encoder_port) {
                this.error("enc_port (" + enc_port_cmd + ") doesn't match current (" + this.encoder_port + "), skipping..");
                return;
            }
            EncIntCalibDataType dataType = EncIntCalibDataType.forInt(cmd.readByte());
            switch (dataType) {
                case RAW_DATA: {
                    if (this.rawData != null) {
                        int[] master = cmd.readWordArrUnsigned(10);
                        int[] nonius = cmd.readWordArrUnsigned(10);
                        this.progress = cmd.readByte();
                        for (int i = 0; i < 10; ++i) {
                            this.rawData.add(new Object[]{new Integer(master[i]), new Integer(nonius[i])});
                            this.dataViewAddSample((short)master[i], (short)nonius[i]);
                        }
                        this.dataViewPanel.onUpdate();
                        this.onProgressChange(this.progress);
                        break;
                    }
                    this.warn("Raw data received outside of calibration procedure, skippping..");
                    break;
                }
                case CALIBRATION_DATA: {
                    byte[] data = cmd.readBytes(cmd.getBytesAvailable());
                    this.icmu.setCalibData(data);
                    this.updateStatus(this.resourceMap.getString("status.calibration_read_success", new Object[0]));
                    if (this.state != CalibState.STATE_READ) break;
                    int polePairs = ((SpravComboBoxModel)this.jComboBoxNumPoles.getModel()).getCurrentId();
                    this.state = CalibState.STATE_CALIBRATE;
                    this.sendCalibCommand(EncIntCalibAction.ACTION_START, new byte[]{(byte)(polePairs & 0xFF)});
                }
            }
        }
        catch (Exception e) {
            this.error(e.toString());
        }
    }

    private void dataViewAddSample(short master, short nonius) {
        float master_angle = ICMU.rawToDegrees(master);
        float nonius_angle = ICMU.rawToDegrees(nonius);
        this.masterDataSeries.addSample(this.masterDataSeries.size(), this.masterDataSeries.unwrap(master_angle, 1, 0.0f, 360.0f));
        this.noniusDataSeries.addSample(this.noniusDataSeries.size(), this.noniusDataSeries.unwrap(nonius_angle, 1, 0.0f, 360.0f));
    }

    private void readRawDataCSV() throws Exception {
        this.rawData = FileUtil.readCSV(new File("./tmp/raw_sample_data_MU_Y_MU2L_82-32N_0.csv"), 1, new Class[]{Integer.class, Integer.class});
        this.log(String.format("Loaded data from CSV: " + this.rawData.size() + " rows, first row is [%d, %d]", this.rawData.get(0)[0], this.rawData.get(0)[1]));
        for (int i = 0; i < this.rawData.size(); ++i) {
            this.dataViewAddSample(((Integer)this.rawData.get(i)[0]).shortValue(), ((Integer)this.rawData.get(i)[1]).shortValue());
        }
        this.dataViewPanel.onUpdate();
    }

    private void onSuccessFinish() throws Exception {
        try {
            if (this.rawData != null) {
                if (this.rawData.isEmpty()) {
                    throw new Exception("No data was collected, something went wrong.");
                }
                short[] masterData = new short[this.rawData.size()];
                short[] noniusData = new short[this.rawData.size()];
                for (int i = 0; i < this.rawData.size(); ++i) {
                    masterData[i] = ((Integer)this.rawData.get(i)[0]).shortValue();
                    noniusData[i] = ((Integer)this.rawData.get(i)[1]).shortValue();
                }
                this.icmu.calculate(masterData, noniusData);
                this.isWritten = false;
            }
        }
        catch (Exception e) {
            this.error(e.toString());
        }
    }

    void setActiveState(boolean isActive) {
        if (this.isActive != isActive) {
            if (isActive) {
                this.jButtonCalibrate.setAction(this.actionMap.get("buttonCalibrateStop"));
                this.progress = 1;
            } else {
                this.jButtonCalibrate.setAction(this.actionMap.get("buttonCalibrate"));
                this.progress = 0;
                this.rawData = null;
                this.state = CalibState.STATE_IDLE;
            }
            this.jProgressBar.setVisible(this.progress > 0);
            this.jButtonRead.setEnabled(!isActive);
            this.jButtonReset.setEnabled(!isActive);
            this.jButtonWrite.setEnabled(!isActive);
            this.isActive = isActive;
        }
    }

    @Action
    public void buttonCalibrate() {
        this.updateStatus(this.resourceMap.getString("status.starting_calibration", new Object[0]));
        this.masterDataSeries.clear();
        this.noniusDataSeries.clear();
        this.dataViewPanel.onUpdate();
        this.logClear();
        this.rawData = new ArrayList();
        this.state = CalibState.STATE_READ;
        this.sendCalibCommand(EncIntCalibAction.ACTION_READ, null);
    }

    void sendCalibCommand(EncIntCalibAction action, byte[] data) {
        try {
            SerialCommand cmd = new SerialCommand(122);
            cmd.writeByte(this.encoder_port);
            cmd.writeByte(this.encoder_type);
            cmd.writeByte(action.intValue());
            if (data != null) {
                cmd.write(data);
            }
            SerialCommandProcessor.sendCommand(cmd);
        }
        catch (Exception e) {
            this.error(e.toString());
        }
    }

    @Action
    public void buttonReset() {
        if (this.mainView.showConfirmDialog(this.resourceMap.getString("confirm.reset_defaults", new Object[0]))) {
            this.sendCalibCommand(EncIntCalibAction.ACTION_RESET_DEFAULTS, null);
        }
    }

    @Action
    public void buttonRead() {
        if (!this.checkIsWritten()) {
            return;
        }
        this.updateStatus(this.resourceMap.getString("status.reading_data", new Object[0]));
        this.state = CalibState.STATE_IDLE;
        this.sendCalibCommand(EncIntCalibAction.ACTION_READ, null);
    }

    @Action
    public void buttonWrite() {
        byte[] data = this.icmu.getCalibData();
        if (data != null) {
            this.updateStatus(this.resourceMap.getString("status.writing_data", new Object[0]));
            this.sendCalibCommand(EncIntCalibAction.ACTION_WRITE, data);
        } else {
            this.showErrorMessage("Calibration data is not available yet");
        }
    }

    @Action
    public void buttonCalibrateStop() {
        this.sendCalibCommand(EncIntCalibAction.ACTION_STOP, null);
    }

    @Action
    public void buttonNewWin() {
        try {
            new TabWindow(this.jPanelPlots, this.getClass(), this.resourceMap.getString("window.title.encoder_int_calib", new Object[0]), this.jPanelPlotContainer, false, null).showDialog();
        }
        catch (Exception e) {
            this.logger.error(e.toString());
        }
    }

    @Override
    public boolean onProgressChange(int percent) {
        this.jProgressBar.setValue(percent);
        return true;
    }

    @Override
    public void onProgressFinish(boolean isSuccess) {
        this.jProgressBar.setVisible(false);
    }

    @Override
    public void onProgressStart(String action, boolean modal) {
        this.jProgressBar.setVisible(true);
    }

    public void logClear() {
        this.jTextAreaLog.setText("");
    }

    public void log(String message) {
        if (!this.logStarted) {
            this.jTextAreaLog.setText("");
            this.logStarted = true;
        }
        this.jTextAreaLog.append(message);
        this.jTextAreaLog.append("\n");
    }

    @Override
    public void trace(String message) {
    }

    @Override
    public void debug(String message) {
    }

    @Override
    public void info(String message) {
        this.log(message);
    }

    @Override
    public void warn(String message) {
        this.log("WARN: " + message);
    }

    @Override
    public void error(String message) {
        this.log("ERROR: " + message);
    }

    @Override
    public void append(String part) {
        this.jTextAreaLog.append(part);
    }

    static enum CalibState {
        STATE_IDLE,
        STATE_READ,
        STATE_CALIBRATE;

    }
}

