/*
 * Decompiled with CFR 0.152.
 */
package simplebgc_gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.LayoutManager;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JSeparator;
import javax.swing.SwingUtilities;
import org.jdesktop.application.Action;
import org.jdesktop.application.Application;
import org.jdesktop.application.ApplicationActionMap;
import org.jdesktop.application.ResourceMap;
import org.netbeans.lib.awtextra.AbsoluteConstraints;
import org.netbeans.lib.awtextra.AbsoluteLayout;
import sbgc.service.CommandResponseListener;
import sbgc.service.RealtimeDataThread;
import sbgc.service.SerialCommand;
import sbgc.service.SerialCommandDispatcher;
import sbgc.service.SerialCommandProcessor;
import sbgc.ui.RCDataPanel;
import simplebgc_gui.MyDialog;
import simplebgc_gui.SimpleBGC_GUIApp;

public class DialogMagLinkCalibration
extends MyDialog
implements Runnable {
    boolean oldRtDataState;
    RCDataPanel[] rcDataPanels;
    JPanel[] barPanels;
    int progress = 0;
    private JButton jButtonFinish;
    private JLabel jLabel1;
    private JPanel jPanelBar1;
    private JPanel jPanelBar2;
    private JPanel jPanelBar3;
    private JProgressBar jProgressBar;
    private JSeparator jSeparator1;

    public DialogMagLinkCalibration(Frame parent, boolean modal) {
        super(DialogMagLinkCalibration.class, parent, SimpleBGC_GUIApp.getResourceMap().getString("title.dialog_mag_link_calibration", new Object[0]));
        this.initComponents();
        this.oldRtDataState = RealtimeDataThread.pause(true);
        this.barPanels = new JPanel[]{this.jPanelBar1, this.jPanelBar2, this.jPanelBar3};
        this.rcDataPanels = new RCDataPanel[3];
        for (int i = 0; i < 3; ++i) {
            this.rcDataPanels[i] = new RCDataPanel("MOTOR#" + (i + 1), "%.2f", 0.0f, 1.0f, true);
            this.rcDataPanels[i].addMarker(0);
            this.barPanels[i].add(this.rcDataPanels[i]);
        }
        this.jProgressBar.setVisible(false);
        new Thread(this).start();
    }

    private void initComponents() {
        this.jProgressBar = new JProgressBar();
        this.jSeparator1 = new JSeparator();
        this.jButtonFinish = new JButton();
        this.jPanelBar1 = new JPanel();
        this.jPanelBar2 = new JPanel();
        this.jPanelBar3 = new JPanel();
        this.jLabel1 = new JLabel();
        this.setDefaultCloseOperation(2);
        this.setName("Form");
        this.getContentPane().setLayout((LayoutManager)new AbsoluteLayout());
        this.jProgressBar.setName("jProgressBar");
        this.jProgressBar.setStringPainted(true);
        this.getContentPane().add((Component)this.jProgressBar, new AbsoluteConstraints(30, 160, 420, 20));
        this.jSeparator1.setName("jSeparator1");
        this.getContentPane().add((Component)this.jSeparator1, new AbsoluteConstraints(10, 150, 610, 10));
        ApplicationActionMap actionMap = Application.getInstance(SimpleBGC_GUIApp.class).getContext().getActionMap(DialogMagLinkCalibration.class, this);
        this.jButtonFinish.setAction(actionMap.get("buttonCancel"));
        ResourceMap resourceMap = Application.getInstance(SimpleBGC_GUIApp.class).getContext().getResourceMap(DialogMagLinkCalibration.class);
        this.jButtonFinish.setText(resourceMap.getString("jButtonFinish.text", new Object[0]));
        this.jButtonFinish.setName("jButtonFinish");
        this.getContentPane().add((Component)this.jButtonFinish, new AbsoluteConstraints(480, 160, 120, 30));
        this.jPanelBar1.setBorder(BorderFactory.createBevelBorder(1));
        this.jPanelBar1.setName("jPanelBar1");
        this.jPanelBar1.setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.jPanelBar1, new AbsoluteConstraints(300, 20, 300, 30));
        this.jPanelBar2.setBorder(BorderFactory.createBevelBorder(1));
        this.jPanelBar2.setName("jPanelBar2");
        this.jPanelBar2.setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.jPanelBar2, new AbsoluteConstraints(300, 60, 300, 30));
        this.jPanelBar3.setBorder(BorderFactory.createBevelBorder(1));
        this.jPanelBar3.setName("jPanelBar3");
        this.jPanelBar3.setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.jPanelBar3, new AbsoluteConstraints(300, 100, 300, 30));
        this.jLabel1.setText(resourceMap.getString("jLabel1.text", new Object[0]));
        this.jLabel1.setName("jLabel1");
        this.getContentPane().add((Component)this.jLabel1, new AbsoluteConstraints(10, 10, 280, 120));
        this.pack();
    }

    @Action
    public void buttonCancel() {
        if (this.progress > 0) {
            try {
                SerialCommand cmd = new SerialCommand(74);
                cmd.writeByte(255);
                cmd.writeEmptyArr(12);
                SerialCommandProcessor.sendCommand(cmd);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.cancelDialog();
    }

    @Override
    public void onCloseDialog() {
        RealtimeDataThread.pause(this.oldRtDataState);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        CommandResponseListener commandResponseListener = new CommandResponseListener(74);
        SerialCommandDispatcher.getInstance().addResponseListener(commandResponseListener);
        try {
            while (!this.isClosed()) {
                SerialCommand cmd = new SerialCommand(74);
                cmd.writeByte(254);
                cmd.writeEmptyArr(12);
                SerialCommandProcessor.sendCommand(cmd);
                final SerialCommand resp = commandResponseListener.waitShort(500L);
                if (resp == null) continue;
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        if (resp.id == 67) {
                            DialogMagLinkCalibration.this.progress = 0;
                            DialogMagLinkCalibration.this.jProgressBar.setVisible(false);
                            DialogMagLinkCalibration.this.cancelDialog();
                            SerialCommandProcessor.readAllParams(53);
                        } else {
                            try {
                                DialogMagLinkCalibration.this.progress = resp.readByte();
                                for (int i = 0; i < 3; ++i) {
                                    int cur_val = resp.readWordUnsigned();
                                    int avg_val = resp.readWordUnsigned();
                                    DialogMagLinkCalibration.this.rcDataPanels[i].setMarker(0, (float)avg_val * 0.01f);
                                    DialogMagLinkCalibration.this.rcDataPanels[i].setData(Float.valueOf((float)cur_val * 0.01f));
                                }
                                RCDataPanel.syncScale(DialogMagLinkCalibration.this.rcDataPanels);
                                if (DialogMagLinkCalibration.this.progress > 0) {
                                    DialogMagLinkCalibration.this.jProgressBar.setValue(DialogMagLinkCalibration.this.progress);
                                    DialogMagLinkCalibration.this.jProgressBar.setVisible(true);
                                } else {
                                    DialogMagLinkCalibration.this.jProgressBar.setVisible(false);
                                }
                            }
                            catch (Exception e) {
                                DialogMagLinkCalibration.this.logger.error("Error parsing CMD_CALIB_MOTOR_MAG_LINK:" + e.toString());
                            }
                        }
                    }
                });
                Thread.sleep(200L);
            }
        }
        catch (InterruptedException e) {
            this.logger.warn("Calibration thread interrupted");
        }
        catch (Exception e) {
            this.logger.warn("Exception in the calibration thread: " + e.toString());
        }
        finally {
            SerialCommandDispatcher.getInstance().removeResponseListener(commandResponseListener);
        }
    }
}

