/*
 * Decompiled with CFR 0.152.
 */
package simplebgc_gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.util.Date;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;
import org.jdesktop.application.Action;
import org.jdesktop.application.Application;
import org.jdesktop.application.ApplicationActionMap;
import org.jdesktop.application.ResourceMap;
import org.netbeans.lib.awtextra.AbsoluteConstraints;
import org.netbeans.lib.awtextra.AbsoluteLayout;
import sbgc.object.BoardParams;
import sbgc.object.RealtimeData;
import sbgc.service.CommandResponseListener;
import sbgc.service.RealtimeDataThread;
import sbgc.service.SerialCommand;
import sbgc.service.SerialCommandDispatcher;
import sbgc.service.SerialCommandProcessor;
import sbgc.ui.SensorBarPanel;
import simplebgc_gui.MyDialog;
import simplebgc_gui.PeakMeterPanel;
import simplebgc_gui.SimpleBGC_GUIApp;

public class DialogMagSensorCalibration
extends MyDialog
implements Runnable {
    private ButtonGroup buttonGroupIMU;
    private JButton jButtonAccCalibrate;
    private JButton jButtonFinish;
    private JButton jButtonResetCalib;
    private JLabel jLabelMagErrorInfo;
    private JLabel jLabelTips;
    private JPanel jPanelErrorMeter;
    private JPanel jPanelMagBar;
    private JProgressBar jProgressBar;
    int curSensorType;
    int progress = 0;
    boolean oldRtDataState;
    SensorBarPanel magBarPanel = null;
    PeakMeterPanel errorMeterPanel = null;
    Date prevRTDate;
    boolean interactiveMode = false;
    Thread infoThread = null;

    private void initComponents() {
        this.buttonGroupIMU = new ButtonGroup();
        this.jButtonFinish = new JButton();
        this.jProgressBar = new JProgressBar();
        this.jLabelTips = new JLabel();
        this.jPanelMagBar = new JPanel();
        this.jButtonResetCalib = new JButton();
        this.jButtonAccCalibrate = new JButton();
        this.jPanelErrorMeter = new JPanel();
        this.jLabelMagErrorInfo = new JLabel();
        this.setDefaultCloseOperation(0);
        this.setMinimumSize(new Dimension(550, 280));
        this.setModal(true);
        this.setName("Form");
        this.setResizable(false);
        this.getContentPane().setLayout((LayoutManager)new AbsoluteLayout());
        ApplicationActionMap actionMap = Application.getInstance(SimpleBGC_GUIApp.class).getContext().getActionMap(DialogMagSensorCalibration.class, this);
        this.jButtonFinish.setAction(actionMap.get("buttonSave"));
        ResourceMap resourceMap = Application.getInstance(SimpleBGC_GUIApp.class).getContext().getResourceMap(DialogMagSensorCalibration.class);
        this.jButtonFinish.setText(resourceMap.getString("jButtonFinish.text", new Object[0]));
        this.jButtonFinish.setName("jButtonFinish");
        this.getContentPane().add((Component)this.jButtonFinish, new AbsoluteConstraints(470, 330, 120, 30));
        this.jProgressBar.setName("jProgressBar");
        this.jProgressBar.setStringPainted(true);
        this.getContentPane().add((Component)this.jProgressBar, new AbsoluteConstraints(20, 330, 420, 20));
        this.jLabelTips.setText(resourceMap.getString("jLabelTips.text", new Object[0]));
        this.jLabelTips.setName("jLabelTips");
        this.getContentPane().add((Component)this.jLabelTips, new AbsoluteConstraints(20, 220, 580, 90));
        this.jPanelMagBar.setBorder(BorderFactory.createBevelBorder(1));
        this.jPanelMagBar.setName("jPanelMagBar");
        this.jPanelMagBar.setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.jPanelMagBar, new AbsoluteConstraints(20, 30, 70, 180));
        this.jButtonResetCalib.setAction(actionMap.get("buttonResetMagCalib"));
        this.jButtonResetCalib.setText(resourceMap.getString("jButtonResetCalib.text", new Object[0]));
        this.jButtonResetCalib.setName("jButtonResetCalib");
        this.getContentPane().add((Component)this.jButtonResetCalib, new AbsoluteConstraints(110, 150, 110, -1));
        this.jButtonAccCalibrate.setAction(actionMap.get("buttonCalibMagSimple"));
        this.jButtonAccCalibrate.setText(resourceMap.getString("jButtonAccCalibrate.text", new Object[0]));
        this.jButtonAccCalibrate.setName("jButtonAccCalibrate");
        this.getContentPane().add((Component)this.jButtonAccCalibrate, new AbsoluteConstraints(110, 180, 110, 30));
        this.jPanelErrorMeter.setBorder(BorderFactory.createBevelBorder(1));
        this.jPanelErrorMeter.setName("jPanelErrorMeter");
        this.jPanelErrorMeter.setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.jPanelErrorMeter, new AbsoluteConstraints(240, 30, 40, 180));
        this.jLabelMagErrorInfo.setText(resourceMap.getString("jLabelMagErrorInfo.text", new Object[0]));
        this.jLabelMagErrorInfo.setName("jLabelMagErrorInfo");
        this.getContentPane().add((Component)this.jLabelMagErrorInfo, new AbsoluteConstraints(300, 30, 300, 180));
        this.pack();
    }

    public DialogMagSensorCalibration(Frame parent) {
        super(DialogMagSensorCalibration.class, parent, SimpleBGC_GUIApp.getResourceMap().getString("title.dialog_sensor_calibration", new Object[0]));
        this.initComponents();
        this.oldRtDataState = RealtimeDataThread.pause(false);
        this.curSensorType = (BoardParams.getCurParams().general_flags1 & 0x20) > 0 ? 2 : 1;
        SimpleBGC_GUIApp.mainView.panelMonitoring.setCurIMU(this.curSensorType);
        this.magBarPanel = new SensorBarPanel(-1000, 1000, "-1", "+1", true, true);
        this.jPanelMagBar.add(this.magBarPanel);
        this.errorMeterPanel = new PeakMeterPanel(new float[]{3.0f, 10.0f, 40.0f}, 20, "%.0f\u00b0");
        this.jPanelErrorMeter.add(this.errorMeterPanel);
        this.jProgressBar.setVisible(false);
        this.prevRTDate = new Date();
        this.infoThread = new Thread(this);
        this.infoThread.start();
    }

    @Action
    public void buttonCancel() {
        this.cancelDialog();
    }

    @Action
    public void buttonSave() {
        this.closeDialog(1);
    }

    @Override
    public void onCloseDialog() {
        RealtimeDataThread.pause(this.oldRtDataState);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        CommandResponseListener commandCalibInfoListener = new CommandResponseListener(49);
        SerialCommandDispatcher.getInstance().addResponseListener(commandCalibInfoListener);
        try {
            while (!this.isClosed()) {
                boolean needUpdate = false;
                SerialCommand cmd = new SerialCommand(49);
                cmd.writeByte(this.curSensorType);
                cmd.writeEmptyArr(11);
                SerialCommandProcessor.sendCommand(cmd);
                cmd = commandCalibInfoListener.waitShort(100L);
                if (cmd != null) {
                    this.progress = cmd.readByte();
                    cmd.skipBytes(24);
                    int magError = cmd.readByte();
                    this.errorMeterPanel.addData((float)magError * 0.57295775f);
                    needUpdate = true;
                }
                final RealtimeData rt = RealtimeData.getRealtimeData();
                if (!rt.regDate.equals(this.prevRTDate)) {
                    this.prevRTDate = rt.regDate;
                    needUpdate = true;
                }
                if (!needUpdate) continue;
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        DialogMagSensorCalibration.this.magBarPanel.drawBars(rt.magData);
                        if (DialogMagSensorCalibration.this.progress > 0) {
                            DialogMagSensorCalibration.this.jProgressBar.setValue(DialogMagSensorCalibration.this.progress);
                            DialogMagSensorCalibration.this.jProgressBar.setVisible(true);
                        } else {
                            DialogMagSensorCalibration.this.jProgressBar.setVisible(false);
                        }
                    }
                });
            }
            this.logger.debug("Calibration thread finished normally.");
        }
        catch (InterruptedException e) {
            this.logger.warn("Calibration thread interrupted");
        }
        catch (Exception e) {
            this.logger.warn("Exception in the calibration thread: " + e.toString());
        }
        finally {
            SerialCommandDispatcher.getInstance().removeResponseListener(commandCalibInfoListener);
        }
    }

    private void sendCmdCalibrate(int cmdId, int action, int time_ms) {
        try {
            SerialCommandProcessor.sendCalibExtended(cmdId, this.curSensorType, action, 0, false);
        }
        catch (Exception e) {
            this.showErrorMessage(e.getMessage());
        }
    }

    @Action
    public void buttonCalibMagSimple() {
        this.sendCmdCalibrate(59, 1, 0);
    }

    @Action
    public void buttonResetMagCalib() {
        this.sendCmdCalibrate(59, 2, 0);
    }
}

