/*
 * Decompiled with CFR 0.152.
 */
package simplebgc_gui;

import java.awt.Frame;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JProgressBar;
import javax.swing.LayoutStyle;
import org.apache.log4j.Logger;
import org.jdesktop.application.Action;
import org.jdesktop.application.Application;
import org.jdesktop.application.ApplicationActionMap;
import org.jdesktop.application.ResourceMap;
import sbgc.service.upgrade.IProgressListener;
import sbgc.utils.FileUtil;
import sbgc.utils.Log;
import simplebgc_gui.MyDialog;
import simplebgc_gui.SimpleBGC_GUIApp;

public class DialogProgress
extends MyDialog
implements IProgressListener {
    private static final Log logger = new Log(Logger.getLogger((String)DialogProgress.class.getName()));
    ImageIcon stateIconOn = null;
    ImageIcon stateIconOff = null;
    boolean state;
    private ButtonGroup buttonGroupStart;
    private JButton jButtonCancel;
    private JButton jButtonFinish;
    private JLabel jLabelAction;
    private JLabel jLabelState;
    private JLabel jLabelStatusInfo;
    private JProgressBar jProgressBar;

    public DialogProgress(Frame parent, String actionTitle) {
        super(DialogProgress.class, parent, SimpleBGC_GUIApp.getResourceMap().getString("title.progress_dialog", new Object[0]), true);
        logger.trace("PD dislayed.");
        this.initComponents();
        this.setAction(actionTitle);
        this.getRootPane().setDefaultButton(this.jButtonCancel);
        this.jButtonFinish.setVisible(false);
        this.jLabelState.setVisible(false);
    }

    @Override
    public int showDialog() {
        this.showDialogNewThread();
        return 0;
    }

    public void showFinishButton(boolean isVisible) {
        this.jButtonFinish.setVisible(isVisible);
    }

    public void enableFinishButton(boolean isEnabled) {
        this.jButtonFinish.setEnabled(isEnabled);
    }

    private void initComponents() {
        this.buttonGroupStart = new ButtonGroup();
        this.jButtonCancel = new JButton();
        this.jLabelAction = new JLabel();
        this.jProgressBar = new JProgressBar();
        this.jButtonFinish = new JButton();
        this.jLabelState = new JLabel();
        this.jLabelStatusInfo = new JLabel();
        this.setDefaultCloseOperation(0);
        this.setModal(true);
        this.setName("Form");
        this.setResizable(false);
        ApplicationActionMap actionMap = Application.getInstance(SimpleBGC_GUIApp.class).getContext().getActionMap(DialogProgress.class, this);
        this.jButtonCancel.setAction(actionMap.get("buttonCancel"));
        ResourceMap resourceMap = Application.getInstance(SimpleBGC_GUIApp.class).getContext().getResourceMap(DialogProgress.class);
        this.jButtonCancel.setText(resourceMap.getString("jButtonCancel.text", new Object[0]));
        this.jButtonCancel.setName("jButtonCancel");
        this.jLabelAction.setText(resourceMap.getString("jLabelAction.text", new Object[0]));
        this.jLabelAction.setName("jLabelAction");
        this.jProgressBar.setName("jProgressBar");
        this.jProgressBar.setStringPainted(true);
        this.jButtonFinish.setAction(actionMap.get("buttonFinish"));
        this.jButtonFinish.setText(resourceMap.getString("jButtonFinish.text", new Object[0]));
        this.jButtonFinish.setName("jButtonFinish");
        this.jLabelState.setName("jLabelState");
        this.jLabelStatusInfo.setText(resourceMap.getString("jLabelStatusInfo.text", new Object[0]));
        this.jLabelStatusInfo.setName("jLabelStatusInfo");
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabelStatusInfo, -1, 438, Short.MAX_VALUE).addComponent(this.jProgressBar, -1, 438, Short.MAX_VALUE).addComponent(this.jLabelAction).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.jLabelState, -1, 188, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonFinish, -2, 120, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonCancel, -2, 120, -2))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jLabelAction).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jProgressBar, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabelStatusInfo, -1, 36, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButtonCancel).addComponent(this.jButtonFinish)).addComponent(this.jLabelState, -2, 24, -2)).addContainerGap()));
        this.pack();
    }

    @Action
    public void buttonCancel() {
        logger.trace("PD cancelled.");
        this.cancelDialog();
    }

    @Override
    public void onProgressStart(String action, boolean modal) {
    }

    @Override
    public boolean onProgressChange(int percent) {
        this.jProgressBar.setValue(percent);
        return !this.isCancelled();
    }

    @Override
    public void onProgressFinish(boolean isSuccess) {
        logger.trace("PD onProgressFinish()");
        this.closeDialog(1);
        FileUtil.stopSound();
    }

    @Override
    public void onCloseDialog() {
    }

    public void setAction(String actionTitle) {
        this.jLabelAction.setText(actionTitle);
    }

    @Action
    public void buttonFinish() {
        logger.trace("PD buttonFinish()");
        this.result = 1;
    }

    public boolean isFinished() {
        return this.result == 1;
    }

    public void showState(boolean show) {
        this.jLabelState.setVisible(show);
    }

    public boolean getState() {
        return this.state;
    }

    public void setState(boolean state, String text) {
        ImageIcon icon;
        if (this.stateIconOn == null) {
            this.stateIconOn = new ImageIcon(DialogProgress.class.getResource("/simplebgc_gui/resources/progress-state-on.png"));
        }
        if (this.stateIconOff == null) {
            this.stateIconOff = new ImageIcon(DialogProgress.class.getResource("/simplebgc_gui/resources/progress-state-off.png"));
        }
        ImageIcon imageIcon = icon = state ? this.stateIconOn : this.stateIconOff;
        if (this.jLabelState.getIcon() != icon) {
            logger.debug("new progress state: " + state + ", " + text);
            this.jLabelState.setIcon(icon);
            if (state) {
                FileUtil.playSound("switch.wav", 1);
            } else {
                FileUtil.playSound("wait.wav", 5);
            }
        }
        this.jLabelState.setText(text);
        this.state = state;
    }

    public void setStatusInfo(String info) {
        this.jLabelStatusInfo.setText("<html>" + info + "</html>");
    }
}

