/*
 * Decompiled with CFR 0.152.
 */
package simplebgc_gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JSeparator;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import org.jdesktop.application.Action;
import org.jdesktop.application.Application;
import org.jdesktop.application.ApplicationActionMap;
import org.jdesktop.application.ResourceMap;
import org.netbeans.lib.awtextra.AbsoluteConstraints;
import org.netbeans.lib.awtextra.AbsoluteLayout;
import sbgc.object.BoardInfo;
import sbgc.object.BoardParams;
import sbgc.object.RCInputCalib;
import sbgc.object.RealtimeData;
import sbgc.service.CommandResponseListener;
import sbgc.service.RealtimeDataThread;
import sbgc.service.SerialCommand;
import sbgc.service.SerialCommandDispatcher;
import sbgc.service.SerialCommandProcessor;
import sbgc.service.upgrade.IProgressListener;
import sbgc.ui.ParamsUIFactory;
import sbgc.ui.RCDataPanel;
import sbgc.ui.SpravComboBoxModel;
import simplebgc_gui.MyDialog;
import simplebgc_gui.SimpleBGC_GUIApp;

public class DialogRCInputCalibration
extends MyDialog
implements Runnable,
IProgressListener {
    boolean oldRtDataState;
    RCDataPanel[] rcDataPanels;
    JPanel[] barPanels;
    JComboBox[] comboBoxSrc;
    JSpinner[] spinnerOffset;
    JSpinner[] spinnerScalePos;
    JSpinner[] spinnerScaleNeg;
    int[] maxVal;
    int[] minVal;
    int[] curVal;
    boolean calibrationMode = false;
    BoardParams params = BoardParams.getCurParams();
    private JButton jButtonCalibrate;
    private JButton jButtonFinish;
    private JButton jButtonReset;
    private JButton jButtonSaveClose;
    private JComboBox jComboBoxSrc1;
    private JComboBox jComboBoxSrc2;
    private JComboBox jComboBoxSrc3;
    private JComboBox jComboBoxSrc4;
    private JComboBox jComboBoxSrc5;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JPanel jPanelBar1;
    private JPanel jPanelBar2;
    private JPanel jPanelBar3;
    private JPanel jPanelBar4;
    private JPanel jPanelBar5;
    private JProgressBar jProgressBar;
    private JSeparator jSeparator1;
    private JSpinner jSpinnerOffset1;
    private JSpinner jSpinnerOffset2;
    private JSpinner jSpinnerOffset3;
    private JSpinner jSpinnerOffset4;
    private JSpinner jSpinnerOffset5;
    private JSpinner jSpinnerScaleNeg1;
    private JSpinner jSpinnerScaleNeg2;
    private JSpinner jSpinnerScaleNeg3;
    private JSpinner jSpinnerScaleNeg4;
    private JSpinner jSpinnerScaleNeg5;
    private JSpinner jSpinnerScalePos1;
    private JSpinner jSpinnerScalePos2;
    private JSpinner jSpinnerScalePos3;
    private JSpinner jSpinnerScalePos4;
    private JSpinner jSpinnerScalePos5;

    public DialogRCInputCalibration(Frame parent, boolean modal) throws Exception {
        super(DialogRCInputCalibration.class, parent, SimpleBGC_GUIApp.getResourceMap().getString("title.dialog_RC_input_calibration", new Object[0]));
        int i;
        if (this.params == null) {
            throw new Exception("BoardParams is null!");
        }
        this.initComponents();
        this.jProgressBar.setVisible(false);
        this.oldRtDataState = RealtimeDataThread.pause(true);
        this.barPanels = new JPanel[]{this.jPanelBar1, this.jPanelBar2, this.jPanelBar3, this.jPanelBar4, this.jPanelBar5};
        this.rcDataPanels = new RCDataPanel[this.barPanels.length];
        for (i = 0; i < this.rcDataPanels.length; ++i) {
            this.rcDataPanels[i] = new RCDataPanel("", "%.1f", -600.0f, 600.0f, false);
            this.rcDataPanels[i].addMarker(0);
            this.rcDataPanels[i].addMarker(-500);
            this.rcDataPanels[i].addMarker(500);
            this.barPanels[i].add(this.rcDataPanels[i]);
        }
        this.comboBoxSrc = new JComboBox[]{this.jComboBoxSrc1, this.jComboBoxSrc2, this.jComboBoxSrc3, this.jComboBoxSrc4, this.jComboBoxSrc5};
        for (i = 0; i < this.comboBoxSrc.length; ++i) {
            this.comboBoxSrc[i].setModel(new SpravComboBoxModel(ParamsUIFactory.getRCMapList(BoardInfo.getBoardInfo())));
        }
        this.spinnerOffset = new JSpinner[]{this.jSpinnerOffset1, this.jSpinnerOffset2, this.jSpinnerOffset3, this.jSpinnerOffset4, this.jSpinnerOffset5};
        this.spinnerScalePos = new JSpinner[]{this.jSpinnerScalePos1, this.jSpinnerScalePos2, this.jSpinnerScalePos3, this.jSpinnerScalePos4, this.jSpinnerScalePos5};
        this.spinnerScaleNeg = new JSpinner[]{this.jSpinnerScaleNeg1, this.jSpinnerScaleNeg2, this.jSpinnerScaleNeg3, this.jSpinnerScaleNeg4, this.jSpinnerScaleNeg5};
        this.minVal = new int[5];
        this.maxVal = new int[5];
        this.curVal = new int[5];
        this.updateBoardParams();
        new Thread(this).start();
    }

    private void initComponents() {
        this.jSeparator1 = new JSeparator();
        this.jButtonFinish = new JButton();
        this.jLabel1 = new JLabel();
        this.jButtonCalibrate = new JButton();
        this.jLabel2 = new JLabel();
        this.jLabel3 = new JLabel();
        this.jLabel4 = new JLabel();
        this.jLabel5 = new JLabel();
        this.jComboBoxSrc1 = new JComboBox();
        this.jSpinnerOffset1 = new JSpinner();
        this.jSpinnerScaleNeg1 = new JSpinner();
        this.jSpinnerScalePos1 = new JSpinner();
        this.jPanelBar1 = new JPanel();
        this.jButtonReset = new JButton();
        this.jComboBoxSrc2 = new JComboBox();
        this.jSpinnerOffset2 = new JSpinner();
        this.jSpinnerScaleNeg2 = new JSpinner();
        this.jSpinnerScalePos2 = new JSpinner();
        this.jPanelBar2 = new JPanel();
        this.jComboBoxSrc3 = new JComboBox();
        this.jSpinnerOffset3 = new JSpinner();
        this.jSpinnerScaleNeg3 = new JSpinner();
        this.jSpinnerScalePos3 = new JSpinner();
        this.jPanelBar3 = new JPanel();
        this.jComboBoxSrc4 = new JComboBox();
        this.jSpinnerOffset4 = new JSpinner();
        this.jSpinnerScaleNeg4 = new JSpinner();
        this.jSpinnerScalePos4 = new JSpinner();
        this.jPanelBar4 = new JPanel();
        this.jComboBoxSrc5 = new JComboBox();
        this.jSpinnerOffset5 = new JSpinner();
        this.jSpinnerScaleNeg5 = new JSpinner();
        this.jSpinnerScalePos5 = new JSpinner();
        this.jPanelBar5 = new JPanel();
        this.jProgressBar = new JProgressBar();
        this.jButtonSaveClose = new JButton();
        this.setDefaultCloseOperation(2);
        this.setName("Form");
        this.getContentPane().setLayout((LayoutManager)new AbsoluteLayout());
        this.jSeparator1.setName("jSeparator1");
        this.getContentPane().add((Component)this.jSeparator1, new AbsoluteConstraints(10, 390, 610, 10));
        ApplicationActionMap actionMap = Application.getInstance(SimpleBGC_GUIApp.class).getContext().getActionMap(DialogRCInputCalibration.class, this);
        this.jButtonFinish.setAction(actionMap.get("buttonCancel"));
        ResourceMap resourceMap = Application.getInstance(SimpleBGC_GUIApp.class).getContext().getResourceMap(DialogRCInputCalibration.class);
        this.jButtonFinish.setText(resourceMap.getString("jButtonFinish.text", new Object[0]));
        this.jButtonFinish.setName("jButtonFinish");
        this.getContentPane().add((Component)this.jButtonFinish, new AbsoluteConstraints(310, 400, 120, 30));
        this.jLabel1.setText(resourceMap.getString("jLabel1.text", new Object[0]));
        this.jLabel1.setName("jLabel1");
        this.getContentPane().add((Component)this.jLabel1, new AbsoluteConstraints(10, 0, 600, 110));
        this.jButtonCalibrate.setAction(actionMap.get("buttonCalibrate"));
        this.jButtonCalibrate.setText(resourceMap.getString("jButtonCalibrate.text", new Object[0]));
        this.jButtonCalibrate.setEnabled(false);
        this.jButtonCalibrate.setName("jButtonCalibrate");
        this.getContentPane().add((Component)this.jButtonCalibrate, new AbsoluteConstraints(340, 350, 110, 30));
        this.jLabel2.setText(resourceMap.getString("jLabel2.text", new Object[0]));
        this.jLabel2.setName("jLabel2");
        this.getContentPane().add((Component)this.jLabel2, new AbsoluteConstraints(10, 120, -1, -1));
        this.jLabel3.setText(resourceMap.getString("jLabel3.text", new Object[0]));
        this.jLabel3.setName("jLabel3");
        this.getContentPane().add((Component)this.jLabel3, new AbsoluteConstraints(220, 120, -1, -1));
        this.jLabel4.setText(resourceMap.getString("jLabel4.text", new Object[0]));
        this.jLabel4.setName("jLabel4");
        this.getContentPane().add((Component)this.jLabel4, new AbsoluteConstraints(280, 120, -1, -1));
        this.jLabel5.setText(resourceMap.getString("jLabel5.text", new Object[0]));
        this.jLabel5.setName("jLabel5");
        this.getContentPane().add((Component)this.jLabel5, new AbsoluteConstraints(400, 120, -1, -1));
        this.jComboBoxSrc1.setName("jComboBoxSrc1");
        this.getContentPane().add((Component)this.jComboBoxSrc1, new AbsoluteConstraints(10, 150, 200, -1));
        this.jSpinnerOffset1.setModel(new SpinnerNumberModel(0, -128, 128, 1));
        this.jSpinnerOffset1.setName("jSpinnerOffset1");
        this.getContentPane().add((Component)this.jSpinnerOffset1, new AbsoluteConstraints(220, 150, 50, -1));
        this.jSpinnerScaleNeg1.setModel(new SpinnerNumberModel(0, 0, 255, 1));
        this.jSpinnerScaleNeg1.setName("jSpinnerScaleNeg1");
        this.getContentPane().add((Component)this.jSpinnerScaleNeg1, new AbsoluteConstraints(280, 150, 50, -1));
        this.jSpinnerScalePos1.setModel(new SpinnerNumberModel(0, 0, 255, 1));
        this.jSpinnerScalePos1.setName("jSpinnerScalePos1");
        this.getContentPane().add((Component)this.jSpinnerScalePos1, new AbsoluteConstraints(340, 150, 50, -1));
        this.jPanelBar1.setBorder(BorderFactory.createBevelBorder(1));
        this.jPanelBar1.setName("jPanelBar1");
        this.jPanelBar1.setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.jPanelBar1, new AbsoluteConstraints(400, 150, 200, 30));
        this.jButtonReset.setAction(actionMap.get("buttonReset"));
        this.jButtonReset.setText(resourceMap.getString("jButtonReset.text", new Object[0]));
        this.jButtonReset.setName("jButtonReset");
        this.getContentPane().add((Component)this.jButtonReset, new AbsoluteConstraints(220, 350, 110, 30));
        this.jComboBoxSrc2.setName("jComboBoxSrc2");
        this.getContentPane().add((Component)this.jComboBoxSrc2, new AbsoluteConstraints(10, 190, 200, -1));
        this.jSpinnerOffset2.setModel(new SpinnerNumberModel(0, -128, 128, 1));
        this.jSpinnerOffset2.setName("jSpinnerOffset2");
        this.getContentPane().add((Component)this.jSpinnerOffset2, new AbsoluteConstraints(220, 190, 50, -1));
        this.jSpinnerScaleNeg2.setModel(new SpinnerNumberModel(0, 0, 255, 1));
        this.jSpinnerScaleNeg2.setName("jSpinnerScaleNeg2");
        this.getContentPane().add((Component)this.jSpinnerScaleNeg2, new AbsoluteConstraints(280, 190, 50, -1));
        this.jSpinnerScalePos2.setModel(new SpinnerNumberModel(0, 0, 255, 1));
        this.jSpinnerScalePos2.setName("jSpinnerScalePos2");
        this.getContentPane().add((Component)this.jSpinnerScalePos2, new AbsoluteConstraints(340, 190, 50, -1));
        this.jPanelBar2.setBorder(BorderFactory.createBevelBorder(1));
        this.jPanelBar2.setName("jPanelBar2");
        this.jPanelBar2.setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.jPanelBar2, new AbsoluteConstraints(400, 190, 200, 30));
        this.jComboBoxSrc3.setName("jComboBoxSrc3");
        this.getContentPane().add((Component)this.jComboBoxSrc3, new AbsoluteConstraints(10, 230, 200, -1));
        this.jSpinnerOffset3.setModel(new SpinnerNumberModel(0, -128, 128, 1));
        this.jSpinnerOffset3.setName("jSpinnerOffset3");
        this.getContentPane().add((Component)this.jSpinnerOffset3, new AbsoluteConstraints(220, 230, 50, -1));
        this.jSpinnerScaleNeg3.setModel(new SpinnerNumberModel(0, 0, 255, 1));
        this.jSpinnerScaleNeg3.setName("jSpinnerScaleNeg3");
        this.getContentPane().add((Component)this.jSpinnerScaleNeg3, new AbsoluteConstraints(280, 230, 50, -1));
        this.jSpinnerScalePos3.setModel(new SpinnerNumberModel(0, 0, 255, 1));
        this.jSpinnerScalePos3.setName("jSpinnerScalePos3");
        this.getContentPane().add((Component)this.jSpinnerScalePos3, new AbsoluteConstraints(340, 230, 50, -1));
        this.jPanelBar3.setBorder(BorderFactory.createBevelBorder(1));
        this.jPanelBar3.setName("jPanelBar3");
        this.jPanelBar3.setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.jPanelBar3, new AbsoluteConstraints(400, 230, 200, 30));
        this.jComboBoxSrc4.setName("jComboBoxSrc4");
        this.getContentPane().add((Component)this.jComboBoxSrc4, new AbsoluteConstraints(10, 270, 200, -1));
        this.jSpinnerOffset4.setModel(new SpinnerNumberModel(0, -128, 128, 1));
        this.jSpinnerOffset4.setName("jSpinnerOffset4");
        this.getContentPane().add((Component)this.jSpinnerOffset4, new AbsoluteConstraints(220, 270, 50, -1));
        this.jSpinnerScaleNeg4.setModel(new SpinnerNumberModel(0, 0, 255, 1));
        this.jSpinnerScaleNeg4.setName("jSpinnerScaleNeg4");
        this.getContentPane().add((Component)this.jSpinnerScaleNeg4, new AbsoluteConstraints(280, 270, 50, -1));
        this.jSpinnerScalePos4.setModel(new SpinnerNumberModel(0, 0, 255, 1));
        this.jSpinnerScalePos4.setName("jSpinnerScalePos4");
        this.getContentPane().add((Component)this.jSpinnerScalePos4, new AbsoluteConstraints(340, 270, 50, -1));
        this.jPanelBar4.setBorder(BorderFactory.createBevelBorder(1));
        this.jPanelBar4.setName("jPanelBar4");
        this.jPanelBar4.setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.jPanelBar4, new AbsoluteConstraints(400, 270, 200, 26));
        this.jComboBoxSrc5.setName("jComboBoxSrc5");
        this.getContentPane().add((Component)this.jComboBoxSrc5, new AbsoluteConstraints(10, 310, 200, -1));
        this.jSpinnerOffset5.setModel(new SpinnerNumberModel(0, -128, 128, 1));
        this.jSpinnerOffset5.setName("jSpinnerOffset5");
        this.getContentPane().add((Component)this.jSpinnerOffset5, new AbsoluteConstraints(220, 310, 50, -1));
        this.jSpinnerScaleNeg5.setModel(new SpinnerNumberModel(0, 0, 255, 1));
        this.jSpinnerScaleNeg5.setName("jSpinnerScaleNeg5");
        this.getContentPane().add((Component)this.jSpinnerScaleNeg5, new AbsoluteConstraints(280, 310, 50, -1));
        this.jSpinnerScalePos5.setModel(new SpinnerNumberModel(0, 0, 255, 1));
        this.jSpinnerScalePos5.setName("jSpinnerScalePos5");
        this.getContentPane().add((Component)this.jSpinnerScalePos5, new AbsoluteConstraints(340, 310, 50, -1));
        this.jPanelBar5.setBorder(BorderFactory.createBevelBorder(1));
        this.jPanelBar5.setName("jPanelBar5");
        this.jPanelBar5.setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.jPanelBar5, new AbsoluteConstraints(400, 310, 200, 30));
        this.jProgressBar.setName("jProgressBar");
        this.jProgressBar.setStringPainted(true);
        this.getContentPane().add((Component)this.jProgressBar, new AbsoluteConstraints(10, 400, 280, 20));
        this.jButtonSaveClose.setAction(actionMap.get("buttonSave"));
        this.jButtonSaveClose.setText(resourceMap.getString("jButtonSaveClose.text", new Object[0]));
        this.jButtonSaveClose.setName("jButtonSaveClose");
        this.getContentPane().add((Component)this.jButtonSaveClose, new AbsoluteConstraints(440, 400, 160, 30));
        this.pack();
    }

    private void setDefaultRCRangeMarkers() {
        for (int i = 0; i < 5; ++i) {
            this.rcDataPanels[i].setMarker(1, -500.0f);
            this.rcDataPanels[i].setMarker(2, 500.0f);
        }
    }

    public void updateBoardParams() {
        for (int i = 0; i < 5; ++i) {
            RCInputCalib c = this.params.rc_input_calib[i];
            ((SpravComboBoxModel)this.comboBoxSrc[i].getModel()).setCurrent(c.src_ch);
            this.spinnerOffset[i].setValue(c.offset);
            this.spinnerScalePos[i].setValue(c.pos_scale);
            this.spinnerScaleNeg[i].setValue(c.neg_scale);
        }
    }

    public void applyBoardParams() {
        for (int i = 0; i < 5; ++i) {
            RCInputCalib c = this.params.rc_input_calib[i];
            c.src_ch = ((SpravComboBoxModel)this.comboBoxSrc[i].getModel()).getCurrentId();
            c.offset = ((Number)this.spinnerOffset[i].getValue()).intValue();
            c.pos_scale = ((Number)this.spinnerScalePos[i].getValue()).intValue();
            c.neg_scale = ((Number)this.spinnerScaleNeg[i].getValue()).intValue();
        }
        Arrays.sort(this.params.rc_input_calib);
    }

    @Action
    public void buttonCancel() {
        this.cancelDialog();
    }

    @Action
    public void buttonSave() {
        this.applyBoardParams();
        this.closeDialog(1);
    }

    @Override
    public void onCloseDialog() {
        RealtimeDataThread.pause(this.oldRtDataState);
    }

    @Override
    public void onProgressStart(String action, boolean modal) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                DialogRCInputCalibration.this.jProgressBar.setVisible(true);
                DialogRCInputCalibration.this.jProgressBar.setValue(0);
            }
        });
    }

    @Override
    public boolean onProgressChange(final int val) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                DialogRCInputCalibration.this.jProgressBar.setValue(val);
            }
        });
        return true;
    }

    @Override
    public void onProgressFinish(boolean isSuccess) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                DialogRCInputCalibration.this.jProgressBar.setVisible(false);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        CommandResponseListener commandResponseListener = new CommandResponseListener(100);
        SerialCommandDispatcher.getInstance().addResponseListener(commandResponseListener);
        try {
            while (!this.isClosed()) {
                SerialCommand cmd = new SerialCommand(100);
                cmd.writeWord(1);
                for (int i = 0; i < 5; ++i) {
                    cmd.writeByte(this.params.rc_input_calib[i].src_ch);
                }
                SerialCommandProcessor.sendCommand(cmd);
                final SerialCommand resp = commandResponseListener.waitShort(500L);
                if (resp == null) continue;
                if (resp.id == 100) {
                    SwingUtilities.invokeAndWait(new Runnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void run() {
                            4 var1_1 = this;
                            synchronized (var1_1) {
                                try {
                                    for (int i = 0; i < 5; ++i) {
                                        int cur_val = resp.readWord();
                                        if (cur_val != Short.MIN_VALUE) {
                                            if (DialogRCInputCalibration.this.calibrationMode) {
                                                DialogRCInputCalibration.this.curVal[i] = cur_val;
                                                DialogRCInputCalibration.this.minVal[i] = Math.min(DialogRCInputCalibration.this.curVal[i], DialogRCInputCalibration.this.minVal[i]);
                                                DialogRCInputCalibration.this.maxVal[i] = Math.max(DialogRCInputCalibration.this.curVal[i], DialogRCInputCalibration.this.maxVal[i]);
                                                DialogRCInputCalibration.this.rcDataPanels[i].setMarker(1, RealtimeData.rcData16_to_API_range(DialogRCInputCalibration.this.minVal[i], 0).intValue());
                                                DialogRCInputCalibration.this.rcDataPanels[i].setMarker(2, RealtimeData.rcData16_to_API_range(DialogRCInputCalibration.this.maxVal[i], 0).intValue());
                                            }
                                            DialogRCInputCalibration.this.rcDataPanels[i].setData(RealtimeData.rcData16_to_API_range(cur_val, 0));
                                            continue;
                                        }
                                        DialogRCInputCalibration.this.rcDataPanels[i].setData((Integer)null);
                                    }
                                }
                                catch (Exception e) {
                                    DialogRCInputCalibration.this.logger.error("Error parsing CMD_CALIB_RC_INPUTS:" + e.toString());
                                }
                            }
                        }
                    });
                } else {
                    this.logger.error("Unexpected response received Id=" + resp.id);
                }
                Thread.sleep(50L);
            }
        }
        catch (InterruptedException e) {
            this.logger.warn("Calibration thread interrupted");
        }
        catch (Exception e) {
            this.logger.warn("Exception in the calibration thread: " + e.toString());
        }
        finally {
            SerialCommandDispatcher.getInstance().removeResponseListener(commandResponseListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Action
    public void buttonCalibrate() {
        DialogRCInputCalibration dialogRCInputCalibration = this;
        synchronized (dialogRCInputCalibration) {
            if (this.calibrationMode) {
                this.calibrationMode = false;
                this.jButtonCalibrate.setEnabled(false);
                for (int i = 0; i < 5; ++i) {
                    RCInputCalib c = this.params.rc_input_calib[i];
                    if (this.curVal[i] == Short.MIN_VALUE || this.maxVal[i] == this.curVal[i] || this.minVal[i] == this.curVal[i]) continue;
                    c.offset = Math.min(127, Math.max(-128, -this.curVal[i] / 128));
                    c.pos_scale = Math.min(255, Math.max(0, (16547840 / (this.maxVal[i] - this.curVal[i]) + -795) / 10));
                    c.neg_scale = Math.min(255, Math.max(0, (-16547840 / (this.minVal[i] - this.curVal[i]) + -795) / 10));
                }
                this.updateBoardParams();
                this.setDefaultRCRangeMarkers();
                SerialCommandProcessor.writeAllParams(this.params, 50, this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Action
    public void buttonReset() {
        DialogRCInputCalibration dialogRCInputCalibration = this;
        synchronized (dialogRCInputCalibration) {
            this.calibrationMode = false;
            this.jButtonCalibrate.setEnabled(false);
            this.applyBoardParams();
            for (int i = 0; i < this.params.rc_input_calib.length; ++i) {
                this.params.rc_input_calib[i].reset();
                this.minVal[i] = 0;
                this.maxVal[i] = 0;
                this.curVal[i] = Short.MIN_VALUE;
            }
            this.updateBoardParams();
            SerialCommandProcessor.writeAllParams(this.params, 50, this);
            Timer t = new Timer(2000, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DialogRCInputCalibration.this.calibrationMode = true;
                    DialogRCInputCalibration.this.jButtonCalibrate.setEnabled(true);
                }
            });
            t.setRepeats(false);
            t.start();
        }
    }
}

