/*
 * Decompiled with CFR 0.152.
 */
package simplebgc_gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import org.jdesktop.application.Action;
import org.jdesktop.application.Application;
import org.jdesktop.application.ApplicationActionMap;
import org.jdesktop.application.ResourceMap;
import sbgc.utils.Log;
import sbgc.utils.Settings;
import simplebgc_gui.Country;
import simplebgc_gui.CountryComparator;
import simplebgc_gui.SimpleBGC_GUIApp;
import simplebgc_gui.SimpleBGC_GUIView;

public class DialogRegistrationData
extends JDialog {
    public final String URL_REGISTRATION_TERMS = "/user_registration_terms/";
    private static final Log logger = new Log(org.apache.log4j.Logger.getLogger((String)DialogRegistrationData.class.getName()));
    private boolean result = false;
    private JButton buttonCancel;
    private JButton buttonOk;
    private JButton buttonSkip;
    private JCheckBox checkBoxLicenseAgreement;
    private JComboBox comboBoxCountry;
    private JLabel jLabelEnterEmail;
    private JLabel labelCountry;
    private JLabel labelEmail;
    private JLabel labelName;
    private JLabel labelProjectLink;
    private JPanel panelButtonCancel;
    private JPanel panelButtonOk;
    private JPanel panelButtons;
    private JPanel panelCountry;
    private JPanel panelEmail;
    private JPanel panelLicenseAgree;
    private JPanel panelMain;
    private JPanel panelName;
    private JPanel panelRegistrationData;
    private JTextField textFieldEmail;
    private JTextField textFieldName;

    public DialogRegistrationData(Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
        this.customInitialization();
    }

    public boolean getResult() {
        return this.result;
    }

    public static boolean isSuccessfull(JFrame parent) {
        if ("1".equals(Settings.get("registration.data.sent"))) {
            DialogRegistrationData dialogRegistrationData = new DialogRegistrationData((Frame)parent, true);
            dialogRegistrationData.setLocationRelativeTo(parent);
            SimpleBGC_GUIApp.getApplication().show(dialogRegistrationData);
            return dialogRegistrationData.getResult();
        }
        return true;
    }

    private void onFieldEmpty(String fieldName) {
        JOptionPane.showMessageDialog(this, "Please, specify value of field \"" + fieldName + "\". It can't be empty!", "Validation Error", 0);
    }

    private boolean validateFields() {
        if (this.textFieldEmail.getText() == null || this.textFieldEmail.getText().trim().length() == 0) {
            this.onFieldEmpty("Email");
            return false;
        }
        if (this.textFieldEmail.getText().indexOf("@") < 0 || this.textFieldEmail.getText().indexOf(".") < 0) {
            JOptionPane.showMessageDialog(this, "Incorrect email format!", "Validation Error", 0);
            return false;
        }
        if (this.comboBoxCountry.getSelectedItem() == null) {
            this.onFieldEmpty("Country");
            return false;
        }
        if (!this.checkBoxLicenseAgreement.isSelected()) {
            JOptionPane.showMessageDialog(this, "You need to accept license before continue!", "License Error", 0);
            return false;
        }
        return true;
    }

    @Action
    public void onRegistrationOk() {
        if (this.validateFields()) {
            Settings.set("registration.data.sent", "1");
            Settings.set("registration.data.name", this.textFieldName.getText());
            Settings.set("registration.data.email", this.textFieldEmail.getText());
            Settings.set("registration.data.country", ((Country)this.comboBoxCountry.getSelectedItem()).getIso());
            Settings.save();
            this.result = true;
            this.dispose();
        }
    }

    @Action
    public void onRegistrationSkip() {
        Settings.set("registration.data.sent", "0");
        Settings.save();
        this.result = true;
        this.dispose();
    }

    @Action
    public void onRegistrationCancel() {
        this.result = false;
        this.dispose();
    }

    private void initComponents() {
        this.panelButtons = new JPanel();
        this.panelButtonOk = new JPanel();
        this.buttonOk = new JButton();
        this.panelButtonCancel = new JPanel();
        this.buttonCancel = new JButton();
        this.buttonSkip = new JButton();
        this.panelMain = new JPanel();
        this.panelLicenseAgree = new JPanel();
        this.checkBoxLicenseAgreement = new JCheckBox();
        this.labelProjectLink = new JLabel();
        this.panelRegistrationData = new JPanel();
        this.panelName = new JPanel();
        this.labelName = new JLabel();
        this.textFieldName = new JTextField();
        this.panelEmail = new JPanel();
        this.labelEmail = new JLabel();
        this.textFieldEmail = new JTextField();
        this.jLabelEnterEmail = new JLabel();
        this.panelCountry = new JPanel();
        this.labelCountry = new JLabel();
        this.comboBoxCountry = new JComboBox();
        this.setDefaultCloseOperation(2);
        ResourceMap resourceMap = Application.getInstance(SimpleBGC_GUIApp.class).getContext().getResourceMap(DialogRegistrationData.class);
        this.setTitle(resourceMap.getString("Form.title", new Object[0]));
        this.setModal(true);
        this.setName("Form");
        this.setResizable(false);
        this.panelButtons.setName("panelButtons");
        this.panelButtons.setLayout(new BorderLayout());
        this.panelButtonOk.setName("panelButtonOk");
        ApplicationActionMap actionMap = Application.getInstance(SimpleBGC_GUIApp.class).getContext().getActionMap(DialogRegistrationData.class, this);
        this.buttonOk.setAction(actionMap.get("onRegistrationOk"));
        this.buttonOk.setText(resourceMap.getString("buttonOk.text", new Object[0]));
        this.buttonOk.setName("buttonOk");
        this.panelButtonOk.add(this.buttonOk);
        this.panelButtons.add((Component)this.panelButtonOk, "East");
        this.panelButtonCancel.setName("panelButtonCancel");
        this.panelButtonCancel.setLayout(new FlowLayout(0));
        this.buttonCancel.setAction(actionMap.get("onRegistrationCancel"));
        this.buttonCancel.setText(resourceMap.getString("buttonCancel.text", new Object[0]));
        this.buttonCancel.setName("buttonCancel");
        this.panelButtonCancel.add(this.buttonCancel);
        this.buttonSkip.setAction(actionMap.get("onRegistrationSkip"));
        this.buttonSkip.setText(resourceMap.getString("buttonSkip.text", new Object[0]));
        this.buttonSkip.setName("buttonSkip");
        this.panelButtonCancel.add(this.buttonSkip);
        this.panelButtons.add((Component)this.panelButtonCancel, "Center");
        this.getContentPane().add((Component)this.panelButtons, "South");
        this.panelMain.setName("panelMain");
        this.panelMain.setLayout(new BorderLayout());
        this.panelLicenseAgree.setBorder(BorderFactory.createEmptyBorder(0, 110, 0, 0));
        this.panelLicenseAgree.setMinimumSize(new Dimension(326, 53));
        this.panelLicenseAgree.setName("panelLicenseAgree");
        this.panelLicenseAgree.setPreferredSize(new Dimension(507, 53));
        this.checkBoxLicenseAgreement.setText(resourceMap.getString("checkBoxLicenseAgreement.text", new Object[0]));
        this.checkBoxLicenseAgreement.setName("checkBoxLicenseAgreement");
        this.panelLicenseAgree.add(this.checkBoxLicenseAgreement);
        this.labelProjectLink.setText(resourceMap.getString("labelProjectLink.text", new Object[0]));
        this.labelProjectLink.setName("labelProjectLink");
        this.panelLicenseAgree.add(this.labelProjectLink);
        this.panelMain.add((Component)this.panelLicenseAgree, "South");
        this.panelRegistrationData.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.panelRegistrationData.setName("panelRegistrationData");
        this.panelRegistrationData.setLayout(new BoxLayout(this.panelRegistrationData, 3));
        this.panelName.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.panelName.setName("panelName");
        this.panelName.setLayout(new BorderLayout(5, 5));
        this.labelName.setHorizontalAlignment(4);
        this.labelName.setText(resourceMap.getString("labelName.text", new Object[0]));
        this.labelName.setMaximumSize(new Dimension(100, 16));
        this.labelName.setMinimumSize(new Dimension(100, 16));
        this.labelName.setName("labelName");
        this.labelName.setPreferredSize(new Dimension(100, 16));
        this.panelName.add((Component)this.labelName, "West");
        this.textFieldName.setText(resourceMap.getString("textFieldName.text", new Object[0]));
        this.textFieldName.setName("textFieldName");
        this.panelName.add((Component)this.textFieldName, "Center");
        this.panelRegistrationData.add(this.panelName);
        this.panelEmail.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.panelEmail.setName("panelEmail");
        this.panelEmail.setLayout(new BorderLayout(5, 5));
        this.labelEmail.setHorizontalAlignment(4);
        this.labelEmail.setText(resourceMap.getString("labelEmail.text", new Object[0]));
        this.labelEmail.setMaximumSize(new Dimension(100, 16));
        this.labelEmail.setMinimumSize(new Dimension(100, 16));
        this.labelEmail.setName("labelEmail");
        this.labelEmail.setPreferredSize(new Dimension(100, 16));
        this.panelEmail.add((Component)this.labelEmail, "West");
        this.textFieldEmail.setText(resourceMap.getString("textFieldEmail.text", new Object[0]));
        this.textFieldEmail.setName("textFieldEmail");
        this.panelEmail.add((Component)this.textFieldEmail, "Center");
        this.jLabelEnterEmail.setText(resourceMap.getString("jLabelEnterEmail.text", new Object[0]));
        this.jLabelEnterEmail.setName("jLabelEnterEmail");
        this.panelEmail.add((Component)this.jLabelEnterEmail, "First");
        this.jLabelEnterEmail.getAccessibleContext().setAccessibleName(resourceMap.getString("jLabel1.AccessibleContext.accessibleName", new Object[0]));
        this.panelRegistrationData.add(this.panelEmail);
        this.panelCountry.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.panelCountry.setName("panelCountry");
        this.panelCountry.setLayout(new BorderLayout(5, 5));
        this.labelCountry.setHorizontalAlignment(4);
        this.labelCountry.setText(resourceMap.getString("labelCountry.text", new Object[0]));
        this.labelCountry.setMaximumSize(new Dimension(100, 16));
        this.labelCountry.setMinimumSize(new Dimension(100, 16));
        this.labelCountry.setName("labelCountry");
        this.labelCountry.setPreferredSize(new Dimension(100, 16));
        this.panelCountry.add((Component)this.labelCountry, "Before");
        this.comboBoxCountry.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.comboBoxCountry.setName("comboBoxCountry");
        this.panelCountry.add((Component)this.comboBoxCountry, "Center");
        this.panelRegistrationData.add(this.panelCountry);
        this.panelMain.add((Component)this.panelRegistrationData, "North");
        this.getContentPane().add((Component)this.panelMain, "Center");
        this.pack();
    }

    public static void main(String[] args) {
        try {
            for (UIManager.LookAndFeelInfo info : UIManager.getInstalledLookAndFeels()) {
                if (!"Nimbus".equals(info.getName())) continue;
                UIManager.setLookAndFeel(info.getClassName());
                break;
            }
        }
        catch (ClassNotFoundException ex) {
            Logger.getLogger(DialogRegistrationData.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (InstantiationException ex) {
            Logger.getLogger(DialogRegistrationData.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IllegalAccessException ex) {
            Logger.getLogger(DialogRegistrationData.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (UnsupportedLookAndFeelException ex) {
            Logger.getLogger(DialogRegistrationData.class.getName()).log(Level.SEVERE, null, ex);
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                DialogRegistrationData dialog = new DialogRegistrationData((Frame)new JFrame(), true);
                dialog.addWindowListener(new WindowAdapter(){

                    @Override
                    public void windowClosing(WindowEvent e) {
                        System.exit(0);
                    }
                });
                dialog.setVisible(true);
            }
        });
    }

    public final void customInitialization() {
        String previousName = Settings.get("registration.data.name");
        String previousEmail = Settings.get("registration.data.email");
        if (previousName != null) {
            this.textFieldName.setText(previousName);
        }
        if (previousEmail != null) {
            this.textFieldEmail.setText(previousEmail);
        }
        this.comboBoxCountry.removeAllItems();
        Locale[] locales = Locale.getAvailableLocales();
        ArrayList<Country> countries = new ArrayList<Country>();
        for (Locale locale : locales) {
            try {
                String iso = locale.getISO3Country();
                String code = locale.getCountry();
                String name = locale.getDisplayCountry();
                Country country = new Country(iso, code, name);
                if (iso == null || iso.trim().length() <= 0 || countries.contains(country)) continue;
                countries.add(country);
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
        }
        Collections.sort(countries, new CountryComparator());
        countries.add(new Country("OTH", "OH", "Other country"));
        countries.add(0, new Country("", "", "not selected"));
        String previousCountryCode = Settings.get("registration.data.country");
        for (Country country : countries) {
            this.comboBoxCountry.addItem(country);
            if (previousCountryCode == null || !previousCountryCode.equalsIgnoreCase(country.getIso())) continue;
            this.comboBoxCountry.setSelectedItem(country);
        }
        this.panelRegistrationData.remove(this.panelName);
        this.panelRegistrationData.revalidate();
        this.panelRegistrationData.repaint();
        SimpleBGC_GUIView.setProjectLink(this.labelProjectLink, "/user_registration_terms/");
    }
}

