/*
 * Decompiled with CFR 0.152.
 */
package simplebgc_gui;

import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import org.jdesktop.application.Application;
import org.jdesktop.application.ResourceMap;
import sbgc.ui.Utils;
import sbgc.utils.Log;
import sbgc.utils.Settings;
import simplebgc_gui.SimpleBGC_GUIApp;

public abstract class MyDialog
extends JDialog {
    protected Log logger = null;
    protected ResourceMap resourceMap = null;
    public static final int RES_UNKNOWN = 0;
    public static final int RES_OK = 1;
    public static final int RES_CANCEL = -1;
    public static final int RES_FAIL = -2;
    protected int result = 0;
    boolean isClosed = false;
    protected Frame parent;
    boolean isModal;
    protected String dialogName;
    public boolean centerToParent = true;

    public MyDialog(Class<?> c, Frame parent, String title) {
        this(c, parent, title, true);
    }

    public MyDialog(Class<?> c, Frame parent, String title, boolean modal) {
        super(parent, title, modal);
        this.parent = parent;
        this.isModal = modal;
        this.resourceMap = Application.getInstance(SimpleBGC_GUIApp.class).getContext().getResourceMap(c);
        this.logger = Log.getLogger(c.getName());
        this.getRootPane().registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MyDialog.this.cancelDialog();
            }
        }, KeyStroke.getKeyStroke(27, 0), 2);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                MyDialog.this.cancelDialog();
            }
        });
    }

    private int _showDialog() {
        this.setDefaultCloseOperation(0);
        this.isClosed = false;
        this.setModalityType(this.isModal ? Dialog.ModalityType.APPLICATION_MODAL : Dialog.ModalityType.MODELESS);
        this.onShowDialog();
        if (this.centerToParent) {
            this.setLocationRelativeTo(this.getParent());
        }
        this.setVisible(true);
        return this.result;
    }

    public int showDialog() {
        return this._showDialog();
    }

    public void showDialogNewThread() {
        new Thread(new Runnable(){

            @Override
            public void run() {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        MyDialog.this._showDialog();
                    }
                });
            }
        }).start();
    }

    public void closeDialog(int result) {
        if (this.onBeforeCloseDialog()) {
            this.SaveSizePos();
            this.result = result;
            this.isClosed = true;
            this.dispose();
            this.setVisible(false);
            this.logger.debug("Dialog '" + this.getTitle() + "' is closed");
            this.onCloseDialog();
        }
    }

    protected final void cancelDialog() {
        this.closeDialog(-1);
    }

    protected boolean onBeforeCloseDialog() {
        return true;
    }

    public abstract void onCloseDialog();

    protected void onShowDialog() {
    }

    public int getResult() {
        return this.result;
    }

    public boolean isCancelled() {
        return this.result == -1;
    }

    public boolean isClosed() {
        return this.isClosed;
    }

    protected void showErrorMessage(String msg) {
        JOptionPane.showMessageDialog(this.parent, msg, this.resourceMap.getString("messageDialog.error.title", new Object[0]), 0);
    }

    public void RestoreSizePos(String name) {
        try {
            this.dialogName = name;
            Dimension d = new Dimension();
            d.width = Integer.parseInt(Settings.get("window." + this.dialogName + ".width"));
            if (d.width == 0) {
                d.width = 500;
            }
            d.height = Integer.parseInt(Settings.get("window." + this.dialogName + ".height"));
            if (d.height == 0) {
                d.height = 400;
            }
            this.setPreferredSize(d);
            String xs = Settings.get("window." + this.dialogName + ".x");
            String ys = Settings.get("window." + this.dialogName + ".y");
            if (xs != null && ys != null) {
                this.centerToParent = false;
                this.setLocationRelativeTo(this.parent);
                this.setLocation(Integer.parseInt(xs), Integer.parseInt(ys));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void SaveSizePos() {
        Dimension d = this.getSize();
        Settings.set("window." + this.dialogName + ".width", Integer.toString(d.width));
        Settings.set("window." + this.dialogName + ".height", Integer.toString(d.height));
        Point p = this.getLocation();
        Settings.set("window." + this.dialogName + ".x", Integer.toString(p.x));
        Settings.set("window." + this.dialogName + ".y", Integer.toString(p.y));
        Settings.save();
    }

    public void setTooltipViewer(final JLabel label, Container forComponents) {
        MouseListener toolTipMouseListener = new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
            }

            @Override
            public void mousePressed(MouseEvent e) {
            }

            @Override
            public void mouseReleased(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                label.setText("<html>" + ((JComponent)e.getSource()).getToolTipText() + "</html>");
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }
        };
        Utils.setToolTipListener(forComponents, toolTipMouseListener);
    }
}

