/*
 * Decompiled with CFR 0.152.
 */
package simplebgc_gui;

import java.awt.Color;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JTextPane;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultHighlighter;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.Document;
import javax.swing.text.Highlighter;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyleContext;
import sbgc.script_parser.manager.CommandException;
import sbgc.script_parser.manager.ParserException;

public class ScriptHighlighter {
    public static void highlightScriptErrors(JTextPane textPane, ParserException parserException) {
        String[] cmd = textPane.getText().toString().replace("\r", "").split("\n");
        Document document = textPane.getDocument();
        textPane.setText("");
        StyleContext context = new StyleContext();
        List<CommandException> excList = null;
        int excNum = -1;
        if (parserException != null) {
            excList = parserException.getErrors();
            excNum = excList.size() - 1;
        }
        for (int i = cmd.length - 1; i >= 0; --i) {
            Color color = null;
            if (excNum >= 0 && i + 1 == excList.get(excNum).getLineNum()) {
                color = Color.RED;
                --excNum;
            } else {
                color = Color.BLACK;
            }
            Style style = context.addStyle("", null);
            StyleConstants.setForeground(style, color);
            try {
                document.insertString(0, cmd[i] + "\n", style);
                continue;
            }
            catch (BadLocationException ex) {
                Logger.getLogger(ScriptHighlighter.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    public static void highlightProgramLine(JTextPane textPane, int lineNumber) {
        String[] cmd = textPane.getText().replace("\r", "").split("\n");
        DefaultStyledDocument document = new DefaultStyledDocument();
        textPane.setDocument(document);
        StyleContext context = new StyleContext();
        for (int i = cmd.length - 1; i >= 0; --i) {
            Color color = null;
            color = i == lineNumber ? Color.BLUE : Color.BLACK;
            Style style = context.addStyle("", null);
            StyleConstants.setForeground(style, color);
            try {
                document.insertString(0, cmd[i] + "\n", style);
                continue;
            }
            catch (BadLocationException ex) {
                Logger.getLogger(ScriptHighlighter.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    public static void highlightProgramLine2(JTextPane textPane, int lineNumber) {
        Highlighter h = textPane.getHighlighter();
        h.removeAllHighlights();
        if (lineNumber > 0) {
            --lineNumber;
            String[] cmd = textPane.getText().replace("\r", "").split("\n");
            int pos = 0;
            for (int i = 0; i < cmd.length; ++i) {
                if (i == lineNumber) {
                    try {
                        h.addHighlight(pos, pos + cmd[i].length(), DefaultHighlighter.DefaultPainter);
                        textPane.setCaretPosition(pos);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    break;
                }
                pos += cmd[i].length() + 1;
            }
        }
    }
}

