/*
 * Decompiled with CFR 0.152.
 */
package simplebgc_gui.listener;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JFileChooser;
import sbgc.utils.Settings;
import simplebgc_gui.SimpleBGC_GUIApp;
import simplebgc_gui.SimpleBGC_GUIView;
import simplebgc_gui.listener.OnFileLoadedListener;
import simplebgc_gui.model.FileTypeFilter;

public class JButtonScriptLoadFileListener
implements ActionListener {
    private OnFileLoadedListener onFileLoadedListener;
    private JFileChooser fileChooser;
    private Component parent;

    public JButtonScriptLoadFileListener(Component parent, OnFileLoadedListener onFileLoadedListener) {
        this.parent = parent;
        this.onFileLoadedListener = onFileLoadedListener;
        this.fileChooser = new JFileChooser();
        this.setFileChooser();
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        int userSelection = -1;
        if (this.isLoadBtn(evt)) {
            userSelection = this.fileChooser.showOpenDialog(this.parent);
        } else if (this.isSaveBtn(evt)) {
            this.fileChooser.setSelectedFile(new File(SimpleBGC_GUIApp.getResourceMap(SimpleBGC_GUIView.class).getString("jButtonScriptSaveFile.fileName", new Object[0])));
            userSelection = this.fileChooser.showSaveDialog(this.parent);
        }
        if (userSelection != 0) {
            return;
        }
        Settings.set("scripting.last_used_script_dir", this.fileChooser.getCurrentDirectory().getPath());
        Settings.save();
        this.onFileLoadedListener.onFileLoaded(this.fileChooser.getSelectedFile().getAbsolutePath());
    }

    private void setFileChooser() {
        String lastDir = Settings.get("scripting.last_used_script_dir");
        if (lastDir != null) {
            this.fileChooser.setCurrentDirectory(new File(lastDir));
        }
        this.fileChooser.setMultiSelectionEnabled(false);
        this.fileChooser.setAcceptAllFileFilterUsed(false);
        this.fileChooser.setFileFilter(new FileTypeFilter(SimpleBGC_GUIApp.getResourceMap(SimpleBGC_GUIView.class).getString("jButtonScriptSaveFile.fileExt", new Object[0]), SimpleBGC_GUIApp.getResourceMap(SimpleBGC_GUIView.class).getString("jButtonScriptSaveFile.fileDesc", new Object[0])));
    }

    private boolean isLoadBtn(ActionEvent evt) {
        return evt.getActionCommand().equalsIgnoreCase(SimpleBGC_GUIApp.getResourceMap(SimpleBGC_GUIView.class).getString("jButtonScriptLoadFile.text", new Object[0]));
    }

    private boolean isSaveBtn(ActionEvent evt) {
        return evt.getActionCommand().equalsIgnoreCase(SimpleBGC_GUIApp.getResourceMap(SimpleBGC_GUIView.class).getString("jButtonScriptSaveFile.text", new Object[0]));
    }
}

