/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.essentials.internal.parsing.ejbql;

import java.util.ArrayList;
import java.util.List;
import oracle.toplink.essentials.exceptions.EJBQLException;
import oracle.toplink.essentials.internal.parsing.EJBQLParseTree;
import oracle.toplink.essentials.internal.parsing.NodeFactory;
import oracle.toplink.essentials.internal.parsing.NodeFactoryImpl;
import oracle.toplink.essentials.internal.parsing.ejbql.antlr273.EJBQLParserBuilder;
import persistence.antlr.ANTLRException;
import persistence.antlr.LLkParser;
import persistence.antlr.MismatchedCharException;
import persistence.antlr.MismatchedTokenException;
import persistence.antlr.NoViableAltException;
import persistence.antlr.NoViableAltForCharException;
import persistence.antlr.ParserSharedInputState;
import persistence.antlr.RecognitionException;
import persistence.antlr.Token;
import persistence.antlr.TokenBuffer;
import persistence.antlr.TokenStream;
import persistence.antlr.TokenStreamException;
import persistence.antlr.TokenStreamRecognitionException;

public abstract class EJBQLParser
extends LLkParser {
    private static final int EOF_CHAR = 65535;
    private List errors = new ArrayList();
    private String queryName = null;
    private String queryText = null;
    protected NodeFactory factory;

    protected EJBQLParser(TokenBuffer tokenBuf, int k_) {
        super(tokenBuf, k_);
    }

    protected EJBQLParser(ParserSharedInputState state, int k_) {
        super(state, k_);
    }

    protected EJBQLParser(TokenStream lexer, int k) {
        super(lexer, k);
    }

    public static String ANTLRVersion() throws Exception {
        return "2.7.3";
    }

    public static EJBQLParseTree buildParseTree(String queryText) throws EJBQLException {
        return EJBQLParser.buildParseTree(null, queryText);
    }

    public static EJBQLParseTree buildParseTree(String queryName, String queryText) throws EJBQLException {
        EJBQLParser parser = EJBQLParser.buildParserFor(queryName, queryText);
        return parser.parse();
    }

    public static EJBQLParser buildParserFor(String queryText) throws EJBQLException {
        return EJBQLParser.buildParserFor(null, queryText);
    }

    public static EJBQLParser buildParserFor(String queryName, String queryText) throws EJBQLException {
        try {
            oracle.toplink.essentials.internal.parsing.ejbql.antlr273.EJBQLParser parser = EJBQLParserBuilder.buildParser(queryText);
            parser.setQueryName(queryName);
            parser.setQueryText(queryText);
            parser.setNodeFactory(new NodeFactoryImpl(parser.getQueryInfo()));
            return parser;
        }
        catch (Exception ex) {
            throw EJBQLException.generalParsingException(queryText, ex);
        }
    }

    public EJBQLParseTree parse() throws EJBQLException {
        try {
            this.document();
        }
        catch (Exception e) {
            this.addError(e);
        }
        if (this.hasErrors()) {
            throw this.generateException();
        }
        return this.getParseTree();
    }

    public EJBQLParseTree getParseTree() {
        return (EJBQLParseTree)this.getRootNode();
    }

    public String getQueryText() {
        return this.queryText;
    }

    public void setQueryText(String queryText) {
        this.queryText = queryText;
    }

    public String getQueryName() {
        return this.queryText;
    }

    public void setQueryName(String queryName) {
        this.queryName = queryName;
    }

    public String getQueryInfo() {
        return this.queryName == null ? this.queryText : this.queryName + ": " + this.queryText;
    }

    public void setNodeFactory(NodeFactory factory) {
        this.factory = factory;
    }

    public NodeFactory getNodeFactory() {
        return this.factory;
    }

    public List getErrors() {
        return this.errors;
    }

    public boolean hasErrors() {
        return !this.getErrors().isEmpty();
    }

    public void addError(Exception e) {
        if (e instanceof ANTLRException) {
            e = this.handleANTLRException((ANTLRException)e);
        } else if (!(e instanceof EJBQLException)) {
            e = EJBQLException.generalParsingException(this.getQueryInfo(), e);
        }
        this.errors.add(e);
    }

    protected EJBQLException generateException() {
        Exception firstException = (Exception)this.getErrors().get(0);
        if (firstException instanceof EJBQLException) {
            return (EJBQLException)firstException;
        }
        EJBQLException exception = EJBQLException.generalParsingException(this.getQueryInfo());
        exception.setInternalExceptions(this.getErrors());
        return exception;
    }

    protected EJBQLException handleANTLRException(ANTLRException ex) {
        EJBQLException result = null;
        if (ex instanceof MismatchedCharException) {
            MismatchedCharException mismatched = (MismatchedCharException)ex;
            if (mismatched.foundChar == 65535) {
                result = EJBQLException.unexpectedEOF(this.getQueryInfo(), mismatched.getLine(), mismatched.getColumn(), ex);
            } else if (mismatched.mismatchType == 1) {
                result = EJBQLException.expectedCharFound(this.getQueryInfo(), mismatched.getLine(), mismatched.getColumn(), String.valueOf((char)mismatched.expecting), String.valueOf((char)mismatched.foundChar), ex);
            }
        } else if (ex instanceof MismatchedTokenException) {
            MismatchedTokenException mismatched = (MismatchedTokenException)ex;
            Token token = mismatched.token;
            if (token != null) {
                result = token.getType() == 1 ? EJBQLException.unexpectedEOF(this.getQueryInfo(), mismatched.getLine(), mismatched.getColumn(), ex) : EJBQLException.syntaxErrorAt(this.getQueryInfo(), mismatched.getLine(), mismatched.getColumn(), token.getText(), ex);
            }
        } else if (ex instanceof NoViableAltException) {
            NoViableAltException noviable = (NoViableAltException)ex;
            Token token = noviable.token;
            if (token != null) {
                result = token.getType() == 1 ? EJBQLException.unexpectedEOF(this.getQueryInfo(), noviable.getLine(), noviable.getColumn(), ex) : EJBQLException.unexpectedToken(this.getQueryInfo(), noviable.getLine(), noviable.getColumn(), token.getText(), ex);
            }
        } else if (ex instanceof NoViableAltForCharException) {
            NoViableAltForCharException noViableAlt = (NoViableAltForCharException)ex;
            result = EJBQLException.unexpectedChar(this.getQueryInfo(), noViableAlt.getLine(), noViableAlt.getColumn(), String.valueOf(noViableAlt.foundChar), ex);
        } else if (ex instanceof TokenStreamRecognitionException) {
            result = this.handleANTLRException(((TokenStreamRecognitionException)ex).recog);
        }
        if (result == null) {
            result = EJBQLException.syntaxError(this.getQueryInfo(), ex);
        }
        return result;
    }

    public void reportError(RecognitionException ex) {
        this.addError(ex);
    }

    public abstract void document() throws RecognitionException, TokenStreamException;

    public abstract Object getRootNode();
}

