/*
 * Decompiled with CFR 0.152.
 */
package org.jzy3d.bridge.newt.controllers.mouse;

import com.jogamp.newt.event.MouseEvent;
import com.jogamp.newt.event.MouseListener;
import java.awt.Component;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import org.jzy3d.bridge.newt.controllers.AWTToNewtUtilities;

public class AWTToNewtMouseListener
implements MouseListener {
    private final java.awt.event.MouseListener mouseListener;
    private final MouseMotionListener mouseMotionListener;
    private final MouseWheelListener mouseWheelListener;
    private final Component source;

    public AWTToNewtMouseListener(Component source, java.awt.event.MouseListener mouseListener, MouseMotionListener mouseMotionListener, MouseWheelListener mouseWheelListener) {
        this.source = source;
        this.mouseListener = mouseListener;
        this.mouseMotionListener = mouseMotionListener;
        this.mouseWheelListener = mouseWheelListener;
    }

    protected java.awt.event.MouseEvent convertEvent(MouseEvent event, int id) {
        return new java.awt.event.MouseEvent(this.source, id, event.getWhen(), AWTToNewtUtilities.mask(event), event.getX(), event.getY(), event.getClickCount(), false, event.getButton());
    }

    protected MouseWheelEvent convertWheelEvent(MouseEvent event, int id) {
        int direction = event.getRotation()[1] > 0.0f ? -1 : 1;
        int units = Math.round(event.getRotation()[1] * event.getRotationScale());
        return new MouseWheelEvent(this.source, id, event.getWhen(), AWTToNewtUtilities.mask(event), event.getX(), event.getY(), (int)event.getClickCount(), false, 0, units, direction);
    }

    public void mouseClicked(MouseEvent me) {
        if (this.mouseListener != null) {
            this.mouseListener.mouseClicked(this.convertEvent(me, 500));
        }
    }

    public void mouseEntered(MouseEvent me) {
        if (this.mouseListener != null) {
            this.mouseListener.mouseEntered(this.convertEvent(me, 504));
        }
    }

    public void mouseExited(MouseEvent me) {
        if (this.mouseListener != null) {
            this.mouseListener.mouseExited(this.convertEvent(me, 505));
        }
    }

    public void mousePressed(MouseEvent me) {
        if (this.mouseListener != null) {
            this.mouseListener.mousePressed(this.convertEvent(me, 501));
        }
    }

    public void mouseReleased(MouseEvent me) {
        if (this.mouseListener != null) {
            this.mouseListener.mouseReleased(this.convertEvent(me, 502));
        }
    }

    public void mouseMoved(MouseEvent me) {
        if (this.mouseMotionListener != null) {
            this.mouseMotionListener.mouseMoved(this.convertEvent(me, 503));
        }
    }

    public void mouseDragged(MouseEvent me) {
        if (this.mouseMotionListener != null) {
            this.mouseMotionListener.mouseDragged(this.convertEvent(me, 506));
        }
    }

    public void mouseWheelMoved(MouseEvent me) {
        if (this.mouseWheelListener != null) {
            this.mouseWheelListener.mouseWheelMoved(this.convertWheelEvent(me, 507));
        }
    }
}

