/*
 * Decompiled with CFR 0.152.
 */
package org.jzy3d.chart.controllers.mouse.picking;

import com.jogamp.opengl.GL;
import com.jogamp.opengl.glu.GLU;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import org.jzy3d.chart.Chart;
import org.jzy3d.chart.controllers.camera.AbstractCameraController;
import org.jzy3d.chart.controllers.mouse.AWTMouseUtilities;
import org.jzy3d.chart.controllers.mouse.picking.IMousePickingController;
import org.jzy3d.chart.controllers.thread.camera.CameraThreadController;
import org.jzy3d.maths.Coord2d;
import org.jzy3d.maths.Coord3d;
import org.jzy3d.maths.IntegerCoord2d;
import org.jzy3d.picking.PickingSupport;
import org.jzy3d.plot3d.rendering.scene.Graph;
import org.jzy3d.plot3d.rendering.view.View;

public class AWTMousePickingController
extends AbstractCameraController
implements MouseListener,
MouseWheelListener,
IMousePickingController {
    protected float factor = 1.0f;
    protected float lastInc;
    protected Coord3d mouse3d;
    protected Coord3d prevMouse3d;
    protected PickingSupport picking;
    protected GLU glu = new GLU();
    protected Chart chart;
    protected Coord2d prevMouse;
    protected CameraThreadController threadController;

    public AWTMousePickingController() {
        this.picking = new PickingSupport();
    }

    public AWTMousePickingController(Chart chart) {
        super(chart);
        chart.getCanvas().addMouseController(this);
        this.picking = new PickingSupport();
    }

    public AWTMousePickingController(Chart chart, int brushSize) {
        super(chart);
        chart.getCanvas().addMouseController(this);
        this.picking = new PickingSupport(brushSize);
    }

    public AWTMousePickingController(Chart chart, int brushSize, int bufferSize) {
        super(chart);
        chart.getCanvas().addMouseController(this);
        this.picking = new PickingSupport(brushSize, bufferSize);
    }

    @Override
    public void register(Chart chart) {
        super.register(chart);
        this.chart = chart;
        this.prevMouse = Coord2d.ORIGIN;
        chart.getCanvas().addMouseController(this);
    }

    @Override
    public void dispose() {
        for (Chart c : this.targets) {
            c.getCanvas().removeMouseController(this);
        }
        if (this.threadController != null) {
            this.threadController.stop();
        }
        super.dispose();
    }

    @Override
    public PickingSupport getPickingSupport() {
        return this.picking;
    }

    @Override
    public void setPickingSupport(PickingSupport picking) {
        this.picking = picking;
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    public void mouseDragged(MouseEvent e) {
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent e) {
        if (this.threadController != null) {
            this.threadController.stop();
        }
        float factor = 1.0f + (float)e.getWheelRotation() / 10.0f;
        this.zoomX(factor);
        this.zoomY(factor);
        this.chart.getView().shoot();
    }

    public void mouseMoved(MouseEvent e) {
        this.pick(e);
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (this.handleSlaveThread(e)) {
            return;
        }
        this.pick(e);
    }

    public void pick(MouseEvent e) {
        int yflip = -e.getY() + ((Chart)this.targets.get(0)).getCanvas().getRendererHeight();
        this.prevMouse.x = e.getX();
        this.prevMouse.y = e.getY();
        View view = ((Chart)this.targets.get(0)).getView();
        this.prevMouse3d = view.projectMouse(e.getX(), yflip);
        GL gl = this.chart().getView().getCurrentGL();
        Graph graph = this.chart().getScene().getGraph();
        this.picking.pickObjects(gl, this.glu, view, graph, new IntegerCoord2d(e.getX(), yflip));
    }

    public boolean handleSlaveThread(MouseEvent e) {
        if (AWTMouseUtilities.isDoubleClick(e) && this.threadController != null) {
            this.threadController.start();
            return true;
        }
        if (this.threadController != null) {
            this.threadController.stop();
        }
        return false;
    }
}

