/*
 * Decompiled with CFR 0.152.
 */
package org.jzy3d.chart.controllers.mouse.picking;

import com.jogamp.newt.event.MouseEvent;
import com.jogamp.newt.event.MouseListener;
import com.jogamp.opengl.GL;
import com.jogamp.opengl.glu.GLU;
import org.jzy3d.chart.Chart;
import org.jzy3d.chart.controllers.camera.AbstractCameraController;
import org.jzy3d.chart.controllers.mouse.NewtMouseUtilities;
import org.jzy3d.chart.controllers.mouse.picking.IMousePickingController;
import org.jzy3d.chart.controllers.thread.camera.CameraThreadController;
import org.jzy3d.maths.Coord2d;
import org.jzy3d.maths.Coord3d;
import org.jzy3d.maths.IntegerCoord2d;
import org.jzy3d.picking.PickingSupport;
import org.jzy3d.plot3d.rendering.scene.Graph;
import org.jzy3d.plot3d.rendering.view.View;

public class NewtMousePickingController
extends AbstractCameraController
implements MouseListener,
IMousePickingController {
    protected float factor = 1.0f;
    protected float lastInc;
    protected Coord3d mouse3d;
    protected Coord3d prevMouse3d;
    protected PickingSupport picking;
    protected GLU glu = new GLU();
    protected Chart chart;
    protected Coord2d prevMouse;
    protected CameraThreadController threadController;

    public NewtMousePickingController() {
        this.picking = new PickingSupport();
    }

    public NewtMousePickingController(Chart chart) {
        super(chart);
        this.picking = new PickingSupport();
    }

    public NewtMousePickingController(Chart chart, int brushSize) {
        super(chart);
        this.picking = new PickingSupport(brushSize);
    }

    public NewtMousePickingController(Chart chart, int brushSize, int bufferSize) {
        super(chart);
        this.picking = new PickingSupport(brushSize, bufferSize);
    }

    @Override
    public void register(Chart chart) {
        super.register(chart);
        this.chart = chart;
        this.prevMouse = Coord2d.ORIGIN;
        chart.getCanvas().addMouseController(this);
    }

    @Override
    public void dispose() {
        for (Chart c : this.targets) {
            c.getCanvas().removeMouseController(this);
        }
        if (this.threadController != null) {
            this.threadController.stop();
        }
        super.dispose();
    }

    @Override
    public PickingSupport getPickingSupport() {
        return this.picking;
    }

    @Override
    public void setPickingSupport(PickingSupport picking) {
        this.picking = picking;
    }

    public void mouseClicked(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mouseReleased(MouseEvent e) {
    }

    public void mouseDragged(MouseEvent e) {
    }

    public void mouseWheelMoved(MouseEvent e) {
        if (this.threadController != null) {
            this.threadController.stop();
        }
        float factor = NewtMouseUtilities.convertWheelRotation(e, 1.0f, 10.0f);
        this.zoomX(factor);
        this.zoomY(factor);
        this.chart.getView().shoot();
    }

    public void mouseMoved(MouseEvent e) {
        this.pick(e);
    }

    public void mousePressed(MouseEvent e) {
        if (this.handleSlaveThread(e)) {
            return;
        }
        this.pick(e);
    }

    protected void pick(MouseEvent e) {
        int x = e.getX();
        int y = e.getY();
        this.pick(x, y);
    }

    protected void pick(int x, int y) {
        int yflip = -y + ((Chart)this.targets.get(0)).getCanvas().getRendererHeight();
        this.prevMouse.x = x;
        this.prevMouse.y = y;
        View view = ((Chart)this.targets.get(0)).getView();
        this.prevMouse3d = view.projectMouse(x, yflip);
        GL gl = this.chart().getView().getCurrentGL();
        Graph graph = this.chart().getScene().getGraph();
        this.picking.pickObjects(gl, this.glu, view, graph, new IntegerCoord2d(x, yflip));
    }

    public boolean handleSlaveThread(MouseEvent e) {
        if (NewtMouseUtilities.isDoubleClick(e) && this.threadController != null) {
            this.threadController.start();
            return true;
        }
        if (this.threadController != null) {
            this.threadController.stop();
        }
        return false;
    }
}

