/*
 * Decompiled with CFR 0.152.
 */
package org.jzy3d.colors;

import org.jzy3d.colors.Color;
import org.jzy3d.colors.IColorMappable;
import org.jzy3d.colors.colormaps.IColorMap;
import org.jzy3d.maths.Coord3d;
import org.jzy3d.maths.Range;
import org.jzy3d.maths.Scale;

public class ColorMapper
implements IColorMappable {
    protected double min;
    protected double max;
    protected IColorMap colormap;
    protected Color factor = null;

    public ColorMapper() {
    }

    public ColorMapper(IColorMap colormap, Color factor) {
        this.colormap = colormap;
        this.factor = factor;
        this.min = 0.0;
        this.max = 1.0;
    }

    public ColorMapper(IColorMap colormap, double min, double max) {
        this.colormap = colormap;
        this.min = min;
        this.max = max;
    }

    public ColorMapper(IColorMap colormap, Range range) {
        this.colormap = colormap;
        this.min = range.getMin();
        this.max = range.getMax();
    }

    public ColorMapper(IColorMap colormap, double min, double max, Color factor) {
        this.colormap = colormap;
        this.min = min;
        this.max = max;
        this.factor = factor;
    }

    public ColorMapper(ColorMapper colormapper, Color factor) {
        this.colormap = colormapper.colormap;
        this.min = colormapper.min;
        this.max = colormapper.max;
        this.factor = factor;
    }

    public Color getColor(Coord3d coord) {
        Color out = this.colormap.getColor(this, coord.x, coord.y, coord.z);
        if (this.factor != null) {
            out.mul(this.factor);
        }
        return out;
    }

    public Color getColor(double v) {
        Color out = this.colormap.getColor(this, v);
        if (this.factor != null) {
            out.mul(this.factor);
        }
        return out;
    }

    public void preDraw(Object o) {
    }

    public void postDraw(Object o) {
    }

    public IColorMap getColorMap() {
        return this.colormap;
    }

    @Override
    public double getMin() {
        return this.min;
    }

    @Override
    public double getMax() {
        return this.max;
    }

    @Override
    public void setMin(double value) {
        this.min = value;
    }

    @Override
    public void setMax(double value) {
        this.max = value;
    }

    public void setRange(Range range) {
        this.min = range.getMin();
        this.max = range.getMax();
    }

    public Range getRange() {
        return new Range((float)this.min, (float)this.max);
    }

    public void setScale(Scale range) {
        this.min = range.getMin();
        this.max = range.getMax();
    }

    public Scale getScale() {
        return new Scale((float)this.min, (float)this.max);
    }

    public String toString() {
        return "(ColorMapper)" + this.colormap + " min:" + this.min + " max:" + this.max + " factor:" + this.factor;
    }
}

