/*
 * Decompiled with CFR 0.152.
 */
package org.jzy3d.io.matlab;

import com.jmatio.io.MatFileReader;
import com.jmatio.types.MLNumericArray;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.jzy3d.io.ILoader;
import org.jzy3d.maths.Coord3d;
import org.jzy3d.maths.TicToc;
import org.jzy3d.plot3d.primitives.AbstractDrawable;
import org.jzy3d.plot3d.primitives.Point;
import org.jzy3d.plot3d.primitives.enlightables.EnlightablePolygon;

public class MatlabDrawableLoader
implements ILoader {
    protected static int C1 = 0;
    protected static int C2 = 1;
    protected static int C3 = 2;

    @Override
    public List<AbstractDrawable> load(String filename) throws Exception {
        return this.load(filename, -1);
    }

    public List<AbstractDrawable> load(String filename, int limit) throws Exception {
        TicToc t = new TicToc();
        t.tic();
        MatFileReader mfr = new MatFileReader(filename);
        Logger.getLogger(MatlabDrawableLoader.class).info((Object)(t.toc() + " to read " + filename));
        Logger.getLogger(MatlabDrawableLoader.class).info((Object)("Containing arrays: " + mfr.getContent().keySet()));
        MLNumericArray x = (MLNumericArray)mfr.getMLArray("X");
        MLNumericArray y = (MLNumericArray)mfr.getMLArray("Y");
        MLNumericArray z = (MLNumericArray)mfr.getMLArray("Z");
        ArrayList<AbstractDrawable> polygons = new ArrayList<AbstractDrawable>();
        int n = x.getN();
        if (limit > 0) {
            n = Math.min(n, limit);
        }
        t.tic();
        for (int i = 0; i < n; ++i) {
            try {
                Coord3d coord1 = new Coord3d(((Float)x.getReal(C1, i)).floatValue(), ((Float)y.getReal(C1, i)).floatValue(), ((Float)z.getReal(C1, i)).floatValue());
                Coord3d coord2 = new Coord3d(((Float)x.getReal(C2, i)).floatValue(), ((Float)y.getReal(C2, i)).floatValue(), ((Float)z.getReal(C2, i)).floatValue());
                Coord3d coord3 = new Coord3d(((Float)x.getReal(C3, i)).floatValue(), ((Float)y.getReal(C3, i)).floatValue(), ((Float)z.getReal(C3, i)).floatValue());
                Point point1 = new Point(coord1);
                Point point2 = new Point(coord2);
                Point point3 = new Point(coord3);
                EnlightablePolygon polygon = new EnlightablePolygon();
                polygon.add(point1);
                polygon.add(point2);
                polygon.add(point3);
                polygons.add(polygon);
                continue;
            }
            catch (Exception e) {
                throw new Exception("failed at line " + i + "/" + n, e);
            }
        }
        Logger.getLogger(MatlabDrawableLoader.class).info((Object)(t.toc() + " to build polygon list"));
        return polygons;
    }
}

