/*
 * Decompiled with CFR 0.152.
 */
package org.jzy3d.maths.algorithms.convexhull;

import java.util.ArrayDeque;
import java.util.Deque;
import org.jzy3d.maths.Coord2d;
import org.jzy3d.maths.algorithms.convexhull.ConvexHullFunction;
import org.jzy3d.maths.algorithms.convexhull.algorithms.RadialComparator;
import org.jzy3d.maths.algorithms.convexhull.utils.QuickSort;

public class GrahamScan
implements ConvexHullFunction {
    @Override
    public Deque<Coord2d> getConvexHull(Coord2d[] pts) {
        Coord2d p;
        this.preSort(pts);
        RadialComparator c = new RadialComparator(pts[0]);
        ArrayDeque<Coord2d> s = new ArrayDeque<Coord2d>();
        s.push(pts[pts.length - 1]);
        s.push(pts[0]);
        s.push(pts[1]);
        for (int i = 2; i < pts.length - 1; ++i) {
            p = (Coord2d)s.pop();
            c.setOrigin((Coord2d)s.peek());
            while (c.compare(p, pts[i]) > 0) {
                p = (Coord2d)s.pop();
                c.setOrigin((Coord2d)s.peek());
            }
            s.push(p);
            s.push(pts[i]);
        }
        p = (Coord2d)s.pop();
        c.setOrigin((Coord2d)s.peek());
        if (c.compare(p, pts[pts.length - 1]) <= 0) {
            s.push(p);
        }
        s.push(pts[pts.length - 1]);
        return s;
    }

    private Coord2d[] preSort(Coord2d[] pts) {
        for (int i = 1; i < pts.length; ++i) {
            if (!(pts[i].getY() < pts[0].getY()) && (pts[i].getY() != pts[0].getY() || !(pts[i].getX() < pts[0].getX()))) continue;
            Coord2d t = pts[0];
            pts[0] = pts[i];
            pts[i] = t;
        }
        QuickSort.sort(pts, new RadialComparator(pts[0]));
        return pts;
    }
}

