/*
 * Decompiled with CFR 0.152.
 */
package org.jzy3d.maths.algorithms.convexhull;

import java.util.ArrayDeque;
import java.util.Deque;
import org.jzy3d.maths.Coord2d;
import org.jzy3d.maths.algorithms.convexhull.ConvexHullFunction;
import org.jzy3d.maths.algorithms.convexhull.algorithms.XYComparator;
import org.jzy3d.maths.algorithms.convexhull.utils.QuickSort;

public class JarvisMarch
implements ConvexHullFunction {
    @Override
    public Deque<Coord2d> getConvexHull(Coord2d[] Q) {
        int i;
        QuickSort.sort(Q, new XYComparator());
        int lowest = 0;
        int highest = Q.length - 1;
        int n = 0;
        ArrayDeque<Integer> collinear = new ArrayDeque<Integer>();
        boolean pass = true;
        ArrayDeque<Coord2d> S = new ArrayDeque<Coord2d>();
        S.push(Q[0]);
        while (n < highest) {
            for (i = ++n + 1; i <= Q.length - 1; ++i) {
                if (this.crossProduct((Coord2d)S.peek(), Q[n], Q[i]) < 0.0) {
                    pass = false;
                    break;
                }
                if (this.crossProduct((Coord2d)S.peek(), Q[n], Q[i]) != 0.0) continue;
                collinear.push(i);
            }
            if (pass) {
                if (!collinear.isEmpty()) {
                    n = (Integer)collinear.pop();
                }
                S.push(Q[n]);
            }
            while (!collinear.isEmpty()) {
                collinear.pop();
            }
            pass = true;
        }
        while (n > lowest) {
            for (i = --n - 1; i >= 0; --i) {
                if (this.crossProduct(Q[n], (Coord2d)S.peek(), Q[i]) > 0.0) {
                    pass = false;
                    break;
                }
                if (this.crossProduct(Q[n], (Coord2d)S.peek(), Q[i]) != 0.0) continue;
                collinear.push(i);
            }
            if (pass) {
                if (!collinear.isEmpty()) {
                    n = (Integer)collinear.pop();
                }
                S.push(Q[n]);
            }
            while (!collinear.isEmpty()) {
                collinear.pop();
            }
            pass = true;
        }
        return S;
    }

    private double crossProduct(Coord2d p1, Coord2d p2, Coord2d p3) {
        return (p2.getX() - p1.getX()) * (p3.getY() - p1.getY()) - (p3.getX() - p1.getX()) * (p2.getY() - p1.getY());
    }
}

