/*
 * Decompiled with CFR 0.152.
 */
package org.jzy3d.plot2d.primitives;

import org.jzy3d.chart.Chart;
import org.jzy3d.colors.Color;
import org.jzy3d.maths.Coord3d;
import org.jzy3d.maths.Histogram;
import org.jzy3d.maths.Range;
import org.jzy3d.plot3d.primitives.AbstractComposite;
import org.jzy3d.plot3d.primitives.Point;
import org.jzy3d.plot3d.primitives.Polygon;
import org.jzy3d.plot3d.primitives.axes.layout.IAxeLayout;
import org.jzy3d.plot3d.primitives.axes.layout.providers.StaticTickProvider;

public class Histogram2d {
    protected Histogram model;
    protected AbstractComposite drawable;
    String ylabel = "Count";
    String xlabel = "Value";

    public Histogram2d(Histogram model) {
        this.setModel(model);
    }

    public Histogram2d(Histogram model, String xlabel, String ylabel) {
        this(model);
        this.ylabel = ylabel;
        this.xlabel = xlabel;
    }

    public void layout(Chart chart) {
        IAxeLayout layout = chart.getAxeLayout();
        int ymax = this.getModel().computeMaxCount();
        double[] ticks = new double[]{0.0, ymax / 4, ymax / 2, ymax / 2 + ymax / 4, ymax};
        layout.setYTickProvider(new StaticTickProvider(ticks));
        layout.setYAxeLabel(this.ylabel);
        layout.setXAxeLabel(this.xlabel);
    }

    public void addTo(Chart chart) {
        chart.add(this.drawable);
        this.layout(chart);
    }

    public void setModel(Histogram model) {
        this.model = model;
        this.drawable = this.buildDrawable(model);
    }

    public Histogram getModel() {
        return this.model;
    }

    public AbstractComposite getDrawable() {
        return this.drawable;
    }

    protected AbstractComposite buildDrawable(Histogram model) {
        AbstractComposite c = new AbstractComposite(){};
        for (int i = 0; i < model.ranges().length; ++i) {
            Range range = model.ranges()[i];
            int count = model.getCount(i);
            Polygon p = this.makeCountBar(range, count);
            c.add(p);
        }
        return c;
    }

    private Polygon makeCountBar(Range range, int count) {
        float z = 0.0f;
        Coord3d c1 = new Coord3d(range.getMin(), 0.0f, z);
        Coord3d c2 = new Coord3d(range.getMin(), count, z);
        Coord3d c3 = new Coord3d(range.getMax(), count, z);
        Coord3d c4 = new Coord3d(range.getMax(), 0.0f, z);
        Polygon p = new Polygon();
        p.add(new Point(c1));
        p.add(new Point(c2));
        p.add(new Point(c3));
        p.add(new Point(c4));
        p.setColor(Color.MAGENTA);
        p.setWireframeColor(Color.WHITE);
        return p;
    }
}

