/*
 * Decompiled with CFR 0.152.
 */
package org.jzy3d.plot2d.primitives;

import java.util.List;
import org.jzy3d.colors.Color;
import org.jzy3d.maths.Coord2d;
import org.jzy3d.maths.Coord3d;
import org.jzy3d.plot2d.primitives.Serie2d;
import org.jzy3d.plot3d.primitives.AbstractDrawable;
import org.jzy3d.plot3d.primitives.ConcurrentScatterPoint;
import org.jzy3d.plot3d.primitives.LightPoint;

public class ScatterPointSerie2d
implements Serie2d {
    protected ConcurrentScatterPoint scatter;
    protected String name;
    protected Color defaultColor = Color.YELLOW.clone();

    public ScatterPointSerie2d(String name) {
        this.name = name;
        this.scatter = this.makeDrawable();
    }

    public ConcurrentScatterPoint getScatter() {
        return this.scatter;
    }

    public void setScatter(ConcurrentScatterPoint scatter) {
        this.scatter = scatter;
    }

    public void setName(String name) {
        this.name = name;
    }

    protected ConcurrentScatterPoint makeDrawable() {
        ConcurrentScatterPoint s = new ConcurrentScatterPoint();
        s.setWidth(3.0f);
        return s;
    }

    @Override
    public void add(float x, float y) {
        this.scatter.add(new LightPoint(new Coord3d(x, y, 0.0f), this.defaultColor));
    }

    @Override
    public void add(double x, double y) {
        this.scatter.add(new LightPoint(new Coord3d(x, y, 0.0), this.defaultColor));
    }

    @Override
    public void add(Coord2d c) {
        this.scatter.add(new LightPoint(new Coord3d(c.x, c.y, 0.0f), this.defaultColor));
    }

    @Override
    public void add(Coord2d c, Color color) {
        this.scatter.add(new LightPoint(new Coord3d(c.x, c.y, 0.0f), color));
    }

    @Override
    public void add(float x, float y, Color color) {
        this.scatter.add(new LightPoint(new Coord3d(x, y, 0.0f), color));
    }

    @Override
    public void add(double x, double y, Color color) {
        this.scatter.add(new LightPoint(new Coord3d(x, y, 0.0), color));
    }

    @Override
    public void add(List<Coord2d> c) {
        for (Coord2d c2 : c) {
            this.scatter.add(new LightPoint(new Coord3d(c2.x, c2.y, 0.0f), this.defaultColor));
        }
    }

    @Override
    public void setColor(Color color) {
        this.defaultColor = color;
    }

    @Override
    public Color getColor() {
        return this.defaultColor;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public AbstractDrawable getDrawable() {
        return this.scatter;
    }

    @Override
    public void clear() {
        this.scatter.clear();
    }

    @Override
    public void setWidth(int width) {
        this.scatter.setWidth(width);
    }
}

