/*
 * Decompiled with CFR 0.152.
 */
package org.jzy3d.plot3d.builder;

import org.jzy3d.maths.TicToc;
import org.jzy3d.maths.Utils;
import org.jzy3d.plot3d.builder.SingleParameterMapper;
import org.jzy3d.plot3d.primitives.Shape;

public abstract class AbstractRemapTask
implements Runnable {
    protected SingleParameterMapper mapper;
    protected String info;
    protected TicToc time = new TicToc();
    protected Shape surface;

    public AbstractRemapTask(Shape surface, SingleParameterMapper mapper) {
        this.surface = surface;
        this.mapper = mapper;
        this.info = "n/a";
    }

    public abstract void remap();

    @Override
    public void run() {
        while (true) {
            try {
                Thread.sleep(1L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.time.tic();
            this.remap();
            this.time.toc();
            this.info = Utils.num2str(this.time.elapsedSecond(), 4) + "s to remap surface";
        }
    }

    public Shape getSurface() {
        return this.surface;
    }

    public void setSurface(Shape surface) {
        this.surface = surface;
    }

    public SingleParameterMapper getMapper() {
        return this.mapper;
    }

    public void setMapper(SingleParameterMapper mapper) {
        this.mapper = mapper;
    }

    public String getInfo() {
        return this.info;
    }

    public void setInfo(String info) {
        this.info = info;
    }
}

