/*
 * Decompiled with CFR 0.152.
 */
package org.jzy3d.plot3d.builder.concrete;

import java.util.ArrayList;
import java.util.List;
import org.jzy3d.maths.Coord3d;
import org.jzy3d.maths.Range;
import org.jzy3d.plot3d.builder.Mapper;
import org.jzy3d.plot3d.builder.concrete.OrthonormalGrid;

public class RingGrid
extends OrthonormalGrid {
    protected double sqradius;
    protected static final int ENLARGE_STEP = 3;

    public RingGrid(float radius, int xysteps) {
        this(radius, xysteps, 0);
    }

    public RingGrid(float radius, int xysteps, int enlargeSteps) {
        super(new Range(-radius - (float)enlargeSteps * radius / (float)xysteps, radius + (float)enlargeSteps * radius / (float)xysteps), xysteps);
        this.sqradius = (radius + (float)enlargeSteps * radius / (float)xysteps) * (radius + (float)enlargeSteps * radius / (float)xysteps);
    }

    @Override
    public List<Coord3d> apply(Mapper mapper) {
        double xstep = (double)this.xrange.getRange() / (double)this.xsteps;
        double ystep = (double)this.yrange.getRange() / (double)this.ysteps;
        ArrayList<Coord3d> output = new ArrayList<Coord3d>((this.xsteps - 1) * (this.ysteps - 1));
        for (int xi = -(this.xsteps - 1) / 2; xi <= (this.xsteps - 1) / 2; ++xi) {
            for (int yi = -(this.ysteps - 1) / 2; yi <= (this.ysteps - 1) / 2; ++yi) {
                double xval = (double)xi * xstep;
                double yval = (double)yi * ystep;
                if (!(this.sqradius >= xval * xval + yval * yval)) continue;
                output.add(new Coord3d(xval, yval, mapper.f(xval, yval)));
            }
        }
        return output;
    }
}

