/*
 * Decompiled with CFR 0.152.
 */
package org.jzy3d.plot3d.builder.delaunay;

import il.ac.idc.jdt.DelaunayTriangulation;
import il.ac.idc.jdt.Triangle;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.jzy3d.maths.Coord3d;
import org.jzy3d.plot3d.builder.Tessellator;
import org.jzy3d.plot3d.builder.delaunay.JDTConverter;
import org.jzy3d.plot3d.primitives.AbstractComposite;
import org.jzy3d.plot3d.primitives.Polygon;
import org.jzy3d.plot3d.primitives.Shape;

public class DelaunayTessellator
extends Tessellator {
    @Override
    public AbstractComposite build(List<Coord3d> coordinates) {
        Shape s = new Shape();
        s.add(this.computePolygons(coordinates));
        return s;
    }

    protected List<Polygon> computePolygons(List<Coord3d> coordinates) {
        DelaunayTriangulation triangulator = new DelaunayTriangulation();
        for (Coord3d coord : coordinates) {
            triangulator.insertPoint(JDTConverter.toJdtPoint(coord));
        }
        ArrayList<Polygon> polygons = new ArrayList<Polygon>(triangulator.trianglesSize());
        Iterator it = triangulator.trianglesIterator();
        while (it.hasNext()) {
            Triangle triangle = (Triangle)it.next();
            if (triangle.isHalfplane()) continue;
            polygons.add(JDTConverter.toJzyPolygon(triangle));
        }
        return polygons;
    }

    @Override
    public AbstractComposite build(float[] x, float[] y, float[] z) {
        throw new RuntimeException("not called");
    }
}

