/*
 * Decompiled with CFR 0.152.
 */
package org.jzy3d.plot3d.primitives;

import com.jogamp.opengl.GL;
import com.jogamp.opengl.glu.GLU;
import java.util.ArrayList;
import java.util.List;
import org.jzy3d.colors.Color;
import org.jzy3d.colors.ColorMapper;
import org.jzy3d.colors.IMultiColorable;
import org.jzy3d.colors.ISingleColorable;
import org.jzy3d.events.DrawableChangedEvent;
import org.jzy3d.maths.BoundingBox3d;
import org.jzy3d.maths.Utils;
import org.jzy3d.plot3d.primitives.AbstractDrawable;
import org.jzy3d.plot3d.primitives.AbstractWireframeable;
import org.jzy3d.plot3d.rendering.view.Camera;
import org.jzy3d.plot3d.transform.Transform;
import org.jzy3d.plot3d.transform.space.SpaceTransformer;

public abstract class AbstractComposite
extends AbstractWireframeable
implements ISingleColorable,
IMultiColorable {
    protected List<AbstractDrawable> components = new ArrayList<AbstractDrawable>();
    protected Transform transform;
    protected ColorMapper mapper;
    protected Color color;
    protected boolean detailedToString = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(List<? extends AbstractDrawable> drawables) {
        List<AbstractDrawable> list = this.components;
        synchronized (list) {
            this.components.addAll(drawables);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        List<AbstractDrawable> list = this.components;
        synchronized (list) {
            this.components.clear();
        }
    }

    public void add(AbstractDrawable drawable) {
        this.components.add(drawable);
    }

    public void remove(AbstractDrawable drawable) {
        this.components.remove(drawable);
    }

    public AbstractDrawable get(int p) {
        return this.components.get(p);
    }

    public List<AbstractDrawable> getDrawables() {
        return this.components;
    }

    public int size() {
        return this.components.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void draw(GL gl, GLU glu, Camera camera) {
        if (this.mapper != null) {
            this.mapper.preDraw(this);
        }
        List<AbstractDrawable> list = this.components;
        synchronized (list) {
            for (AbstractDrawable c : this.components) {
                if (c == null) continue;
                c.draw(gl, glu, camera);
            }
        }
        if (this.mapper != null) {
            this.mapper.postDraw(this);
        }
        this.doDrawBounds(gl, glu, camera);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setTransform(Transform transform) {
        this.transform = transform;
        List<AbstractDrawable> list = this.components;
        synchronized (list) {
            for (AbstractDrawable c : this.components) {
                if (c == null) continue;
                c.setTransform(transform);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setTransformBefore(Transform transform) {
        this.transformBefore = transform;
        List<AbstractDrawable> list = this.components;
        synchronized (list) {
            for (AbstractDrawable c : this.components) {
                if (c == null) continue;
                c.setTransformBefore(transform);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setSpaceTransformer(SpaceTransformer spaceTransformer) {
        this.spaceTransformer = spaceTransformer;
        List<AbstractDrawable> list = this.components;
        synchronized (list) {
            for (AbstractDrawable c : this.components) {
                if (c == null) continue;
                c.setSpaceTransformer(spaceTransformer);
            }
        }
    }

    @Override
    public Transform getTransform() {
        return this.transform;
    }

    @Override
    public BoundingBox3d getBounds() {
        this.updateBounds();
        return this.bbox;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateBounds() {
        BoundingBox3d box = new BoundingBox3d();
        List<AbstractDrawable> list = this.components;
        synchronized (list) {
            for (AbstractDrawable c : this.components) {
                if (c == null || c.getBounds() == null) continue;
                box.add(c.getBounds());
            }
        }
        this.bbox = box;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void applyGeometryTransform(Transform transform) {
        List<AbstractDrawable> list = this.components;
        synchronized (list) {
            for (AbstractDrawable c : this.components) {
                c.applyGeometryTransform(transform);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setWireframeColor(Color color) {
        super.setWireframeColor(color);
        if (this.components != null) {
            List<AbstractDrawable> list = this.components;
            synchronized (list) {
                for (AbstractDrawable c : this.components) {
                    if (c == null || !(c instanceof AbstractWireframeable)) continue;
                    ((AbstractWireframeable)c).setWireframeColor(color);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setWireframeDisplayed(boolean status) {
        super.setWireframeDisplayed(status);
        if (this.components != null) {
            List<AbstractDrawable> list = this.components;
            synchronized (list) {
                for (AbstractDrawable c : this.components) {
                    if (c == null || !(c instanceof AbstractWireframeable)) continue;
                    ((AbstractWireframeable)c).setWireframeDisplayed(status);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setWireframeWidth(float width) {
        super.setWireframeWidth(width);
        if (this.components != null) {
            List<AbstractDrawable> list = this.components;
            synchronized (list) {
                for (AbstractDrawable c : this.components) {
                    if (c == null || !(c instanceof AbstractWireframeable)) continue;
                    ((AbstractWireframeable)c).setWireframeWidth(width);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setFaceDisplayed(boolean status) {
        super.setFaceDisplayed(status);
        if (this.components != null) {
            List<AbstractDrawable> list = this.components;
            synchronized (list) {
                for (AbstractDrawable c : this.components) {
                    if (c == null || !(c instanceof AbstractWireframeable)) continue;
                    ((AbstractWireframeable)c).setFaceDisplayed(status);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setDisplayed(boolean status) {
        super.setDisplayed(status);
        if (this.components != null) {
            List<AbstractDrawable> list = this.components;
            synchronized (list) {
                for (AbstractDrawable c : this.components) {
                    if (c == null || !(c instanceof AbstractWireframeable)) continue;
                    ((AbstractWireframeable)c).setDisplayed(status);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setColorMapper(ColorMapper mapper) {
        this.mapper = mapper;
        if (this.components != null) {
            List<AbstractDrawable> list = this.components;
            synchronized (list) {
                for (AbstractDrawable d : this.components) {
                    if (d instanceof IMultiColorable) {
                        ((IMultiColorable)((Object)d)).setColorMapper(mapper);
                        continue;
                    }
                    if (!(d instanceof ISingleColorable)) continue;
                    ((ISingleColorable)((Object)d)).setColor(mapper.getColor(d.getBarycentre()));
                }
            }
            this.fireDrawableChanged(new DrawableChangedEvent(this, 2));
        }
    }

    @Override
    public ColorMapper getColorMapper() {
        return this.mapper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setColor(Color color) {
        this.color = color;
        if (this.components != null) {
            List<AbstractDrawable> list = this.components;
            synchronized (list) {
                for (AbstractDrawable d : this.components) {
                    if (!(d instanceof ISingleColorable)) continue;
                    ((ISingleColorable)((Object)d)).setColor(color);
                }
            }
            this.fireDrawableChanged(new DrawableChangedEvent(this, 2));
        }
    }

    @Override
    public Color getColor() {
        return this.color;
    }

    @Override
    public String toString() {
        return this.toString(0);
    }

    @Override
    public String toString(int depth) {
        String output = Utils.blanks(depth) + "(Composite3d) #elements:" + this.components.size() + " | isDisplayed=" + this.isDisplayed();
        if (this.detailedToString) {
            int k = 0;
            for (AbstractDrawable c : this.components) {
                if (c != null) {
                    if (c instanceof AbstractComposite) {
                        output = output + "\n" + ((AbstractComposite)c).toString(depth + 1);
                        continue;
                    }
                    output = output + "\n" + Utils.blanks(depth + 1) + " Composite element[" + k++ + "]:" + c.toString();
                    continue;
                }
                output = output + Utils.blanks(depth + 1) + "(null)\n";
            }
        }
        return output;
    }

    public boolean isDetailedToString() {
        return this.detailedToString;
    }

    public void setDetailedToString(boolean detailedToString) {
        this.detailedToString = detailedToString;
    }
}

