/*
 * Decompiled with CFR 0.152.
 */
package org.jzy3d.plot3d.primitives;

import com.jogamp.opengl.GL;
import com.jogamp.opengl.glu.GLU;
import java.util.ArrayList;
import java.util.List;
import org.jzy3d.maths.BoundingBox3d;
import org.jzy3d.maths.Coord3d;
import org.jzy3d.maths.Utils;
import org.jzy3d.plot3d.primitives.AbstractWireframeable;
import org.jzy3d.plot3d.primitives.Point;
import org.jzy3d.plot3d.rendering.compat.GLES2CompatUtils;
import org.jzy3d.plot3d.rendering.view.Camera;
import org.jzy3d.plot3d.transform.Transform;

public class LineStrip
extends AbstractWireframeable {
    protected List<Point> points;
    protected float width;
    protected boolean showPoints = false;
    protected boolean stipple = false;

    public LineStrip() {
        this(2);
    }

    public LineStrip(int n) {
        this.points = new ArrayList<Point>(n);
        this.bbox = new BoundingBox3d();
        for (Point p : this.points) {
            this.bbox.add(p);
        }
        this.setWireframeColor(null);
    }

    public LineStrip(List<Coord3d> coords) {
        this();
        for (Coord3d c : coords) {
            Point p = new Point(c);
            this.add(p);
        }
    }

    public LineStrip(Point c1, Point c2) {
        this();
        this.add(c1);
        this.add(c2);
    }

    @Override
    public void draw(GL gl, GLU glu, Camera cam) {
        this.doTransform(gl, glu, cam);
        this.drawLine(gl);
        this.drawPoints(gl);
    }

    public void drawLine(GL gl) {
        gl.glLineWidth(this.width);
        if (gl.isGL2()) {
            this.drawLineGL2(gl);
        } else {
            this.drawLineGLES2();
        }
    }

    public void drawLineGLES2() {
        GLES2CompatUtils.glBegin(3);
        if (this.wfcolor == null) {
            for (Point p : this.points) {
                GLES2CompatUtils.glColor4f(p.rgb.r, p.rgb.g, p.rgb.b, p.rgb.a);
                GLES2CompatUtils.glVertex3f(p.xyz.x, p.xyz.y, p.xyz.z);
            }
        } else {
            for (Point p : this.points) {
                GLES2CompatUtils.glColor4f(this.wfcolor.r, this.wfcolor.g, this.wfcolor.b, this.wfcolor.a);
                GLES2CompatUtils.glVertex3f(p.xyz.x, p.xyz.y, p.xyz.z);
            }
        }
        GLES2CompatUtils.glEnd();
    }

    public void drawLineGL2(GL gl) {
        gl.getGL2().glBegin(3);
        if (this.stipple) {
            gl.getGL2().glPolygonMode(1029, 6913);
            gl.glEnable(2852);
            gl.getGL2().glLineStipple(1, (short)-21846);
        }
        gl.getGL2().glLineWidth(this.wfwidth);
        if (this.wfcolor == null) {
            for (Point p : this.points) {
                gl.getGL2().glColor4f(p.rgb.r, p.rgb.g, p.rgb.b, p.rgb.a);
                gl.getGL2().glVertex3f(p.xyz.x, p.xyz.y, p.xyz.z);
            }
        } else {
            for (Point p : this.points) {
                gl.getGL2().glColor4f(this.wfcolor.r, this.wfcolor.g, this.wfcolor.b, this.wfcolor.a);
                gl.getGL2().glVertex3f(p.xyz.x, p.xyz.y, p.xyz.z);
            }
        }
        gl.getGL2().glEnd();
    }

    public void drawPoints(GL gl) {
        if (this.showPoints) {
            if (gl.isGL2()) {
                this.drawPointsGL2(gl);
            } else {
                this.drawPointsGLES2();
            }
        }
    }

    public void drawPointsGLES2() {
        GLES2CompatUtils.glBegin(0);
        for (Point p : this.points) {
            if (this.wfcolor == null) {
                GLES2CompatUtils.glColor4f(p.rgb.r, p.rgb.g, p.rgb.b, p.rgb.a);
            } else {
                GLES2CompatUtils.glColor4f(this.wfcolor.r, this.wfcolor.g, this.wfcolor.b, this.wfcolor.a);
            }
            GLES2CompatUtils.glVertex3f(p.xyz.x, p.xyz.y, p.xyz.z);
        }
        GLES2CompatUtils.glEnd();
    }

    public void drawPointsGL2(GL gl) {
        gl.getGL2().glBegin(0);
        gl.getGL2().glPointSize(this.wfwidth);
        for (Point p : this.points) {
            if (this.wfcolor == null) {
                gl.getGL2().glColor4f(p.rgb.r, p.rgb.g, p.rgb.b, p.rgb.a);
            } else {
                gl.getGL2().glColor4f(this.wfcolor.r, this.wfcolor.g, this.wfcolor.b, this.wfcolor.a);
            }
            gl.getGL2().glVertex3f(p.xyz.x, p.xyz.y, p.xyz.z);
        }
        gl.getGL2().glEnd();
    }

    @Override
    public void applyGeometryTransform(Transform transform) {
        for (Point p : this.points) {
            p.xyz = transform.compute(p.xyz);
        }
        this.updateBounds();
    }

    @Override
    public void updateBounds() {
        this.bbox.reset();
        for (Point p : this.points) {
            this.bbox.add(p);
        }
    }

    public void add(Point point) {
        this.points.add(point);
        this.bbox.add(point);
    }

    public void add(Coord3d coord3d) {
        this.add(new Point(coord3d));
    }

    public void addAll(List<Point> points) {
        for (Point p : points) {
            this.add(p);
        }
    }

    public void addAll(LineStrip strip) {
        this.addAll(strip.getPoints());
    }

    public void clear() {
        this.points.clear();
        this.updateBounds();
    }

    public Point get(int p) {
        return this.points.get(p);
    }

    public Point getLastPoint() {
        int last = this.points.size() - 1;
        if (last >= 0) {
            return this.points.get(last);
        }
        return null;
    }

    public List<Point> getPoints() {
        return this.points;
    }

    public int size() {
        return this.points.size();
    }

    public void setWidth(float width) {
        this.width = width;
    }

    public boolean isShowPoints() {
        return this.showPoints;
    }

    public void setShowPoints(boolean showPoints) {
        this.showPoints = showPoints;
    }

    public boolean isStipple() {
        return this.stipple;
    }

    public void setStipple(boolean stipple) {
        this.stipple = stipple;
    }

    @Override
    public double getDistance(Camera camera) {
        return this.getBarycentre().distance(camera.getEye());
    }

    @Override
    public double getShortestDistance(Camera camera) {
        double min = 3.4028234663852886E38;
        double dist = 0.0;
        for (Point point : this.points) {
            dist = point.getDistance(camera);
            if (!(dist < min)) continue;
            min = dist;
        }
        return min;
    }

    @Override
    public double getLongestDistance(Camera camera) {
        double max = 0.0;
        double dist = 0.0;
        for (Point point : this.points) {
            dist = point.getDistance(camera);
            if (!(dist < max)) continue;
            max = dist;
        }
        return max;
    }

    public static LineStrip merge(LineStrip strip1, LineStrip strip2) {
        double da;
        Coord3d a = strip1.get((int)0).xyz;
        Coord3d b = strip1.get((int)(strip1.size() - 1)).xyz;
        Coord3d c = strip2.get((int)0).xyz;
        Coord3d d = strip2.get((int)(strip2.size() - 1)).xyz;
        double bc = b.distance(c);
        if (bc > (da = d.distance(a))) {
            strip1.addAll(strip2);
            return strip1;
        }
        strip2.addAll(strip1);
        return strip2;
    }

    @Override
    public String toString(int depth) {
        return Utils.blanks(depth) + "(LineStrip) #points:" + this.points.size();
    }
}

