/*
 * Decompiled with CFR 0.152.
 */
package org.jzy3d.plot3d.primitives;

import com.jogamp.opengl.GL;
import com.jogamp.opengl.glu.GLU;
import java.util.ArrayList;
import java.util.List;
import org.jzy3d.colors.ColorMapper;
import org.jzy3d.colors.IMultiColorable;
import org.jzy3d.maths.BoundingBox3d;
import org.jzy3d.maths.Coord3d;
import org.jzy3d.plot3d.primitives.AbstractDrawable;
import org.jzy3d.plot3d.rendering.compat.GLES2CompatUtils;
import org.jzy3d.plot3d.rendering.view.Camera;
import org.jzy3d.plot3d.transform.Transform;

public class ScatterMultiColorList
extends AbstractDrawable
implements IMultiColorable {
    protected List<Coord3d> coordinates;
    protected float width;
    protected ColorMapper mapper;

    public ScatterMultiColorList(ColorMapper mapper) {
        this(new ArrayList<Coord3d>(), mapper, 1.0f);
    }

    public ScatterMultiColorList(List<Coord3d> coordinates, ColorMapper mapper) {
        this(coordinates, mapper, 1.0f);
    }

    public ScatterMultiColorList(List<Coord3d> coordinates, ColorMapper mapper, float width) {
        this.bbox = new BoundingBox3d();
        this.setData(coordinates);
        this.setWidth(width);
        this.setColorMapper(mapper);
    }

    public void clear() {
        this.coordinates.clear();
        this.updateBounds();
    }

    @Override
    public void draw(GL gl, GLU glu, Camera cam) {
        this.doTransform(gl, glu, cam);
        if (gl.isGL2()) {
            this.drawGL2(gl);
        } else {
            this.drawGLES2();
        }
        this.doDrawBounds(gl, glu, cam);
    }

    public void drawGLES2() {
        GLES2CompatUtils.glPointSize(this.width);
        GLES2CompatUtils.glBegin(0);
        if (this.coordinates != null) {
            for (Coord3d coord : this.coordinates) {
                this.colorGLES2(this.mapper.getColor(coord));
                this.vertexGLES2(coord);
            }
        }
        GLES2CompatUtils.glEnd();
    }

    public void drawGL2(GL gl) {
        gl.getGL2().glPointSize(this.width);
        gl.getGL2().glBegin(0);
        if (this.coordinates != null) {
            for (Coord3d coord : this.coordinates) {
                this.colorGL2(gl, this.mapper.getColor(coord));
                this.vertexGL2(gl, coord);
            }
        }
        gl.getGL2().glEnd();
    }

    @Override
    public void applyGeometryTransform(Transform transform) {
        for (Coord3d c : this.coordinates) {
            c.set(transform.compute(c));
        }
        this.updateBounds();
    }

    @Override
    public void updateBounds() {
        this.bbox.reset();
        for (Coord3d c : this.coordinates) {
            this.bbox.add(c);
        }
    }

    public void setData(List<Coord3d> coordinates) {
        this.coordinates = coordinates;
        this.bbox.reset();
        for (Coord3d c : coordinates) {
            this.bbox.add(c);
        }
    }

    public List<Coord3d> getData() {
        return this.coordinates;
    }

    public void add(Coord3d c) {
        this.coordinates.add(c);
    }

    @Override
    public ColorMapper getColorMapper() {
        return this.mapper;
    }

    @Override
    public void setColorMapper(ColorMapper mapper) {
        this.mapper = mapper;
    }

    public void setWidth(float width) {
        this.width = width;
    }
}

