/*
 * Decompiled with CFR 0.152.
 */
package org.jzy3d.plot3d.primitives;

import com.jogamp.opengl.GL;
import org.jzy3d.plot3d.primitives.AbstractComposite;
import org.jzy3d.plot3d.primitives.Point;
import org.jzy3d.plot3d.primitives.Polygon;
import org.jzy3d.plot3d.rendering.compat.GLES2CompatUtils;

public class TesselatedPolygon
extends AbstractComposite {
    public TesselatedPolygon(Point[] points) {
        Polygon p1 = this.newTriangle();
        p1.add(points[0]);
        p1.add(points[1]);
        p1.add(points[2]);
        this.add(p1);
        Polygon p2 = this.newTriangle();
        p2.add(points[2]);
        p2.add(points[3]);
        p2.add(points[0]);
        this.add(p2);
    }

    protected Polygon newTriangle() {
        return new Polygon(){

            @Override
            protected void begin(GL gl) {
                if (gl.isGL2()) {
                    gl.getGL2().glBegin(4);
                } else {
                    GLES2CompatUtils.glBegin(4);
                }
            }

            @Override
            protected void callPointForWireframe(GL gl) {
                if (gl.isGL2()) {
                    gl.getGL2().glColor4f(this.wfcolor.r, this.wfcolor.g, this.wfcolor.b, this.wfcolor.a);
                    gl.glLineWidth(this.wfwidth);
                    this.beginWireWithLineStrip(gl);
                    for (Point p : this.points) {
                        gl.getGL2().glVertex3f(p.xyz.x, p.xyz.y, p.xyz.z);
                    }
                    this.end(gl);
                } else {
                    GLES2CompatUtils.glColor4f(this.wfcolor.r, this.wfcolor.g, this.wfcolor.b, this.wfcolor.a);
                    gl.glLineWidth(this.wfwidth);
                    this.beginWireWithLineStrip(gl);
                    for (Point p : this.points) {
                        GLES2CompatUtils.glVertex3f(p.xyz.x, p.xyz.y, p.xyz.z);
                    }
                    this.end(gl);
                }
            }

            protected void beginWireWithLineStrip(GL gl) {
                if (gl.isGL2()) {
                    gl.getGL2().glBegin(3);
                } else {
                    GLES2CompatUtils.glBegin(3);
                }
            }
        };
    }
}

