/*
 * Decompiled with CFR 0.152.
 */
package org.jzy3d.plot3d.primitives;

import java.util.List;
import org.jzy3d.colors.Color;
import org.jzy3d.colors.ColorMapper;
import org.jzy3d.plot3d.primitives.AbstractDrawable;
import org.jzy3d.plot3d.primitives.ColoredWireframePolygon;
import org.jzy3d.plot3d.primitives.Polygon;
import org.jzy3d.plot3d.primitives.Shape;

public class WaterfallComposite
extends Shape {
    public void add(ColoredWireframePolygon outline, Shape fill) {
        List<AbstractDrawable> drawables = fill.getDrawables();
        for (AbstractDrawable dr : drawables) {
            if (!(dr instanceof Polygon)) continue;
            Polygon p = (Polygon)dr;
            p.setPolygonOffsetFactor(1.0f);
            p.setPolygonOffsetUnit(1.0f);
            p.setPolygonOffsetFillEnable(true);
            p.setWireframeDisplayed(false);
            p.setColor(Color.WHITE);
        }
        outline.setPolygonOffsetFillEnable(true);
        outline.setPolygonOffsetFactor(-1.0f);
        outline.setPolygonOffsetUnit(-1.0f);
        outline.setWireframeColor(Color.BLACK);
        outline.setFaceDisplayed(false);
        this.add(outline);
        this.add(fill);
    }

    @Override
    public void setWireframeWidth(float width) {
        if (this.getDrawables() == null) {
            return;
        }
        for (AbstractDrawable d : this.getDrawables()) {
            if (!(d instanceof ColoredWireframePolygon)) continue;
            ((ColoredWireframePolygon)d).setWireframeWidth(width);
        }
    }

    @Override
    public void setColorMapper(ColorMapper mapper) {
        for (AbstractDrawable d : this.getDrawables()) {
            if (!(d instanceof ColoredWireframePolygon)) continue;
            ((ColoredWireframePolygon)d).setColorMapper(mapper);
        }
    }

    @Override
    public void setColor(Color color) {
        for (AbstractDrawable d : this.getDrawables()) {
            if (!(d instanceof ColoredWireframePolygon)) continue;
            ((ColoredWireframePolygon)d).setWireframeColor(color);
        }
    }
}

