/*
 * Decompiled with CFR 0.152.
 */
package org.jzy3d.plot3d.primitives.axes.layout.providers;

import org.jzy3d.plot3d.primitives.axes.layout.providers.AbstractTickProvider;
import org.jzy3d.plot3d.primitives.axes.layout.providers.ITickProvider;

public class SmartTickProvider
extends AbstractTickProvider
implements ITickProvider {
    protected int steps;

    public SmartTickProvider() {
        this(5);
    }

    public SmartTickProvider(int steps) {
        this.steps = steps;
    }

    @Override
    public double[] generateTicks(double min, double max, int steps) {
        if (min == max) {
            double[] ticks = new double[]{min};
            return ticks;
        }
        if (min > max) {
            return new double[0];
        }
        double absscale = Math.floor(Math.log10(max - min));
        double relscale = Math.log10(max - min) - absscale;
        double ticksize = 0.0;
        ticksize = relscale < Math.log10(0.2 * (double)steps) ? Math.pow(10.0, absscale) * 0.2 : (relscale < Math.log10(0.5 * (double)steps) ? Math.pow(10.0, absscale) * 0.5 : (relscale < Math.log10(1 * steps) ? Math.pow(10.0, absscale) * 1.0 : Math.pow(10.0, absscale) * 2.0));
        double start = (int)Math.ceil(min / ticksize);
        double stop = (int)Math.floor(max / ticksize);
        double[] ticks = new double[(int)(stop - start + 1.0)];
        for (double t = start; t <= stop; t += 1.0) {
            ticks[(int)(t - start)] = t * ticksize;
        }
        return ticks;
    }

    @Override
    public int getDefaultSteps() {
        return this.steps;
    }
}

