/*
 * Decompiled with CFR 0.152.
 */
package org.jzy3d.plot3d.primitives.enlightables;

import com.jogamp.opengl.GL;
import com.jogamp.opengl.glu.GLU;
import com.jogamp.opengl.glu.GLUquadric;
import org.jzy3d.colors.Color;
import org.jzy3d.colors.ISingleColorable;
import org.jzy3d.events.DrawableChangedEvent;
import org.jzy3d.maths.BoundingBox3d;
import org.jzy3d.maths.Coord3d;
import org.jzy3d.plot3d.primitives.enlightables.AbstractEnlightable;
import org.jzy3d.plot3d.rendering.compat.GLES2CompatUtils;
import org.jzy3d.plot3d.rendering.view.Camera;
import org.jzy3d.plot3d.transform.Transform;

public class EnlightableDisk
extends AbstractEnlightable
implements ISingleColorable {
    private float x;
    private float y;
    private float z;
    private int slices;
    private int loops;
    private float radiusInner;
    private float radiusOuter;
    private Color color;
    protected Coord3d norm;

    public EnlightableDisk() {
        this(Coord3d.ORIGIN, 0.0f, 10.0f, 15, 15, Color.BLACK, true);
    }

    public EnlightableDisk(Coord3d position, float radiusInner, float radiusOuter, int slices, int loops, Color color, boolean faceup) {
        this.bbox = new BoundingBox3d();
        this.norm = faceup ? new Coord3d(0.0f, 0.0f, 1.0f) : new Coord3d(0.0f, 0.0f, -1.0f);
        this.setPosition(position);
        this.setVolume(radiusInner, radiusOuter);
        this.setSlicing(slices, loops);
        this.setColor(color);
    }

    @Override
    public void draw(GL gl, GLU glu, Camera cam) {
        this.doTransform(gl, glu, cam);
        if (gl.isGL2()) {
            gl.getGL2().glTranslatef(this.x, this.y, this.z);
        } else {
            GLES2CompatUtils.glTranslatef(this.x, this.y, this.z);
        }
        this.applyMaterial(gl);
        gl.glLineWidth(this.wfwidth);
        GLUquadric qobj = glu.gluNewQuadric();
        if (gl.isGL2()) {
            if (this.facestatus) {
                if (this.wfstatus) {
                    gl.glEnable(32823);
                    gl.glPolygonOffset(1.0f, 1.0f);
                }
                gl.getGL2().glPolygonMode(1032, 6914);
                gl.getGL2().glNormal3f(this.norm.x, this.norm.y, this.norm.z);
                gl.getGL2().glColor4f(this.color.r, this.color.g, this.color.b, this.color.a);
                glu.gluDisk(qobj, (double)this.radiusInner, (double)this.radiusOuter, this.slices, this.loops);
                if (this.wfstatus) {
                    gl.glDisable(32823);
                }
            }
            if (this.wfstatus) {
                gl.getGL2().glPolygonMode(1032, 6913);
                gl.getGL2().glNormal3f(this.norm.x, this.norm.y, this.norm.z);
                gl.getGL2().glColor4f(this.wfcolor.r, this.wfcolor.g, this.wfcolor.b, this.wfcolor.a);
                glu.gluDisk(qobj, (double)this.radiusInner, (double)this.radiusOuter, this.slices, this.loops);
            }
        } else {
            if (this.facestatus) {
                if (this.wfstatus) {
                    gl.glEnable(32823);
                    gl.glPolygonOffset(1.0f, 1.0f);
                }
                GLES2CompatUtils.glPolygonMode(1032, 6914);
                GLES2CompatUtils.glNormal3f(this.norm.x, this.norm.y, this.norm.z);
                GLES2CompatUtils.glColor4f(this.color.r, this.color.g, this.color.b, this.color.a);
                glu.gluDisk(qobj, (double)this.radiusInner, (double)this.radiusOuter, this.slices, this.loops);
                if (this.wfstatus) {
                    gl.glDisable(32823);
                }
            }
            if (this.wfstatus) {
                GLES2CompatUtils.glPolygonMode(1032, 6913);
                GLES2CompatUtils.glNormal3f(this.norm.x, this.norm.y, this.norm.z);
                GLES2CompatUtils.glColor4f(this.wfcolor.r, this.wfcolor.g, this.wfcolor.b, this.wfcolor.a);
                glu.gluDisk(qobj, (double)this.radiusInner, (double)this.radiusOuter, this.slices, this.loops);
            }
        }
    }

    @Override
    public void applyGeometryTransform(Transform transform) {
        Coord3d change = transform.compute(new Coord3d(this.x, this.y, this.z));
        this.x = change.x;
        this.y = change.y;
        this.z = change.z;
        this.updateBounds();
    }

    @Override
    public void updateBounds() {
        this.bbox.reset();
        this.bbox.add(this.x + this.radiusOuter, this.y + this.radiusOuter, this.z);
        this.bbox.add(this.x - this.radiusOuter, this.y - this.radiusOuter, this.z);
    }

    public void setData(Coord3d position, float radiusInner, float radiusOuter, int slices, int loops) {
        this.setPosition(position);
        this.setVolume(radiusInner, radiusOuter);
        this.setSlicing(slices, loops);
    }

    public void setPosition(Coord3d position) {
        this.x = position.x;
        this.y = position.y;
        this.z = position.z;
        this.updateBounds();
    }

    public void setVolume(float radiusInner, float radiusOuter) {
        if (radiusOuter < radiusInner) {
            throw new IllegalArgumentException("inner radius must be smaller than outer radius");
        }
        this.radiusInner = radiusInner;
        this.radiusOuter = radiusOuter;
        this.updateBounds();
    }

    public void setSlicing(int verticalWires, int horizontalWires) {
        this.slices = verticalWires;
        this.loops = horizontalWires;
    }

    @Override
    public void setColor(Color color) {
        this.color = color;
        this.fireDrawableChanged(new DrawableChangedEvent(this, 2));
    }

    @Override
    public Color getColor() {
        return this.color;
    }
}

